/*
 * Decompiled with CFR 0.152.
 */
package com.sap.bi.ext.eclipse;

import com.sap.bi.ext.eclipse.PublicPartFileInputProvider;
import com.sap.tc.complib.provider.DCInputProvider;
import com.sap.tc.complib.provider.PPInputProvider;
import com.sap.tc.complib.provider.ProviderException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;

public class DevelopmentComponentFileInputProvider
implements DCInputProvider {
    private File theFile;
    private InputStream theInput;

    public DevelopmentComponentFileInputProvider(File aDcDef) {
        this.theFile = aDcDef;
    }

    public InputStream getStreamForDC() throws ProviderException {
        try {
            this.theInput = new FileInputStream(this.theFile);
        }
        catch (FileNotFoundException e) {
            throw new ProviderException(e.getMessage(), (Throwable)e);
        }
        return this.theInput;
    }

    public void releaseStream(InputStream inputStream) {
    }

    public String[] getPublicParts() throws ProviderException {
        File[] ppFiles;
        String[] thePPNames = new String[]{};
        File theDCFolder = this.theFile.getParentFile();
        FilenameFilter aDefFilter = new FilenameFilter(){

            public boolean accept(File aDie, String aName) {
                return aName.equals("def");
            }
        };
        FilenameFilter aPPFilter = new FilenameFilter(){

            public boolean accept(File aDie, String aName) {
                return aName.endsWith(".pp");
            }
        };
        File[] aDefFile = theDCFolder.listFiles(aDefFilter);
        if (aDefFile.length > 0 && (ppFiles = aDefFile[0].listFiles(aPPFilter)).length > 0) {
            thePPNames = new String[ppFiles.length];
            int i = 0;
            while (i < ppFiles.length) {
                thePPNames[i] = ppFiles[i].getName().substring(0, ppFiles[i].getName().length() - 3);
                ++i;
            }
        }
        return thePPNames;
    }

    public PPInputProvider getPPInputProvider(String string) throws ProviderException {
        File[] ppFiles;
        PublicPartFileInputProvider aPPProvider = null;
        final String aPPName = string;
        File theDCFolder = this.theFile.getParentFile();
        FilenameFilter aDefFilter = new FilenameFilter(){

            public boolean accept(File aDie, String aName) {
                return aName.equals("def");
            }
        };
        FilenameFilter aPPFilter = new FilenameFilter(){

            public boolean accept(File aDie, String aName) {
                return aName.equals(aPPName + ".pp");
            }
        };
        File[] aDefFile = theDCFolder.listFiles(aDefFilter);
        if (aDefFile.length > 0 && (ppFiles = aDefFile[0].listFiles(aPPFilter)).length > 0) {
            aPPProvider = new PublicPartFileInputProvider(ppFiles[0]);
        }
        return aPPProvider;
    }
}

