/*
 * Decompiled with CFR 0.152.
 */
package com.sap.bi.ext.eclipse;

import com.sap.bi.ext.AbstractAntTask;
import com.sap.bi.ext.ExceptionUtil;
import com.sap.bi.ext.PathUtils;
import com.sap.bi.ext.eclipse.CreateEclipsePluginWrapperDC;
import com.sap.bi.ext.eclipse.PluginNamingException;
import com.sap.sdm.ant.Component;
import com.sap.sdm.ant.JarSAP;
import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.util.FileUtils;

public class CreateEclipsePluginWrapperDCTask
extends AbstractAntTask {
    public static final String SC_NAME_EC_ECLIPSE = "EC-ECLIPSE";
    public static final String SC_VENDOR_EC_EC_ECLIPSE = "sap.com";
    public static final String XSLT_RESOURCE = "com/sap/bi/ext/eclipse/plugInToDc.xslt";
    private File targetDir;
    private File eclipseDir;

    public void setTargetdir(File dir) {
        if (dir == null) {
            throw new BuildException("attribute targetdir is undefined");
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.targetDir = dir;
        this.log("targetdir : " + this.targetDir);
    }

    public void setEclipsedir(File dir) {
        if (dir == null) {
            throw new BuildException("attribute eclipsedir is undefined");
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.eclipseDir = dir;
        this.log("eclipsedir : " + this.eclipseDir);
    }

    public void execute() throws BuildException {
        try {
            CreateEclipsePluginWrapperDC aPluginWrapper = new CreateEclipsePluginWrapperDC(this, this.targetDir, this.eclipseDir);
            aPluginWrapper.execute();
        }
        catch (Exception e) {
            throw new BuildException(ExceptionUtil.printStackTrace(e), this.getLocation());
        }
    }

    void buildPluginZip(String aPlugInDir) throws IOException {
        FileUtils u = FileUtils.newFileUtils();
        File pluginDir = u.normalize(aPlugInDir);
        Project proj = this.getProject();
        this.log("creating filesystem SDA");
        JarSAP zip = new JarSAP();
        zip.setProject(this.getProject());
        zip.setTaskName(this.getTaskName() + ".jarSAP");
        this.log("basedir : " + aPlugInDir, 4);
        File parentDir = new File(pluginDir.getParent());
        zip.setBasedir(parentDir.getCanonicalPath());
        zip.setIncludes(pluginDir.getName() + "/**");
        String dcName = "";
        try {
            dcName = CreateEclipsePluginWrapperDC.getDCNameFromPlugInDir(this.eclipseDir.getCanonicalPath() + File.separator, "plugins/" + pluginDir.getName() + "/");
        }
        catch (PluginNamingException e) {
            e.printStackTrace();
        }
        this.log("dcName : " + dcName);
        String deployDirPath = PathUtils.getPathForDeploy(this.targetDir, dcName, proj.getProperty("vendor"), "default");
        File deployDir = new File(deployDirPath);
        deployDir.mkdirs();
        File jarFile = u.normalize(deployDirPath + File.separator + "plugin.sda");
        this.log("jarfile : " + jarFile.getCanonicalPath(), 4);
        zip.setJarfile(jarFile.getCanonicalPath());
        File deployFile = new File(proj.getBaseDir() + File.separator + "sda.xml");
        this.log("deployfile : " + deployFile.getCanonicalPath(), 4);
        zip.setDeployfile(deployFile.getCanonicalPath());
        Component comp = zip.createComponent();
        comp.setCounter(proj.getProperty("counter"));
        comp.setLocation(proj.getProperty("location"));
        comp.setVendor(proj.getProperty("vendor"));
        comp.setName(dcName);
        zip.execute();
        this.decrIndent();
    }

    public void decreaseIndent() {
        this.decrIndent();
    }

    public void increaseIndent() {
        this.incrIndent();
    }
}

