/*
 * Decompiled with CFR 0.152.
 */
package com.sap.bi.ext.eclipse;

import com.sap.bi.ext.PathUtils;
import com.sap.bi.ext.eclipse.CreateEclipsePluginWrapperDCTask;
import com.sap.bi.ext.eclipse.DevelopmentComponentFileInputProvider;
import com.sap.bi.ext.eclipse.ExtensionFunctions;
import com.sap.bi.ext.eclipse.PluginNamingException;
import com.sap.tc.complib.ComponentFactory;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.provider.DCInputProvider;
import com.sap.tc.complib.provider.ProviderException;
import com.sap.tc.complib.xml.XMLException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.processor.TransformerFactoryImpl;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public final class CreateEclipsePluginWrapperDC {
    public static final String SC_NAME_EC_ECLIPSE = "EC-ECLIPSE";
    public static final String SC_VENDOR_EC_EC_ECLIPSE = "Eclispe.org";
    private CreateEclipsePluginWrapperDCTask theEnvironment;
    private final File theTargetDir;
    private final File theEclipseDir;
    private Transformer thePluginTransformer;
    private Transformer theDublicatesTransformer;
    private static final String PLUGIN_XSLT_RESOURCE = "com/sap/bi/ext/eclipse/plugInToDc.xslt";
    private static final String DUBLICATES_XSLT_RESOURCE = "com/sap/bi/ext/eclipse/extractDublicates.xslt";
    static /* synthetic */ Class class$com$sap$bi$ext$eclipse$CreateEclipsePluginWrapperDC;

    public CreateEclipsePluginWrapperDC(File aTargetDir, File anEclipseDir) {
        this.theTargetDir = aTargetDir;
        this.theEclipseDir = anEclipseDir;
    }

    public CreateEclipsePluginWrapperDC(CreateEclipsePluginWrapperDCTask anEnvironment, File aTargetDir, File anEclipseDir) {
        this.theEnvironment = anEnvironment;
        this.theTargetDir = aTargetDir;
        this.theEclipseDir = anEclipseDir;
    }

    public final String getEclipseDir() throws IOException {
        String absolutePathToEclipseDir = this.theEclipseDir.getCanonicalPath() + File.separator;
        absolutePathToEclipseDir.replace('\\', '/');
        return absolutePathToEclipseDir;
    }

    public final String getWorkSpaceDir() throws IOException {
        String absolutePathToWorkSpace = this.theTargetDir.getCanonicalPath() + File.separator;
        absolutePathToWorkSpace.replace('\\', '/');
        return absolutePathToWorkSpace;
    }

    public static void main(String[] args) throws TransformerException, TransformerConfigurationException, FileNotFoundException, IOException, PluginNamingException {
        String absolutePathToWorkSpace = args[0];
        String absolutePathToEclipseDir = args[1];
        String relativePathToPlugin = null;
        if (args.length > 2) {
            relativePathToPlugin = args[2];
        }
        CreateEclipsePluginWrapperDC aPluginDCWrapper = new CreateEclipsePluginWrapperDC(new File(absolutePathToWorkSpace), new File(absolutePathToEclipseDir));
        if (relativePathToPlugin == null) {
            aPluginDCWrapper.execute();
        } else {
            ArrayList<String> onePluginList = new ArrayList<String>();
            onePluginList.add(relativePathToPlugin);
            ArrayList oneDCDir = aPluginDCWrapper.setUpDirectoryStruct(onePluginList, absolutePathToWorkSpace);
            File pluginXML = new File(absolutePathToEclipseDir + relativePathToPlugin + "plugin.xml");
            if (pluginXML.exists()) {
                aPluginDCWrapper.transformPlugin(absolutePathToEclipseDir, absolutePathToEclipseDir + relativePathToPlugin, (String)oneDCDir.get(0));
            } else {
                aPluginDCWrapper.transformFragment(absolutePathToEclipseDir, absolutePathToEclipseDir + relativePathToPlugin, (String)oneDCDir.get(0));
            }
        }
    }

    private synchronized Transformer getPluginTransformer() throws TransformerConfigurationException {
        if (this.thePluginTransformer == null) {
            InputStream aPluginXSLTInput = (class$com$sap$bi$ext$eclipse$CreateEclipsePluginWrapperDC == null ? (class$com$sap$bi$ext$eclipse$CreateEclipsePluginWrapperDC = CreateEclipsePluginWrapperDC.class$("com.sap.bi.ext.eclipse.CreateEclipsePluginWrapperDC")) : class$com$sap$bi$ext$eclipse$CreateEclipsePluginWrapperDC).getClassLoader().getResourceAsStream(PLUGIN_XSLT_RESOURCE);
            TransformerFactoryImpl tFactory = new TransformerFactoryImpl();
            this.thePluginTransformer = tFactory.newTransformer(new StreamSource(aPluginXSLTInput));
        }
        return this.thePluginTransformer;
    }

    private synchronized Transformer getCopyWithOutDublicatesTransformer() throws TransformerConfigurationException {
        if (this.theDublicatesTransformer == null) {
            InputStream aPluginXSLTInput = (class$com$sap$bi$ext$eclipse$CreateEclipsePluginWrapperDC == null ? (class$com$sap$bi$ext$eclipse$CreateEclipsePluginWrapperDC = CreateEclipsePluginWrapperDC.class$("com.sap.bi.ext.eclipse.CreateEclipsePluginWrapperDC")) : class$com$sap$bi$ext$eclipse$CreateEclipsePluginWrapperDC).getClassLoader().getResourceAsStream(DUBLICATES_XSLT_RESOURCE);
            TransformerFactoryImpl tFactory = new TransformerFactoryImpl();
            this.theDublicatesTransformer = tFactory.newTransformer(new StreamSource(aPluginXSLTInput));
        }
        return this.theDublicatesTransformer;
    }

    public void execute() throws TransformerException, TransformerConfigurationException, FileNotFoundException, IOException, PluginNamingException {
        String absolutePathToWorkSpace = this.getWorkSpaceDir();
        String absolutePathToEclipseDir = this.getEclipseDir();
        ArrayList theListOfPlugInDirs = this.getPluginDirs(absolutePathToEclipseDir);
        ArrayList theListOfFragmentDirs = this.getFragmentDirs(absolutePathToEclipseDir);
        ArrayList theListOfDCPluginDirs = this.setUpDirectoryStruct(theListOfPlugInDirs, absolutePathToWorkSpace);
        ArrayList theListOfDCFragmentDirs = this.setUpDirectoryStruct(theListOfFragmentDirs, absolutePathToWorkSpace);
        this.log("class path : " + System.getProperty("java.class.path"), 4);
        this.log("Creating wrapper components for eclipse plugins and fragments ...");
        Iterator anPlugInDirIter = ((AbstractList)theListOfPlugInDirs).iterator();
        int counter = 0;
        while (anPlugInDirIter.hasNext()) {
            String aPlugInDir = absolutePathToEclipseDir + (String)anPlugInDirIter.next();
            String aDCOutPutDir = (String)theListOfDCPluginDirs.get(counter++);
            this.increaseIndent();
            this.log("--->Start transforming plugin : no: " + counter + " " + aPlugInDir);
            this.log("pluginDir : " + aPlugInDir, 4);
            this.log("DCDir : " + aDCOutPutDir, 4);
            this.log("parEclipseDir : " + absolutePathToEclipseDir, 4);
            this.transformPlugin(absolutePathToEclipseDir, aPlugInDir, aDCOutPutDir);
            this.log("--->End transforming plugin : no: " + counter + " " + aPlugInDir);
            this.buildPluginZip(aPlugInDir);
        }
        Iterator aFragmentDirIter = ((AbstractList)theListOfFragmentDirs).iterator();
        counter = 0;
        while (aFragmentDirIter.hasNext()) {
            String aFragmentDir = absolutePathToEclipseDir + (String)aFragmentDirIter.next();
            String aDCOutPutDir = (String)theListOfDCFragmentDirs.get(counter++);
            this.increaseIndent();
            this.log("--->Start transforming fragment: no: " + counter + " " + aFragmentDir);
            this.log("fragmentDir : " + aFragmentDir, 4);
            this.log("DCDir : " + aDCOutPutDir, 4);
            this.log("parEclipseDir : " + absolutePathToEclipseDir, 4);
            this.transformFragment(absolutePathToEclipseDir, aFragmentDir, aDCOutPutDir);
            this.log("--->End transforming fragment: no: " + counter + " " + aFragmentDir);
            this.buildPluginZip(aFragmentDir);
        }
        this.log("creation of wrapper DCs for eclipse plugins and fragments done");
    }

    public void transformFragment(String absolutePathToEclipseDir, String aFragmentDir, String aDCOutPutDir) throws TransformerConfigurationException, TransformerException, FileNotFoundException {
        Transformer pluginTransformer = this.getPluginTransformer();
        pluginTransformer.setParameter("parPlugInDir", aFragmentDir);
        pluginTransformer.setParameter("parDCDir", aDCOutPutDir);
        pluginTransformer.setParameter("parEclipseDir", absolutePathToEclipseDir);
        pluginTransformer.transform(new StreamSource(aFragmentDir + "fragment.xml"), new StreamResult(new FileOutputStream(aDCOutPutDir + ".dcdef_")));
        Transformer dublicatesTransformer = this.getCopyWithOutDublicatesTransformer();
        dublicatesTransformer.transform(new StreamSource(aDCOutPutDir + ".dcdef_"), new StreamResult(new FileOutputStream(aDCOutPutDir + ".dcdef")));
        this.log("Validating fragement dcdef file and pps:" + aDCOutPutDir + ".dcdef");
        DevelopmentComponent aTestDC = ComponentFactory.createDevelopmentComponent();
        try {
            aTestDC.initialize((DCInputProvider)new DevelopmentComponentFileInputProvider(new File(aDCOutPutDir + ".dcdef")), true);
        }
        catch (IOException e) {
            this.log("-->ERROR: " + e.getMessage());
        }
        catch (XMLException e) {
            this.log("-->ERROR: " + e.getMessage());
        }
        catch (ProviderException e) {
            this.log("-->ERROR: " + e.getMessage());
        }
    }

    public void transformPlugin(String absolutePathToEclipseDir, String aPlugInDir, String aDCOutPutDir) throws TransformerConfigurationException, TransformerException, FileNotFoundException {
        Transformer pluginTransformer = this.getPluginTransformer();
        pluginTransformer.setParameter("parPlugInDir", aPlugInDir);
        pluginTransformer.setParameter("parDCDir", aDCOutPutDir);
        pluginTransformer.setParameter("parEclipseDir", absolutePathToEclipseDir);
        pluginTransformer.transform(new StreamSource(aPlugInDir + "plugin.xml"), new StreamResult(new FileOutputStream(aDCOutPutDir + ".dcdef_")));
        Transformer dublicatesTransformer = this.getCopyWithOutDublicatesTransformer();
        dublicatesTransformer.transform(new StreamSource(aDCOutPutDir + ".dcdef_"), new StreamResult(new FileOutputStream(aDCOutPutDir + ".dcdef")));
        this.log("Validating plugin dcdef file and pps:" + aDCOutPutDir + ".dcdef");
        DevelopmentComponent aTestDC = ComponentFactory.createDevelopmentComponent();
        try {
            aTestDC.initialize((DCInputProvider)new DevelopmentComponentFileInputProvider(new File(aDCOutPutDir + ".dcdef")), true);
        }
        catch (IOException e) {
            this.log("-->ERROR: " + e.getMessage());
        }
        catch (XMLException e) {
            this.log("-->ERROR: " + e.getMessage());
        }
        catch (ProviderException e) {
            this.log("-->ERROR: " + e.getMessage());
        }
    }

    private void buildPluginZip(String aPluginDir) throws IOException {
        if (this.theEnvironment != null) {
            this.theEnvironment.buildPluginZip(aPluginDir);
        }
    }

    private ArrayList getPluginDirs(String aPathToEclispe) {
        ArrayList<String> theListOfPlugInDirs = new ArrayList<String>();
        this.log("Scanning for plugins ...");
        File aPluginsDir = new File(aPathToEclispe + "plugins");
        String[] aListOfPlugInDirs = aPluginsDir.list();
        int numberOfPluginDirs = aListOfPlugInDirs.length;
        int i = 0;
        while (i < numberOfPluginDirs) {
            String aPlugInDir = "plugins/" + aListOfPlugInDirs[i] + "/";
            File aPlugInXML = new File(aPathToEclispe + aPlugInDir + "plugin.xml");
            if (aPlugInXML.exists()) {
                this.log("Found plugin dir with plugin.xml in plugin dir no: " + i + " " + aPathToEclispe + aPlugInDir);
                theListOfPlugInDirs.add(aPlugInDir);
            } else {
                this.log("Found plugin dir without plugin.xml no: " + i + " " + aPathToEclispe + aPlugInDir);
            }
            ++i;
        }
        this.log("Found:" + theListOfPlugInDirs.size() + " plugins!");
        this.decreaseIndent();
        return theListOfPlugInDirs;
    }

    private ArrayList getFragmentDirs(String aPathToEclispe) {
        ArrayList<String> theListOfFragementDirs = new ArrayList<String>();
        this.log("Scanning for fragments ...");
        File aPluginsDir = new File(aPathToEclispe + "plugins");
        String[] aListOfPluginDirs = aPluginsDir.list();
        int numberOfPluginDirs = aListOfPluginDirs.length;
        int i = 0;
        while (i < numberOfPluginDirs) {
            String aPlugInDir = "plugins/" + aListOfPluginDirs[i] + "/";
            File aFragmentXML = new File(aPathToEclispe + aPlugInDir + "fragment.xml");
            if (aFragmentXML.exists()) {
                this.log("Found fragment dir with fragment.xml in plugin dir no: " + i + " " + aPathToEclispe + aPlugInDir);
                theListOfFragementDirs.add(aPlugInDir);
            }
            ++i;
        }
        this.log("Found: " + theListOfFragementDirs.size() + " fragments!");
        this.decreaseIndent();
        return theListOfFragementDirs;
    }

    private void decreaseIndent() {
        if (this.theEnvironment != null) {
            this.theEnvironment.decreaseIndent();
        }
    }

    private void increaseIndent() {
        if (this.theEnvironment != null) {
            this.theEnvironment.decreaseIndent();
        }
    }

    private void log(String aMessage) {
        if (this.theEnvironment != null) {
            this.theEnvironment.log(aMessage);
        } else {
            System.out.println(aMessage);
        }
    }

    private void log(String aMessage, int level) {
        if (this.theEnvironment != null) {
            this.theEnvironment.log(aMessage, level);
        } else {
            System.out.println(aMessage);
        }
    }

    public static String getDCNameFromPlugInDir(String parEclipseDir, String aPluginPath) throws PluginNamingException {
        int lastSeparatorIndex;
        String aPluginPathWithOutTrailiningSlash = aPluginPath.substring(0, aPluginPath.length() - 1);
        String aPluginDirName = aPluginPathWithOutTrailiningSlash.substring((lastSeparatorIndex = aPluginPathWithOutTrailiningSlash.lastIndexOf("/")) + 1);
        int indexOfVersionSeparator = aPluginDirName.lastIndexOf("_");
        if (indexOfVersionSeparator > -1) {
            aPluginDirName = aPluginDirName.substring(0, indexOfVersionSeparator);
        }
        String pluginId = "";
        File aPluginXML = new File(parEclipseDir + aPluginPath + "plugin.xml");
        if (!aPluginXML.exists()) {
            aPluginXML = new File(parEclipseDir + aPluginPath + "fragment.xml");
        }
        try {
            InputSource in = new InputSource(new FileInputStream(aPluginXML));
            DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
            dfactory.setNamespaceAware(true);
            Document doc = dfactory.newDocumentBuilder().parse(in);
            pluginId = doc.getDocumentElement().getAttribute("id");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!pluginId.equals(aPluginDirName)) {
            throw new PluginNamingException("Plugin/fragment dir name:->" + aPluginDirName + "<-does not match $PLUGINID_VERSION pattern");
        }
        String result = ExtensionFunctions.getDCNameFromPluginID(aPluginDirName);
        return result;
    }

    private ArrayList setUpDirectoryStruct(ArrayList theListOfPluginDirs, String absoluteWSFolder) throws IOException, PluginNamingException {
        boolean result;
        this.log("Starting: Setting up DC directories ...");
        this.increaseIndent();
        String parEclipseDir = this.getEclipseDir();
        ArrayList<String> theDC_CompFolders = new ArrayList<String>();
        String aDCsFolderPath = this.getWorkSpaceDir() + "DCs" + "/" + "sap.com" + "/";
        File aDCsFolder = new File(aDCsFolderPath);
        if (!aDCsFolder.exists() && !(result = aDCsFolder.mkdirs())) {
            this.log("Failed to create DCs Folder!");
            return theDC_CompFolders;
        }
        Iterator anIter = ((AbstractList)theListOfPluginDirs).iterator();
        while (anIter.hasNext()) {
            String aPlugInDir = (String)anIter.next();
            String aDCName = CreateEclipsePluginWrapperDC.getDCNameFromPlugInDir(parEclipseDir, aPlugInDir);
            PathUtils.createDCRef(this.theTargetDir, SC_NAME_EC_ECLIPSE, "sap.com", aDCName, "sap.com");
            String aDCFolderPath = aDCsFolderPath + aDCName + "/" + "_comp" + "/";
            File aDCFolder = new File(aDCsFolder, aDCName + "/" + "_comp" + "/" + "def" + "/");
            boolean result2 = aDCFolder.mkdirs();
            if (!result2) {
                this.log("Failed to create DC dir !" + aDCFolder.toString());
            } else {
                this.log("Create DC dir !" + aDCFolder.toString());
            }
            theDC_CompFolders.add(aDCFolderPath);
        }
        this.decreaseIndent();
        this.log("Finished: Setting up DC directories ...");
        return theDC_CompFolders;
    }

    private static void jarDir(File targetJarFile, File rootDir, File sourceDir) {
        try {
            FileOutputStream aOut = new FileOutputStream(targetJarFile);
            JarOutputStream aJarOut = new JarOutputStream(aOut);
            CreateEclipsePluginWrapperDC.jarDir(aJarOut, rootDir, sourceDir);
            ((FilterOutputStream)aJarOut).flush();
            aJarOut.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void jarDir(JarOutputStream aJarOut, File rootDir, File sourceDir) {
        FileFilter aFileFilter = new FileFilter(){

            public boolean accept(File aFile) {
                return aFile.isFile();
            }
        };
        File[] allFiles = sourceDir.listFiles(aFileFilter);
        int size = allFiles.length;
        int i = 0;
        while (i < size) {
            CreateEclipsePluginWrapperDC.addJarEntry(aJarOut, rootDir, allFiles[i]);
            ++i;
        }
        FileFilter aDirFilter = new FileFilter(){

            public boolean accept(File aFile) {
                return aFile.isDirectory();
            }
        };
        File[] allDirs = sourceDir.listFiles(aDirFilter);
        size = allDirs.length;
        int i2 = 0;
        while (i2 < size) {
            CreateEclipsePluginWrapperDC.jarDir(aJarOut, rootDir, allDirs[i2]);
            ++i2;
        }
    }

    private static void addJarEntry(JarOutputStream aJarOut, File aRootDir, File aFile) {
        try {
            String aRootPath = aRootDir.getCanonicalPath();
            String aFilePath = aFile.getCanonicalPath();
            JarEntry aNewEntry = new JarEntry(aFilePath.substring(aRootPath.length()));
            aJarOut.putNextEntry(aNewEntry);
            CreateEclipsePluginWrapperDC.copyFile(aJarOut, aFile);
            aJarOut.closeEntry();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void copyRecursive(File targetDir, File sourceDir) {
        FileFilter aFileFilter = new FileFilter(){

            public boolean accept(File aFile) {
                return aFile.isFile();
            }
        };
        File[] allFiles = sourceDir.listFiles(aFileFilter);
        int size = allFiles.length;
        int i = 0;
        while (i < size) {
            CreateEclipsePluginWrapperDC.copyFile(targetDir, allFiles[i]);
            ++i;
        }
        FileFilter aDirFilter = new FileFilter(){

            public boolean accept(File aFile) {
                return aFile.isDirectory();
            }
        };
        File[] allDirs = sourceDir.listFiles(aDirFilter);
        size = allDirs.length;
        int i2 = 0;
        while (i2 < size) {
            File aNewDir = new File(targetDir, allDirs[i2].getName());
            boolean result = aNewDir.mkdirs();
            CreateEclipsePluginWrapperDC.copyRecursive(aNewDir, allDirs[i2]);
            ++i2;
        }
    }

    private static boolean copyFile(File targetDir, File aFile) {
        FileOutputStream aFileOutput;
        FileInputStream aFileInput;
        try {
            aFileInput = new FileInputStream(aFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        try {
            aFileOutput = new FileOutputStream(new File(targetDir, aFile.getName()));
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            return false;
        }
        int count = -1;
        byte[] aByteArray = new byte[1024];
        try {
            while ((count = aFileInput.read(aByteArray)) != -1) {
                aFileOutput.write(aByteArray, 0, count);
            }
            aFileOutput.flush();
            aFileOutput.close();
            aFileInput.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return false;
        }
        return true;
    }

    private static boolean copyFile(OutputStream aTarget, File aFile) {
        FileInputStream aFileInput;
        try {
            aFileInput = new FileInputStream(aFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        int count = -1;
        byte[] aByteArray = new byte[1024];
        try {
            while ((count = aFileInput.read(aByteArray)) != -1) {
                aTarget.write(aByteArray, 0, count);
            }
            aFileInput.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

