/*
 * Decompiled with CFR 0.152.
 */
package com.sap.bi.ext;

import com.sap.bi.ext.XMLAttribute;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.BitSet;
import java.util.zip.GZIPOutputStream;

public class XMLWriter {
    private Namespace namespaceList;
    protected Writer writer;
    protected OutputStream out;
    protected StringBuffer buf = new StringBuffer();
    protected boolean opened;
    protected byte[] body;
    protected String encoding;
    protected int chunkSize;
    protected boolean flushed;
    static final int ZIP_BUF_SIZE = 65536;
    protected static BitSet safeCharacters = new BitSet(256);

    public void open(OutputStream out, String encoding) {
        this.open(out, encoding, Integer.MAX_VALUE);
    }

    public void open(OutputStream out, String encoding, int chunkSize) {
        this.out = out;
        this.chunkSize = chunkSize;
        this.encoding = encoding;
        this.opened = true;
    }

    public void open(Writer writer, int chunkSize) {
        this.writer = writer;
        this.chunkSize = chunkSize;
        this.opened = true;
    }

    public void open(Writer writer) {
        this.open(writer, Integer.MAX_VALUE);
    }

    public boolean isOpened() {
        return this.opened;
    }

    protected void flush() throws IOException {
        if (!this.flushed) {
            if (this.writer != null) {
                this.writer.write(this.buf.toString().toCharArray());
            } else if (this.buf.length() != 0) {
                this.out.write(this.getByteArray());
            }
            this.body = null;
            this.buf.setLength(0);
            this.flushed = true;
        }
    }

    public void close() throws IOException {
        if (this.opened) {
            this.flush();
            if (this.out instanceof GZIPOutputStream) {
                ((GZIPOutputStream)this.out).finish();
            }
            this.out = null;
            this.chunkSize = 0;
            this.encoding = null;
            this.writer = null;
            this.opened = false;
        }
    }

    protected byte[] getByteArray() {
        if (this.body == null) {
            if (this.encoding == null) {
                this.body = this.buf.toString().getBytes();
            } else {
                try {
                    this.body = this.buf.toString().getBytes(this.encoding);
                }
                catch (UnsupportedEncodingException x) {
                    this.body = this.buf.toString().getBytes();
                }
            }
        }
        return this.body;
    }

    public int getContentLength() {
        return this.flushed ? -1 : (this.encoding == null ? this.buf.length() : this.getByteArray().length);
    }

    protected final void write(String str) throws IOException {
        this.buf.append(str);
        this.flushed = false;
        if (this.buf.length() >= this.chunkSize) {
            this.flush();
        }
    }

    protected final void write(char ch) throws IOException {
        this.buf.append(ch);
        this.flushed = false;
        if (this.buf.length() >= this.chunkSize) {
            this.flush();
        }
    }

    public OutputStream getOutputStream() throws IOException {
        this.flush();
        return this.out;
    }

    public void enableCompression() throws IOException {
        if (this.out != null) {
            this.flush();
            this.out = new GZIPOutputStream(this.out, 65536);
        }
    }

    public void write(byte[] data, int off, int size) throws IOException {
        this.flush();
        if (this.writer != null) {
            this.writer.write(new String(data, off, size));
        } else {
            this.out.write(data, off, size);
        }
    }

    public void print(String str) throws IOException {
        this.write(str);
    }

    public void println(String str) throws IOException {
        this.write(str);
        this.write("\r\n");
    }

    public void println() throws IOException {
        this.write("\r\n");
    }

    public void emptyTag(String prefix, String name) throws IOException {
        this.write("<");
        if (prefix != null) {
            this.write(prefix + ":");
        }
        this.write(name);
        this.insertNamespaces();
        this.write("/>");
    }

    public void emptyTag(String prefix, String name, XMLAttribute[] attributes) throws IOException {
        this.write("<");
        if (prefix != null) {
            this.write(prefix + ":");
        }
        this.write(name);
        this.insertNamespaces();
        this.writeAttributes(attributes);
        this.write("/>");
    }

    public void beginTag(String prefix, String name) throws IOException {
        this.write("<");
        if (prefix != null) {
            this.write(prefix);
            this.write(":");
        }
        this.write(name);
        this.insertNamespaces();
        this.write(">");
    }

    public void beginTag(String prefix, String name, XMLAttribute[] attributes) throws IOException {
        this.write("<");
        if (prefix != null) {
            this.write(prefix + ":");
        }
        this.write(name);
        this.insertNamespaces();
        this.writeAttributes(attributes);
        this.write(">");
    }

    protected void writeAttributes(XMLAttribute[] attributes) throws IOException {
        XMLAttribute attr = null;
        String attrPrefix = null;
        String attrName = null;
        String attrValue = null;
        int i = 0;
        while (i < attributes.length) {
            attr = attributes[i];
            attrPrefix = attr.getPrefix();
            attrName = attr.getName();
            attrValue = attr.getValue();
            this.write(" ");
            if (attrPrefix != null) {
                this.write(attrPrefix);
                this.write(":");
            }
            this.write(attrName);
            this.write("=\"");
            this.write(attrValue);
            this.write("\"");
            ++i;
        }
    }

    public void endTag(String prefix, String name) throws IOException {
        this.write("</");
        if (prefix != null) {
            this.write(prefix + ":");
        }
        this.write(name);
        this.insertNamespaces();
        this.write(">");
    }

    public void printStringValue(String val) throws IOException {
        if (val != null) {
            this.writeEncodedXML(val);
        }
    }

    public void printIntValue(int val) throws IOException {
        this.write(Integer.toString(val, 10));
    }

    public void printBoolValue(boolean val) throws IOException {
        this.write(val ? "T" : "F");
    }

    public void printURI(String URI2) throws IOException {
        this.writeEncodedURL(URI2);
    }

    public void beginDocument(String prefix, String rootElementName) throws IOException {
        this.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        this.beginTag(prefix, rootElementName);
    }

    public void beginDocument(String prefix, String rootElementName, XMLAttribute[] attributes) throws IOException {
        this.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        this.beginTag(prefix, rootElementName, attributes);
    }

    public void endDocument(String prefix, String rootElementName) throws IOException {
        this.endTag(prefix, rootElementName);
    }

    public String encodeURL(String value) {
        byte[] utf8;
        StringBuffer buf = new StringBuffer();
        try {
            utf8 = value.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.toString());
        }
        int i = 0;
        while (i < utf8.length) {
            char ch = (char)utf8[i];
            if (!safeCharacters.get(ch)) {
                buf.append('%');
                int highDigit = ch >> 4 & 0xF;
                int lowDigit = ch & 0xF;
                buf.append(highDigit > 9 ? (char)(65 + highDigit - 10) : (char)(48 + highDigit));
                buf.append(lowDigit > 9 ? (char)(65 + lowDigit - 10) : (char)(48 + lowDigit));
            } else {
                buf.append(ch);
            }
            ++i;
        }
        return buf.toString();
    }

    public void writeEncodedURL(String value) throws IOException {
        byte[] utf8 = value.getBytes("UTF8");
        int i = 0;
        while (i < utf8.length) {
            char ch = (char)utf8[i];
            if (!safeCharacters.get(ch)) {
                this.write('%');
                int highDigit = ch >> 4 & 0xF;
                int lowDigit = ch & 0xF;
                this.write(highDigit > 9 ? (char)(65 + highDigit - 10) : (char)(48 + highDigit));
                this.write(lowDigit > 9 ? (char)(65 + lowDigit - 10) : (char)(48 + lowDigit));
            } else {
                this.write(ch);
            }
            ++i;
        }
    }

    public String encodeXML(String value) {
        StringBuffer buf = null;
        int i = 0;
        int len = value.length();
        while (i < len) {
            char ch = value.charAt(i);
            block0 : switch (ch) {
                case '\"': 
                case '&': 
                case '<': 
                case '>': {
                    if (buf == null) {
                        buf = new StringBuffer();
                        buf.append(value.substring(0, i));
                    }
                    switch (ch) {
                        case '<': {
                            buf.append("&lt;");
                            break block0;
                        }
                        case '>': {
                            buf.append("&gt;");
                            break block0;
                        }
                        case '&': {
                            buf.append("&amp;");
                            break block0;
                        }
                        case '\"': {
                            buf.append("&quot;");
                            break block0;
                        }
                        case '\'': {
                            buf.append("&apos;");
                            break block0;
                        }
                    }
                }
                default: {
                    if (buf == null) break;
                    buf.append(ch);
                }
            }
            ++i;
        }
        if (buf != null) {
            return buf.toString();
        }
        return value;
    }

    public void writeEncodedXML(String value) throws IOException {
        int i = 0;
        int len = value.length();
        while (i < len) {
            char ch = value.charAt(i);
            block0 : switch (ch) {
                case '\"': 
                case '&': 
                case '<': 
                case '>': {
                    switch (ch) {
                        case '<': {
                            this.write("&lt;");
                            break block0;
                        }
                        case '>': {
                            this.write("&gt;");
                            break block0;
                        }
                        case '&': {
                            this.write("&amp;");
                            break block0;
                        }
                        case '\"': {
                            this.write("&quot;");
                            break block0;
                        }
                        case '\'': {
                            this.write("&apos;");
                            break block0;
                        }
                    }
                }
                default: {
                    this.write(ch);
                }
            }
            ++i;
        }
    }

    public void addNamespace(String prefix, String namespace) {
        this.namespaceList = new Namespace(prefix, namespace, this.namespaceList);
    }

    protected void insertNamespaces() throws IOException {
        Namespace ns = this.namespaceList;
        while (ns != null) {
            if (ns.prefix == null) {
                this.write(" xmlns=\"" + ns.namespace + "\"");
            } else {
                this.write(" xmlns:" + ns.prefix + "=\"" + ns.namespace + "\"");
            }
            ns = ns.next;
        }
        this.namespaceList = null;
    }

    static {
        int i = 97;
        while (i <= 122) {
            safeCharacters.set(i);
            ++i;
        }
        i = 65;
        while (i <= 90) {
            safeCharacters.set(i);
            ++i;
        }
        i = 48;
        while (i <= 57) {
            safeCharacters.set(i);
            ++i;
        }
        safeCharacters.set(45);
        safeCharacters.set(95);
        safeCharacters.set(46);
        safeCharacters.set(42);
        safeCharacters.set(47);
        safeCharacters.set(58);
    }

    static final class Namespace {
        Namespace next;
        String prefix;
        String namespace;

        Namespace(String prefix, String namespace, Namespace chain) {
            this.prefix = prefix;
            this.namespace = namespace;
            this.next = chain;
        }
    }
}

