/*
 * Decompiled with CFR 0.152.
 */
package com.sap.bi.ext;

import com.sap.bi.ext.ExceptionUtil;
import com.sap.bi.ext.XMLException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XMLReader {
    protected Document document;
    protected Element root;
    protected boolean opened;

    public Document getDocument() {
        return this.document;
    }

    public Element getRoot() {
        return this.root;
    }

    public void open(File file) throws XMLException, IOException {
        this.open(new FileReader(file));
    }

    public void open(Reader request) throws XMLException, IOException {
        this._open(new InputSource(request));
    }

    public void open(InputStream request) throws XMLException, IOException {
        this._open(new InputSource(request));
    }

    public void open(String input) throws XMLException, IOException {
        this.open(new StringReader(input));
    }

    private void _open(InputSource request) throws IOException, XMLException {
        try {
            DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
            fact.setExpandEntityReferences(true);
            DocumentBuilder documentBuilder = fact.newDocumentBuilder();
            this.document = documentBuilder.parse(request);
            this.root = this.document.getDocumentElement();
            this.opened = true;
        }
        catch (IOException x) {
            throw x;
        }
        catch (Exception x) {
            throw new XMLException("Parser error: " + x);
        }
    }

    public void _open(Document document) {
        this.document = document;
        this.root = document.getDocumentElement();
        this.opened = true;
    }

    public boolean isOpened() {
        return this.opened;
    }

    public void close() {
        this.opened = false;
        this.root = null;
    }

    public Element getElement(String absolutePath) throws XMLException {
        return this.getElement("", absolutePath);
    }

    public Element getElement(String namespace, String absolutePath) throws XMLException {
        if (absolutePath.equals("/")) {
            return this.root;
        }
        if (!absolutePath.startsWith("/")) {
            throw new XMLException(absolutePath + " : absolute path doesn't start with /");
        }
        Element elem = this.getChildElement(namespace, null, absolutePath.substring(1));
        if (elem == null) {
            throw new XMLException(this.root.toString() + " : child element expected");
        }
        return elem;
    }

    public Element getChildElement(String namespace, Element parent, String relativePath) throws XMLException {
        int prefix = relativePath.indexOf(47);
        String name = prefix > 0 ? relativePath.substring(0, prefix) : relativePath;
        Node node = parent == null ? this.root : parent.getFirstChild();
        while (node != null) {
            short nodeType = node.getNodeType();
            String nodeName = node.getNodeName();
            String nodeNamespace = node.getNamespaceURI();
            String string = nodeNamespace = nodeNamespace == null ? "" : nodeNamespace;
            if (nodeType == 1 && name.equals(nodeName) && namespace.equals(nodeNamespace)) {
                if (prefix < 0) {
                    return (Element)node;
                }
                return this.getChildElement(namespace, (Element)node, relativePath.substring(prefix + 1));
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public Element getFirstChildElement(Element parent) throws XMLException {
        if (parent == null) {
            throw new XMLException("parent is null");
        }
        Node node = parent.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                return (Element)node;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public Element getNextSiblingElement(Element sibling) throws XMLException {
        if (sibling == null) {
            throw new XMLException("sibling is null");
        }
        Node node = sibling;
        while ((node = node.getNextSibling()) != null) {
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    public String getStringValue(Element elem) throws XMLException {
        return this.getValue(elem);
    }

    private String getValue(Element elem) throws XMLException {
        Node textNode = null;
        if (elem == null) {
            throw new XMLException("element is null");
        }
        Node node = elem.getFirstChild();
        while (node != null) {
            switch (node.getNodeType()) {
                case 3: {
                    if (textNode == null) {
                        textNode = node;
                        break;
                    }
                    throw new XMLException(node.toString() + " text node expected");
                }
                case 8: {
                    break;
                }
                default: {
                    throw new XMLException(node.toString() + " text or comment node expected");
                }
            }
            node = node.getNextSibling();
        }
        if (textNode == null) {
            return "";
        }
        String value = textNode.getNodeValue();
        return value == null ? "" : value;
    }

    public boolean getBooleanValue(Element elem) throws XMLException {
        String value = this.getValue(elem);
        if (value.equalsIgnoreCase("t") || value.equalsIgnoreCase("true") || value.equals("1")) {
            return true;
        }
        if (value.equalsIgnoreCase("f") || value.equalsIgnoreCase("false") || value.equals("0")) {
            return false;
        }
        throw new XMLException(elem.toString() + " : boolean value (t/true/1 or f/false/0) expected");
    }

    public int getIntValue(Element elem) throws XMLException {
        String value = this.getValue(elem);
        try {
            return Integer.parseInt(value, 10);
        }
        catch (NumberFormatException x) {
            throw new XMLException(elem.toString() + " : integer value expected");
        }
    }

    private void getElementValue(Element elem, StringBuffer buf) throws XMLException {
        Node node = elem.getFirstChild();
        while (node != null) {
            this.getNodeValue(node, buf);
            node = node.getNextSibling();
        }
    }

    private void getNodeValue(Node node, StringBuffer buf) throws XMLException {
        switch (node.getNodeType()) {
            case 3: {
                String value = node.getNodeValue();
                if (value == null) break;
                buf.append(this.decodeXML(value));
                break;
            }
            case 4: {
                buf.append("<![CDATA[");
                buf.append(node.getNodeValue());
                buf.append("]]>");
                break;
            }
            case 1: {
                buf.append("<");
                String prefix = node.getPrefix();
                String name = node.getNodeName();
                if (prefix != null) {
                    buf.append(prefix);
                    buf.append(":");
                }
                buf.append(name);
                String namespace = node.getNamespaceURI();
                if (namespace != null) {
                    if (prefix != null) {
                        buf.append(" xmlns:");
                        buf.append(prefix);
                        buf.append("=\"");
                    } else {
                        buf.append(" xmlns=");
                    }
                    buf.append(namespace);
                    buf.append("\"");
                }
                buf.append(">");
                this.getElementValue((Element)node, buf);
                buf.append("</");
                if (prefix != null) {
                    buf.append(prefix);
                    buf.append(":");
                }
                buf.append(name);
                buf.append(">");
                break;
            }
        }
    }

    public int getNumberOfChildElements(Element parent) {
        int n = 0;
        Node child = parent.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                ++n;
            }
            child = child.getNextSibling();
        }
        return n;
    }

    private static byte convertHexDigit(char ch) {
        if (ch >= '0' && ch <= '9') {
            return (byte)(ch - 48);
        }
        if (ch >= 'a' && ch <= 'f') {
            return (byte)(ch - 97 + 10);
        }
        if (ch >= 'A' && ch <= 'F') {
            return (byte)(ch - 65 + 10);
        }
        return 0;
    }

    public String decodeURL(String value) throws XMLException {
        int len = value.length();
        byte[] dst = new byte[len];
        int ix = 0;
        int ox = 0;
        while (ix < len) {
            int ch;
            if ((ch = (int)value.charAt(ix++)) == 43) {
                ch = 32;
            } else if (ch == 37) {
                ch = (byte)((XMLReader.convertHexDigit(value.charAt(ix)) << 4) + XMLReader.convertHexDigit(value.charAt(ix + 1)));
                ix += 2;
            }
            dst[ox++] = ch;
        }
        try {
            return new String(dst, 0, ox, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new XMLException(ExceptionUtil.printStackTrace(e));
        }
    }

    public String decodeXML(String value) {
        char[] dst = null;
        int len = value.length();
        int ix = 0;
        int ox = 0;
        boolean touched = false;
        while (ix < len) {
            int ch;
            block6: {
                block4: {
                    block9: {
                        block8: {
                            block7: {
                                block5: {
                                    if ((ch = value.charAt(ix++)) != 38) break block4;
                                    if (!value.startsWith("lt;", ix)) break block5;
                                    ch = 60;
                                    ix += 3;
                                    touched = true;
                                    break block6;
                                }
                                if (!value.startsWith("gt;", ix)) break block7;
                                ch = 62;
                                ix += 3;
                                touched = true;
                                break block6;
                            }
                            if (!value.startsWith("amp;", ix)) break block8;
                            ch = 38;
                            ix += 4;
                            touched = true;
                            break block6;
                        }
                        if (!value.startsWith("apos;", ix)) break block9;
                        ch = 39;
                        ix += 5;
                        touched = true;
                        break block6;
                    }
                    if (!value.startsWith("quot;", ix)) break block6;
                    ch = 34;
                    ix += 5;
                    touched = true;
                    break block6;
                }
                if (!touched) {
                    ++ox;
                    continue;
                }
            }
            if (dst == null) {
                dst = new char[len];
                value.getChars(0, ox, dst, 0);
            }
            dst[ox++] = ch;
        }
        if (dst != null) {
            return new String(dst, 0, ox);
        }
        return value;
    }
}

