/*
 * Decompiled with CFR 0.152.
 */
package com.sap.bi.ext;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.tools.ant.DirectoryScanner;

public class PathUtils {
    public static String getPathForDC(File targetDir, String name, String vendor) throws IOException {
        String rootPath = null;
        rootPath = targetDir.getCanonicalPath();
        StringBuffer s = new StringBuffer(rootPath);
        if (!rootPath.endsWith(File.separator)) {
            s.append(File.separatorChar);
        }
        s.append("DCs").append(File.separator).append(vendor).append(File.separator).append(name).append(File.separator).append("_comp").append(File.separator);
        return s.toString();
    }

    public static File getDCFolder(File targetDir, String name, String vendor) throws IOException {
        return new File(PathUtils.getPathForDC(targetDir, name, vendor));
    }

    public static File getDefFolder(File targetDir, String name, String vendor) throws IOException {
        return new File(PathUtils.getPathForDC(targetDir, name, vendor) + File.separator + "def");
    }

    public static String getDirForPublicPartJar(File targetDir, String dcName, String dcVendor, String buildVariant, String ppName) throws IOException {
        StringBuffer s = new StringBuffer(PathUtils.getPublicPartRootPath(targetDir, dcName, dcVendor, buildVariant, ppName));
        s.append("lib").append(File.separator).append("java").append(File.separator);
        return s.toString();
    }

    public static String getDirForPublicPartNativeLibs(File targetDir, String dcName, String dcVendor, String buildVariant, String ppName) throws IOException {
        StringBuffer s = new StringBuffer(PathUtils.getPublicPartRootPath(targetDir, dcName, dcVendor, buildVariant, ppName));
        s.append("lib").append(File.separator).append("native").append(File.separator).append("OS_libs").append(File.separator);
        return s.toString();
    }

    public static String getPublicPartRootPath(File targetDir, String dcName, String dcVendor, String buildVariant, String ppName) throws IOException {
        StringBuffer s = new StringBuffer(PathUtils.getPathForDC(targetDir, dcName, dcVendor));
        s.append("gen").append(File.separator).append(buildVariant).append(File.separator).append("public").append(File.separator).append(ppName).append(File.separator);
        return s.toString();
    }

    public static String getPathForDeploy(File targetDir, String dcName, String dcVendor, String buildVariant) throws IOException {
        StringBuffer s = new StringBuffer(PathUtils.getPathForDC(targetDir, dcName, dcVendor));
        s.append("gen").append(File.separator).append(buildVariant).append(File.separator).append("deploy").append(File.separator);
        return s.toString();
    }

    public static String getDCRefName(String dcVendor, String dcName) {
        return dcVendor + " " + dcName.replace('/', ' ') + ".dcref";
    }

    public static String[] getDCFromDCRef(File dcref) {
        String dcRefName = dcref.getName();
        int delimiter = dcRefName.indexOf(" ");
        String dcVendor = dcRefName.substring(0, delimiter);
        String dcName = dcRefName.substring(delimiter + 1, dcRefName.length()).replace(' ', '/');
        dcName = dcName.substring(0, dcName.length() - 6);
        return new String[]{dcVendor, dcName};
    }

    public static void createDCRef(File targetDir, String scName, String scVendor, String dcName, String dcVendor) throws IOException {
        File dir = PathUtils.createTopLevelDCsFolder(targetDir, scName, scVendor);
        String fileName = PathUtils.getDCRefName(dcVendor, dcName);
        File dcRefFile = new File(dir.getCanonicalPath() + File.separator + fileName);
        dcRefFile.createNewFile();
    }

    public static File getTopLevelDCsFolder(File targetDir, String scName, String scVendor) throws IOException {
        String path = targetDir.getCanonicalPath() + File.separator + "SCs" + File.separator + scVendor + File.separator + scName + File.separator + "_comp" + File.separator + "TopLevelDCs" + File.separator;
        return new File(path);
    }

    private static File createTopLevelDCsFolder(File targetDir, String scName, String scVendor) throws IOException {
        boolean result;
        File dir = PathUtils.getTopLevelDCsFolder(targetDir, scName, scVendor);
        if (!dir.exists() && !(result = dir.mkdirs())) {
            throw new RuntimeException("Failed to create TopLevelDCsFolder!");
        }
        return dir;
    }

    public static String[] getDCName(File compDir) throws IOException {
        String DCS_TAG = File.separator + "DCs" + File.separator;
        String COMP_TAG = File.separator + "_comp";
        String dcName = compDir.getCanonicalPath();
        int begin = dcName.lastIndexOf(DCS_TAG) + DCS_TAG.length();
        int end = dcName.lastIndexOf(COMP_TAG);
        dcName = begin == -1 || end == -1 ? null : dcName.substring(begin, end);
        int pos = dcName.indexOf(File.separator);
        String dcVendor = dcName.substring(0, pos);
        dcName = dcName.substring(pos + 1, dcName.length()).replace(File.separatorChar, '/');
        return new String[]{dcVendor, dcName};
    }

    public static String[] getSCName(File compDir) throws IOException {
        String DCS_TAG = File.separator + "SCs" + File.separator;
        String COMP_TAG = File.separator + "_comp";
        String scName = compDir.getCanonicalPath();
        int begin = scName.lastIndexOf(DCS_TAG) + DCS_TAG.length();
        int end = scName.lastIndexOf(COMP_TAG);
        scName = begin == -1 || end == -1 ? null : scName.substring(begin, end);
        int pos = scName.indexOf(File.separator);
        String dcVendor = scName.substring(0, pos);
        scName = scName.substring(pos + 1, scName.length()).replace(File.separatorChar, '/');
        return new String[]{dcVendor, scName};
    }

    public static String[] getDCPaths(File rootDir, File scCompDir) throws IOException {
        String[] dcrefs = PathUtils.getDCRefs(scCompDir);
        ArrayList<String> patterns = new ArrayList<String>();
        int i = 0;
        while (i < dcrefs.length) {
            String rootPath;
            String dcRefPath = dcrefs[i];
            File dcRef = new File(dcRefPath);
            String[] dcSpec = PathUtils.getDCFromDCRef(dcRef);
            File dcFolder = PathUtils.getDCFolder(rootDir, dcSpec[1], dcSpec[0]);
            String dcPath = dcFolder.getCanonicalPath();
            if (dcPath.indexOf(rootPath = rootDir.getCanonicalPath()) != 0) {
                throw new RuntimeException("root path " + rootPath + " is not above dcPath " + dcPath);
            }
            String pattern = dcPath.substring(rootPath.length()) + File.separator;
            patterns.add(pattern);
            ++i;
        }
        return patterns.toArray(new String[patterns.size()]);
    }

    private static String[] getDCRefs(File scCompDir) throws IOException {
        DirectoryScanner fs = new DirectoryScanner();
        fs.setBasedir(scCompDir.getCanonicalPath());
        fs.setIncludes(new String[]{"**/*.dcref"});
        fs.scan();
        String[] scPaths = fs.getIncludedFiles();
        return scPaths;
    }
}

