/*
 * Decompiled with CFR 0.152.
 */
package com.sap.bi.ext;

import com.sap.bi.ext.XMLWriter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class HTMLWriter
extends XMLWriter {
    private static final String DEFAULT_FONT = "Arial, Verdana, Helvetica";
    public static final String DEFAULT_ROW_EMPHASIZE_COLOR = "#F8F8F8";

    public void beginHTML(String head1, String head2left, String head2right, String head3) throws IOException {
        this.beginHTML(head1, head2left, head2right, head3, null);
    }

    public void beginHTML(String head1, String head2left, String head2right, String head3, Properties cssStyles) throws IOException {
        this.write("<html>");
        if (cssStyles != null && ((Hashtable)cssStyles).size() > 0) {
            this.write("<style type=\"text/css\">");
            Iterator i = ((Hashtable)cssStyles).entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                this.write((String)entry.getKey());
                this.write(" { ");
                this.write((String)entry.getValue());
                this.write(" }");
            }
            this.write("</style>");
        }
        this.write("<body marginwidth=\"0\" marginheight=\"0\" leftmargin=\"0\" topmargin=\"0\" rightmargin=\"0\">");
        this.write("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" bgcolor=\"#FFFFFF\"><tr><td colspan=\"3\">");
        this.write("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" align=\"left\" height=\"75\">");
        this.write("<tr bgcolor=\"#FFFFFF\"><td align=\"left\" height=\"48\" colspan=\"2\">");
        this.beginFont(DEFAULT_FONT, 4, "#666666");
        this.write("<b>&nbsp;&nbsp;&nbsp;");
        this.write(head1);
        this.write("&nbsp;</b>");
        this.endFont();
        this.write("</td></tr><tr bgcolor=\"#3F73A3\"><td align=\"left\" height=\"23\">");
        this.beginFont(DEFAULT_FONT, 2, "#FFFFFF");
        this.write("<b>&nbsp;&nbsp;");
        this.write(head2left);
        this.write("</b>");
        this.endFont();
        this.write("</td><td align=\"right\" height=\"23\">");
        this.beginFont(DEFAULT_FONT, 2, "#FFFFFF");
        this.write("<b>");
        this.write(head2right);
        this.write("&nbsp;&nbsp;</b>");
        this.endFont();
        this.write("</td></tr><tr bgcolor=\"#9DCDFD\"><td colspan=\"2\" height=\"4\"><img width=1 height=1 border=0 alt=\"\"></td></tr>");
        this.write("<tr bgcolor=\"#FFFFFF\"><td colspan=\"2\" align=\"right\" valign=\"top\" height=\"32\">");
        this.beginFont(DEFAULT_FONT, 1, "#666666");
        this.write(head3);
        this.write("&nbsp;&nbsp;");
        this.endFont();
        this.write("</td></tr></table></td></tr><tr><td width=\"10\"/><td>");
        this.beginFont(DEFAULT_FONT, 2, "#000000");
    }

    public void endHTML() throws IOException {
        this.endFont();
        this.write("</td><td width=\"10\"/></tr>\n</table>\n</body>\n</html>");
    }

    public void beginFont(String face, int size, String color) throws IOException {
        this.write("<font face=\"");
        this.write(face);
        this.write("\" size=\"");
        this.write(Integer.toString(size));
        this.write("\" color=\"");
        this.write(color);
        this.write("\">");
    }

    public void endFont() throws IOException {
        this.write("</font>");
    }

    public void beginTableRow(int rowNumber, boolean emphasizeRows, String emphasizeColor) throws IOException {
        if (emphasizeRows && rowNumber % 2 == 0) {
            this.write("<tr bgcolor=\"");
            if (emphasizeColor == null) {
                this.write(DEFAULT_ROW_EMPHASIZE_COLOR);
            } else {
                this.write(emphasizeColor);
            }
            this.write("\">");
        } else {
            this.write("<tr>");
        }
    }

    public void beginTableRow(int rowNumber, boolean emphasizeRows, String emphasizeColor, String align, String css) throws IOException {
        this.write("<tr");
        if (emphasizeRows && rowNumber % 2 == 0) {
            this.write(" bgcolor=");
            if (emphasizeColor == null) {
                this.write(DEFAULT_ROW_EMPHASIZE_COLOR);
            } else {
                this.write(emphasizeColor);
            }
        }
        if (align != null) {
            this.write(" align=");
            this.write(align);
        }
        if (css != null) {
            this.write(" class=");
            this.write(css);
        }
        this.write(">");
    }

    public void endTableRow() throws IOException {
        this.write("</tr>");
    }

    public void printHtmlLink(String url, String name, String css) throws IOException {
        this.write("<a href=\"");
        this.write(url);
        this.write("\" class=");
        this.write(css);
        this.write(">");
        this.write(name);
        this.write("</a>");
    }

    public void printTableField(String field) throws IOException {
        this.write("<td>");
        this.write(field);
        this.write("</td>");
    }
}

