/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.cbs.ant.taskdefs.htmlreport;

import com.sap.tc.jtools.jlint.TestConflictException;
import com.sap.tc.jtools.jlint.cbs.ant.taskdefs.htmlreport.DCProjectRun;
import com.sap.tc.jtools.jlint.cbs.ant.taskdefs.htmlreport.DCReportManager;
import com.sap.tc.jtools.jlint.extension.TestProvider;
import com.sap.tc.jtools.jlint.extension.TestProviderInterface;
import com.sap.tc.jtools.jlint.report.html.RunReportConfiguration;
import com.sap.tc.jtools.jtci.Dispatcher;
import com.sap.tc.jtools.jtci.PerformResponse;
import com.sap.tc.jtools.jtci.Test;
import com.sap.tc.jtools.jtci.TestSet;
import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.util.xml.XMLParseException;
import com.sap.tc.jtools.util.xml.XMLTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;

public class JLinReportTask
extends Task {
    private File resultsFile;
    private File reportConfigFile;
    private File htmlDirRoot;
    private Dispatcher dispatcher;
    private String localTestConfigFile;
    private String globalTestConfigFile;
    private String htmlFileName = "jlinResults.html";
    private String projectName;

    public void setHtmlFileName(String htmlFileName) {
        this.htmlFileName = htmlFileName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setReportConfigFile(File reportConfigFile) {
        this.reportConfigFile = reportConfigFile;
    }

    public void setHtmlDirRoot(File htmlDirRoot) {
        this.htmlDirRoot = htmlDirRoot;
    }

    public void setResultsFile(File resultsFile) {
        this.resultsFile = resultsFile;
    }

    public void execute() throws BuildException {
        this.initialize();
        this.log("Generating HTML report for JLin results in " + this.resultsFile.getAbsolutePath() + " to " + this.htmlDirRoot.getAbsolutePath());
        String runId = new Date(this.resultsFile.lastModified()).toString();
        DCProjectRun dcRun = new DCProjectRun(this.readResults(), this.readTestVariant(), runId, this.projectName);
        DCReportManager manager = new DCReportManager(this.getReportConfig());
        if (!this.htmlDirRoot.isDirectory()) {
            this.htmlDirRoot.mkdirs();
        }
        try {
            manager.createProjectReport(dcRun, this.dispatcher.getTestProvider().getTestDescriptionSet(), this.htmlDirRoot.getAbsolutePath(), this.htmlFileName);
        }
        catch (TestConflictException e) {
            throw new BuildException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RunReportConfiguration getReportConfig() {
        RunReportConfiguration config = null;
        if (this.reportConfigFile == null) {
            return new RunReportConfiguration();
        }
        BufferedReader fileReader = null;
        try {
            try {
                fileReader = new BufferedReader(new FileReader(this.reportConfigFile));
                config = new RunReportConfiguration(XMLTool.parseReader((Reader)fileReader));
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
            catch (XMLParseException e) {
                throw new BuildException((Throwable)e);
            }
            Object var6_3 = null;
            if (fileReader == null) return config;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            if (fileReader == null) throw throwable;
            try {
                ((Reader)fileReader).close();
                throw throwable;
            }
            catch (IOException e1) {
                throw new BuildException((Throwable)e1);
            }
        }
        try {}
        catch (IOException e1) {
            throw new BuildException((Throwable)e1);
        }
        ((Reader)fileReader).close();
        return config;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PerformResponse readResults() {
        if (!this.resultsFile.isFile()) {
            throw new BuildException("results file " + this.resultsFile.getAbsolutePath() + " is not a file!");
        }
        PerformResponse response = null;
        BufferedReader fileReader = null;
        try {
            try {
                fileReader = new BufferedReader(new FileReader(this.resultsFile));
                response = new PerformResponse(XMLTool.parseReader((Reader)fileReader));
            }
            catch (BadTreeException e) {
                throw new BuildException((Throwable)e);
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
            catch (XMLParseException e) {
                throw new BuildException((Throwable)e);
            }
            Object var7_3 = null;
            if (fileReader == null) return response;
        }
        catch (Throwable throwable) {
            Object var7_4 = null;
            if (fileReader == null) throw throwable;
            try {
                ((Reader)fileReader).close();
                throw throwable;
            }
            catch (IOException e1) {
                throw new BuildException((Throwable)e1);
            }
        }
        try {}
        catch (IOException e1) {
            throw new BuildException((Throwable)e1);
        }
        ((Reader)fileReader).close();
        return response;
    }

    private void initialize() {
        String jlinHomeDir = ((ProjectComponent)this).project.getProperty("jlin.home.dir");
        if (jlinHomeDir == null || !new File(jlinHomeDir).isDirectory()) {
            throw new BuildException("ant property jlin.home.dir: " + jlinHomeDir + " is not a directory.");
        }
        String configFile = new File(jlinHomeDir, "config/config.xml").getAbsolutePath();
        if (this.globalTestConfigFile == null) {
            this.localTestConfigFile = ((ProjectComponent)this).project.getProperty("jlin.testconfig.local.file");
            this.globalTestConfigFile = ((ProjectComponent)this).project.getProperty("jlin.testconfig.global.file");
            if (this.empty(this.globalTestConfigFile)) {
                this.globalTestConfigFile = new File(jlinHomeDir, "testconfig/testconfig.xml").getAbsolutePath();
            }
        }
        TestProvider provider = null;
        if (TestProvider.isInitialized()) {
            provider = TestProvider.getTestProvider();
        } else {
            try {
                provider = TestProvider.initialize((File)new File(configFile));
            }
            catch (BadTreeException e) {
                throw new BuildException((Throwable)e);
            }
            catch (FileNotFoundException e) {
                throw new BuildException((Throwable)e);
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
            catch (XMLParseException e) {
                throw new BuildException((Throwable)e);
            }
        }
        this.dispatcher = new Dispatcher((TestProviderInterface)provider);
        if (this.projectName == null) {
            this.projectName = "unknown";
        }
    }

    private TestSet readTestVariant() {
        String globalVariantName;
        HashMap<String, Test> tests;
        block10: {
            File globalTestFile = new File(this.globalTestConfigFile);
            tests = new HashMap<String, Test>();
            globalVariantName = null;
            try {
                if (globalTestFile.isFile()) {
                    Properties macros = new Properties();
                    macros.setProperty("CURRENT_DIRECTORY", globalTestFile.getParent());
                    TestSet testSet = new TestSet(XMLTool.parseReader((Reader)new FileReader(globalTestFile)).resolveMacros(macros));
                    globalVariantName = testSet.getName();
                    Test[] testArray = testSet.getActiveTests();
                    int i = 0;
                    while (i < testArray.length) {
                        tests.put(testArray[i].getName(), testArray[i]);
                        ++i;
                    }
                } else {
                    throw new BuildException("test config file " + this.globalTestConfigFile + " is not a file.\n");
                }
                if (this.localTestConfigFile == null) break block10;
                File localTestFile = new File(this.localTestConfigFile);
                if (localTestFile.isFile()) {
                    Properties macros = new Properties();
                    macros.setProperty("CURRENT_DIRECTORY", localTestFile.getParent());
                    TestSet testSet = new TestSet(XMLTool.parseReader((Reader)new FileReader(localTestFile)).resolveMacros(macros));
                    Test[] testArray = testSet.getActiveTests();
                    int i = 0;
                    while (i < testArray.length) {
                        String name = testArray[i].getName();
                        if (!tests.containsKey(name)) {
                            tests.put(testArray[i].getName(), testArray[i]);
                        }
                        ++i;
                    }
                    break block10;
                }
                throw new BuildException("local test config file " + this.localTestConfigFile + " is not a file.\n");
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
            catch (BadTreeException e) {
                throw new BuildException((Throwable)e);
            }
            catch (XMLParseException e) {
                throw new BuildException((Throwable)e);
            }
        }
        return new TestSet(globalVariantName, tests.values().toArray(new Test[0]));
    }

    private boolean empty(String string) {
        return string == null || string.trim().equals("");
    }

    public void setTestConfigFile(File testConfigFile) {
        if (!testConfigFile.isFile()) {
            throw new BuildException("testconfigfile " + testConfigFile.getAbsolutePath() + " is not a file!");
        }
        this.globalTestConfigFile = testConfigFile.getAbsolutePath();
        this.localTestConfigFile = null;
    }
}

