/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.cbs.ant.taskdefs.htmlreport;

import com.sap.tc.jtools.jlint.TestDescriptionSet;
import com.sap.tc.jtools.jlint.report.dataprovider.ProjectRunInterface;
import com.sap.tc.jtools.jlint.report.html.Page;
import com.sap.tc.jtools.jlint.report.html.PageManager;
import com.sap.tc.jtools.jlint.report.html.ProjectRunSummaryPage;
import com.sap.tc.jtools.jlint.report.html.RunReportConfiguration;
import com.sap.tc.jtools.jlint.report.html.RunReportPageManager;
import com.sap.tc.jtools.jlint.report.html.TestDescriptionPage;
import com.sap.tc.jtools.jlint.report.html.VariantPage;
import com.sap.tc.jtools.jlint.statistics.ResultStatistics;
import com.sap.tc.jtools.jtci.TestSet;
import com.sap.tc.jtools.util.structures.StructureTree;
import com.sap.tc.jtools.util.xml.XMLTool;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public class DCReportPageManager
extends RunReportPageManager {
    private TestDescriptionPage testDescriptionPage;
    private VariantPage variantPage;
    private ProjectRunSummaryPage projectPage;
    private String htmlFileName;

    public String getLinkForTest(String runId, String testId, Page callingPage) {
        return this.getRelativeLink(this.testDescriptionPage.getAddress() + "#" + testId, callingPage.getAddress());
    }

    public String getLinkForVariant(ProjectRunInterface run, Page callingPage) {
        return this.getRelativeLink(this.variantPage.getAddress(), callingPage.getAddress());
    }

    public DCReportPageManager(RunReportConfiguration runReportConfiguration, String htmlDirRoot, String htmlFileName, boolean cleanUp) {
        super(runReportConfiguration, htmlDirRoot, cleanUp);
        this.htmlFileName = htmlFileName == null ? "jlin_summary.html" : htmlFileName;
    }

    public TestDescriptionPage createTestDescriptionPage(TestDescriptionSet tests) {
        this.testDescriptionPage = new TestDescriptionPage(tests, "tests_description.html", (RunReportPageManager)this);
        ((PageManager)this).allPages.add(this.testDescriptionPage);
        return this.testDescriptionPage;
    }

    public VariantPage createVariantPage(ProjectRunInterface run) {
        VariantPage page;
        TestSet variant = run.getTestVariant();
        this.variantPage = page = new VariantPage(variant, "testconfig_" + variant.getName() + ".html", (RunReportPageManager)this);
        ((PageManager)this).allPages.add(page);
        return page;
    }

    public ProjectRunSummaryPage createProjectRunPage(ProjectRunInterface run) {
        return this.createProjectRunPage(run, this.htmlFileName);
    }

    public ProjectRunSummaryPage createProjectRunPage(ProjectRunInterface run, String htmlFileName) {
        ProjectRunSummaryPage page = new ProjectRunSummaryPage(run, htmlFileName, (RunReportPageManager)this);
        ResultStatistics statistics = page.getStatistics();
        if (statistics != null) {
            try {
                File statFile = new File(((PageManager)this).rootDirectory, "statistics.xml");
                statFile.getParentFile().mkdirs();
                XMLTool.writeDocument((StructureTree)statistics.toStructureTree(), (Writer)new FileWriter(statFile));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.projectPage = page;
        ((PageManager)this).allPages.add(page);
        return page;
    }

    public String getLinkForTest(String testId, Page callingPage) {
        try {
            return this.getRelativeLink(this.testDescriptionPage.getAddress() + "#" + testId, callingPage.getAddress());
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getLinkForVariant(Page callingPage) {
        return this.getRelativeLink(this.variantPage.getAddress(), callingPage.getAddress());
    }
}

