/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.cbs.ant.taskdefs.api;

import com.sap.tc.jtools.jlint.cbs.ant.taskdefs.api.IRequestCreator;
import com.sap.tc.jtools.jlint.extension.Module;
import com.sap.tc.jtools.jlint.extension.TestProvider;
import com.sap.tc.jtools.jlint.extension.TestProviderInterface;
import com.sap.tc.jtools.jtci.Dispatcher;
import com.sap.tc.jtools.jtci.PerformRequest;
import com.sap.tc.jtools.jtci.PerformResponse;
import com.sap.tc.jtools.jtci.Test;
import com.sap.tc.jtools.jtci.TestSet;
import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.jtci.exceptions.InvalidTestSpecificationException;
import com.sap.tc.jtools.jtci.exceptions.PerformException;
import com.sap.tc.jtools.jtci.exceptions.ToolInitializationException;
import com.sap.tc.jtools.util.structures.StructureTree;
import com.sap.tc.jtools.util.xml.XMLParseException;
import com.sap.tc.jtools.util.xml.XMLTool;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.FileUtils;

public class JLinRunner {
    private static final String LOG_FILE = "jlin_log.txt";
    private static Map runnerMap = new HashMap();
    private File jlinHomeDir;
    private File testConfigFile;
    private File resultsDir;
    private PrintWriter logWriter;
    private TestProviderInterface testProvider;
    private TestSet testSet;
    private Dispatcher dispatcher;

    public JLinRunner(File jlinHomeDir, File resultsDir, File testConfigFile) throws ToolInitializationException {
        this.jlinHomeDir = jlinHomeDir;
        this.resultsDir = resultsDir;
        this.testConfigFile = testConfigFile;
        this.init();
    }

    public void run(IRequestCreator requestCreator) throws ToolInitializationException, PerformException {
        this.log("Starting JLin ...");
        this.copyConfigFilesIfNecessary();
        try {
            PerformRequest[] requests = requestCreator.createRequests(this.getTestsFrom(requestCreator.getModuleID()));
            int i = 0;
            int n = this.getNextRequestNumber();
            while (i < requests.length) {
                this.saveRequest(requests[i], n);
                this.log("Starting perform request...");
                PerformResponse response = this.dispatcher.processRequest(requests[i]);
                this.log("Request processed.");
                this.saveResponse(response, n);
                ++i;
                ++n;
            }
            this.log("Finished JLin.");
        }
        catch (InvalidTestSpecificationException e) {
            throw new ToolInitializationException((Throwable)e);
        }
    }

    private Test[] getTestsFrom(String moduleID) throws ToolInitializationException {
        Test[] testArray = this.testSet.getActiveTests();
        Module module = this.testProvider.getModule(moduleID);
        if (module == null) {
            throw new ToolInitializationException("unknown module id: " + moduleID);
        }
        ArrayList<Test> tests = new ArrayList<Test>(testArray.length);
        int i = 0;
        while (i < testArray.length) {
            if (module.hasTest(testArray[i].getName())) {
                tests.add(testArray[i]);
            }
            ++i;
        }
        return tests.toArray(new Test[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void init() throws ToolInitializationException {
        BufferedReader reader = null;
        try {
            try {
                this.resultsDir.mkdirs();
                this.logWriter = new PrintWriter(new BufferedWriter(new FileWriter(new File(this.resultsDir, LOG_FILE))));
                if (this.jlinHomeDir == null) throw new ToolInitializationException("jlinhome dir");
                if (!this.jlinHomeDir.isDirectory()) {
                    throw new ToolInitializationException("jlinhome dir");
                }
                if (this.testConfigFile == null) {
                    this.testConfigFile = new File(this.jlinHomeDir, "testconfig/testconfig.xml");
                }
                Properties macros = new Properties();
                macros.setProperty("CURRENT_DIRECTORY", this.testConfigFile.getParent());
                reader = new BufferedReader(new FileReader(this.testConfigFile));
                this.testSet = new TestSet(XMLTool.parseReader((Reader)reader).resolveMacros(macros));
                this.testProvider = !TestProvider.isInitialized() ? TestProvider.initialize((File)new File(this.jlinHomeDir, "config/config.xml")) : TestProvider.getTestProvider();
            }
            catch (BadTreeException e1) {
                throw new ToolInitializationException((Throwable)e1);
            }
            catch (FileNotFoundException e1) {
                throw new ToolInitializationException((Throwable)e1);
            }
            catch (IOException e1) {
                throw new ToolInitializationException((Throwable)e1);
            }
            catch (XMLParseException e1) {
                throw new ToolInitializationException((Throwable)e1);
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            try {
                if (reader != null) {
                    reader.close();
                }
                this.logConfiguration();
                throw throwable;
            }
            catch (IOException e2) {
                throw new ToolInitializationException((Throwable)e2);
            }
        }
        try {}
        catch (IOException e2) {
            throw new ToolInitializationException((Throwable)e2);
        }
        if (reader != null) {
            reader.close();
        }
        this.logConfiguration();
        this.dispatcher = new Dispatcher(this.testProvider);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveRequest(PerformRequest performRequest, int currentRequestIndex) {
        BufferedWriter writer = null;
        File reqFile = new File(this.resultsDir, "JLRequest_" + currentRequestIndex + ".xml");
        writer = new BufferedWriter(new FileWriter(reqFile));
        XMLTool.writeDocument((StructureTree)performRequest.toStructureTree(), (Writer)writer);
        this.log("Perform request saved to file " + reqFile.getAbsolutePath());
        Object var7_5 = null;
        if (writer == null) return;
        try {
            writer.close();
            return;
        }
        catch (IOException e) {
            this.log(e);
        }
        return;
        {
            catch (IOException ioe) {
                this.log(ioe);
                Object var7_6 = null;
                if (writer == null) return;
                try {
                    writer.close();
                    return;
                }
                catch (IOException e) {
                    this.log(e);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (writer == null) throw throwable;
            try {
                writer.close();
                throw throwable;
            }
            catch (IOException e) {
                this.log(e);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveResponse(PerformResponse performResponse, int currentRequestIndex) {
        File outputFile = new File(this.resultsDir, "JLResults_" + currentRequestIndex + ".xml");
        BufferedWriter writer = null;
        writer = new BufferedWriter(new FileWriter(outputFile));
        XMLTool.writeDocument((StructureTree)performResponse.toStructureTree(), (Writer)writer);
        this.log("Perform response saved to file " + outputFile.getCanonicalPath());
        Object var7_5 = null;
        if (writer == null) return;
        try {
            writer.close();
            return;
        }
        catch (IOException e1) {
            this.log(e1);
        }
        return;
        {
            catch (IOException e) {
                this.log(e);
                Object var7_6 = null;
                if (writer == null) return;
                try {
                    writer.close();
                    return;
                }
                catch (IOException e1) {
                    this.log(e1);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (writer == null) throw throwable;
            try {
                writer.close();
                throw throwable;
            }
            catch (IOException e1) {
                this.log(e1);
            }
            throw throwable;
        }
    }

    public void log(Exception exc) {
        StringWriter writer = new StringWriter();
        exc.printStackTrace(new PrintWriter(writer));
        this.log("Exception occured:\n" + writer.toString());
    }

    public void log(String message) {
        String formattedMsg = new Date(System.currentTimeMillis()).toString() + ": " + message;
        if (this.logWriter != null) {
            this.logWriter.println(formattedMsg);
            this.logWriter.flush();
        } else {
            System.err.println(message);
        }
    }

    private int getNextRequestNumber() {
        int currentRequestNumber = 0;
        while (new File(this.resultsDir + File.separator + "JLRequest_" + currentRequestNumber + ".xml").exists()) {
            ++currentRequestNumber;
        }
        return currentRequestNumber;
    }

    private void copyConfigFilesIfNecessary() {
        File testconfigFile = new File(this.resultsDir, "jlin_settings/variants/testconfig.xml");
        File testDescriptorFile = new File(this.resultsDir, "jlin_settings/tests/tests.xml");
        if (testconfigFile.isFile() && testDescriptorFile.isFile()) {
            return;
        }
        FileUtils fileUtils = FileUtils.newFileUtils();
        try {
            fileUtils.copyFile(new File(this.jlinHomeDir, "testconfig/testconfig.xml"), testconfigFile);
            testDescriptorFile.getParentFile().mkdirs();
            XMLTool.writeDocument((StructureTree)this.testProvider.getTestDescriptionSet().toStructureTree(), (Writer)new BufferedWriter(new FileWriter(testDescriptorFile)));
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void logConfiguration() throws IOException {
        this.log("jlinhomedir:                   " + this.jlinHomeDir);
        this.log("resultsdir:                    " + this.resultsDir);
        this.log("testconfigfile:                " + this.testConfigFile);
    }
}

