/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.cbs.ant.taskdefs;

import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.jtools.jlint.CollectResults;
import com.sap.tc.jtools.jlint.TestConflictException;
import com.sap.tc.jtools.jlint.cbs.ant.dc.DCUtil;
import com.sap.tc.jtools.jlint.cbs.ant.taskdefs.AbstractJLinTask;
import com.sap.tc.jtools.jtci.PerformResponse;
import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.jtci.interfaces.ResultInterface;
import com.sap.tc.jtools.util.structures.StructureTree;
import com.sap.tc.jtools.util.xml.XMLParseException;
import com.sap.tc.jtools.util.xml.XMLTool;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;

public class CollectResultsTask
extends AbstractJLinTask {
    private static final String PROJECT_ID_KEY = "ProjectId";
    private static final String CREATION_DATE_KEY = "CreationDate";
    private static final String DC_NAME_KEY = "DCName";
    private static final String DC_CAPTION_KEY = "DCCaption";
    private static final String DC_DESCRIPTION_KEY = "DCDescription";
    private static final String DC_VENDOR_KEY = "DCVendor";
    private static final String DC_TYPE_KEY = "DCType";
    private static final String DC_SUBTYPE_KEY = "DCSubType";
    private static final DateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd hh:ss:mm.SSS");
    private static String jlinHomeDir;
    private static CollectResults collectRes;
    private boolean copyConfigFiles = false;
    private File resultFile;
    private File resultDir;
    private File globalTestVariant;
    private boolean cleanup = false;
    private File[] rawResultFiles;
    private List fileSetList = new ArrayList();
    private Properties resultProperties = new Properties();

    public void execute() throws BuildException {
        try {
            this.initialize();
            this.maybeCopyConfigFiles();
            this.fillPropertiesFromDCInfo();
            this.logJLinAntProperties(3);
            collectRes.setProperties(this.resultProperties);
            if (this.rawResultFiles == null) {
                this.log("Collecting all JLin result files from " + this.resultDir.getAbsolutePath() + " to " + this.resultFile.getAbsolutePath());
                collectRes.execute(this.resultDir.getAbsolutePath(), this.resultFile, this.cleanup);
            } else {
                this.log("Collecting JLin result files to " + this.resultFile.getAbsolutePath());
                this.log("result files to be collected:", 3);
                int i = 0;
                while (i < this.rawResultFiles.length) {
                    this.log(this.rawResultFiles[i].getAbsolutePath(), 3);
                    ++i;
                }
                collectRes.collect(this.rawResultFiles, this.resultFile);
            }
            this.logMessageStatistics(collectRes.getCollectedResponse());
        }
        catch (Throwable t) {
            this.log("Exception occured: " + t.getMessage(), 0);
            this.log(CollectResultsTask.getStackTrace(t), 0);
        }
    }

    private void maybeCopyConfigFiles() {
        if (!this.copyConfigFiles) {
            return;
        }
        File testconfigFile = new File(this.resultDir, "jlin_testconfig.xml");
        File testDescriptorFile = new File(this.resultDir, "jlin_testdescriptor.xml");
        FileUtils fileUtils = FileUtils.newFileUtils();
        BufferedWriter fileWriter = null;
        this.log("Copying JLin config files " + testconfigFile.getAbsolutePath() + " and " + testDescriptorFile.getAbsolutePath() + " to " + this.resultDir.getAbsolutePath());
        try {
            fileUtils.copyFile(this.globalTestVariant, testconfigFile);
            fileWriter = new BufferedWriter(new FileWriter(testDescriptorFile));
            XMLTool.writeDocument((StructureTree)collectRes.getDispatcher().getTestProvider().getTestDescriptionSet().toStructureTree(), (Writer)fileWriter);
            ((Writer)fileWriter).close();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        catch (TestConflictException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void logMessageStatistics(PerformResponse response) {
        ResultInterface[] results = response.getResults();
        int internalErrorCount = 0;
        int infoCount = 0;
        int warningCount = 0;
        int errorCount = 0;
        int i = 0;
        while (i < results.length) {
            switch (results[i].getPriority()) {
                case 0: {
                    ++internalErrorCount;
                    break;
                }
                case 1: {
                    ++errorCount;
                    break;
                }
                case 2: {
                    ++warningCount;
                    break;
                }
                case 3: {
                    ++infoCount;
                }
            }
            ++i;
        }
        int totalCount = errorCount + warningCount + infoCount;
        int maxLen = String.valueOf(totalCount).length();
        StringBuffer[] rightAlignedCounts = new StringBuffer[]{new StringBuffer(String.valueOf(errorCount)), new StringBuffer(String.valueOf(warningCount)), new StringBuffer(String.valueOf(infoCount)), new StringBuffer(String.valueOf(internalErrorCount))};
        int i2 = 0;
        while (i2 < rightAlignedCounts.length) {
            int leadingWhitespaceLength = maxLen - rightAlignedCounts[i2].length();
            if (leadingWhitespaceLength > 0) {
                char[] whiteSpace = new char[leadingWhitespaceLength];
                int j = 0;
                while (j < whiteSpace.length) {
                    whiteSpace[j] = 32;
                    ++j;
                }
                rightAlignedCounts[i2].insert(0, whiteSpace);
            }
            ++i2;
        }
        this.log("Collected JLin messages total: " + String.valueOf(totalCount));
        this.log("                        error: " + rightAlignedCounts[0].toString());
        this.log("                      warning: " + rightAlignedCounts[1].toString());
        this.log("                         info: " + rightAlignedCounts[2].toString());
        this.log("Internal JLin errors:          " + rightAlignedCounts[3].toString());
    }

    private void fillPropertiesFromDCInfo() {
        String dcRootDir = this.getProject().getProperty("jlin.dc.root.dir");
        if (dcRootDir == null) {
            return;
        }
        try {
            DevelopmentComponent dc = DCUtil.parseDCDef(dcRootDir);
            this.resultProperties.setProperty(PROJECT_ID_KEY, dc.getName());
            this.resultProperties.setProperty(DC_NAME_KEY, dc.getName());
            this.resultProperties.setProperty(DC_CAPTION_KEY, dc.getCaption());
            this.resultProperties.setProperty(DC_VENDOR_KEY, dc.getVendor());
            this.resultProperties.setProperty(DC_TYPE_KEY, dc.getComponentType().getType());
            String date = DATE_FORMATTER.format(new Date(System.currentTimeMillis()));
            this.resultProperties.setProperty(CREATION_DATE_KEY, date);
            String subType = dc.getComponentType().getSubType();
            if (subType != null) {
                this.resultProperties.setProperty(DC_SUBTYPE_KEY, subType);
            }
        }
        catch (Throwable t) {
            this.log("Exception occured parsing .dcdef file. Ignoring DC metainfo.", 0);
            this.log(CollectResultsTask.getStackTrace(t), 0);
        }
    }

    public void initialize() throws BuildException {
        Project project = this.getProject();
        if (this.resultFile == null) {
            String logDir = project.getProperty("jlin.log.dir");
            this.resultFile = new File(logDir, "index.xml");
        }
        this.resultDir = this.resultFile.getParentFile();
        String jlinHome = project.getProperty("jlin.home.dir");
        if (jlinHome == null || jlinHome.trim().length() == 0) {
            throw new BuildException("ant property jlin.home.dir not set!");
        }
        if (!new File(jlinHome).isDirectory()) {
            throw new BuildException("ant property jlin.home.dir: " + jlinHome + " is not a directory!");
        }
        try {
            String canonicalJLinHome = new File(jlinHome).getCanonicalPath();
            if (!canonicalJLinHome.equals(jlinHomeDir) || collectRes == null) {
                collectRes = new CollectResults(canonicalJLinHome);
                jlinHomeDir = canonicalJLinHome;
            }
        }
        catch (BadTreeException e) {
            throw new BuildException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        catch (XMLParseException e) {
            throw new BuildException((Throwable)e);
        }
        String variant = project.getProperty("jlin.testconfig.global.file");
        this.globalTestVariant = variant != null ? new File(variant) : new File(jlinHome, "testconfig/testconfig.xml");
        if (!this.fileSetList.isEmpty()) {
            this.scanFileSets();
        }
    }

    private void scanFileSets() {
        ArrayList<File> resultFilesList = new ArrayList<File>();
        Iterator iter = this.fileSetList.iterator();
        while (iter.hasNext()) {
            FileSet fileSet = (FileSet)iter.next();
            DirectoryScanner scanner = fileSet.getDirectoryScanner(this.getProject());
            scanner.scan();
            File baseDir = scanner.getBasedir();
            String[] includedFiles = scanner.getIncludedFiles();
            int i = 0;
            while (i < includedFiles.length) {
                resultFilesList.add(new File(baseDir, includedFiles[i]));
                ++i;
            }
        }
        this.rawResultFiles = resultFilesList.toArray(new File[0]);
    }

    private static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public void setCleanUp(boolean cleanup) {
        this.cleanup = cleanup;
    }

    public void setCopyConfigFiles(boolean copy) {
        this.copyConfigFiles = copy;
    }

    public void setResultFile(File resultFile) {
        this.resultFile = resultFile;
    }

    public void addFileSet(FileSet fileSet) {
        this.fileSetList.add(fileSet);
    }

    public void addConfiguredProperty(Property property) {
        this.resultProperties.setProperty(property.getName(), property.getValue());
    }
}

