/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.cbs.ant.classification.dc;

import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.jtools.jlint.cbs.ant.classification.ClassificationRule;
import com.sap.tc.jtools.jlint.cbs.ant.classification.dc.IRuleCreator;

public class J2EEServerRuleCreator
implements IRuleCreator {
    private static final String J2EE_SERVER_DC_TYPE = "J2EE Server Component";
    private static final String LIB_SUBDC_TYPE = "Library";
    private static final String SERVICE_SUBDC_TYPE = "Service";
    private static final ClassificationRule[] J2EE_ENGINE_RULE = new ClassificationRule[]{new ClassificationRule(".*", new String[]{"j2ee_engine"})};
    private static final ClassificationRule[] J2EE_LIB_RULE = new ClassificationRule[]{new ClassificationRule(".*", new String[]{"j2ee_engine", "engine_library"})};
    private static final ClassificationRule[] J2EE_SERVICE_RULE = new ClassificationRule[]{new ClassificationRule(".*", new String[]{"j2ee_engine", "engine_service"})};

    public ClassificationRule[] createRules(DevelopmentComponent dc) {
        if (J2EE_SERVER_DC_TYPE.equals(dc.getComponentType().getType())) {
            String subType = dc.getComponentType().getSubType();
            if (LIB_SUBDC_TYPE.equals(subType)) {
                return J2EE_LIB_RULE;
            }
            if (SERVICE_SUBDC_TYPE.equals(subType)) {
                return J2EE_SERVICE_RULE;
            }
            return J2EE_ENGINE_RULE;
        }
        return IRuleCreator.NO_RULES;
    }
}

