/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.cbs.ant.classification.dc;

import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.Entity;
import com.sap.tc.complib.PublicPart;
import com.sap.tc.jtools.jlint.cbs.ant.classification.ClassificationRule;
import com.sap.tc.jtools.jlint.cbs.ant.classification.dc.IRuleCreator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class APIRuleCreator
implements IRuleCreator {
    private String[] API_CLASS = new String[]{"api"};
    private static final String ENTITY_TYPE_PACKAGE_TREE = "Java Package Tree";
    private static final String ENTITY_TYPE_PACKAGE = "Java Package";
    private static final String ENTITY_TYPE_CLASS = "Java Class";

    public ClassificationRule[] createRules(DevelopmentComponent dc) {
        ArrayList<ClassificationRule> rules = new ArrayList<ClassificationRule>();
        Map ppMap = dc.getPublicParts();
        if (ppMap == null) {
            return IRuleCreator.NO_RULES;
        }
        Collection ppCollection = ppMap.values();
        if (ppCollection == null) {
            return IRuleCreator.NO_RULES;
        }
        Iterator iter = ppCollection.iterator();
        while (iter.hasNext()) {
            List entityList;
            PublicPart pp = (PublicPart)iter.next();
            if (pp.getGrants() != null && pp.getGrants().size() != 0 || (entityList = pp.getEntities()) == null) continue;
            Iterator iterator = entityList.iterator();
            while (iterator.hasNext()) {
                Entity entity = (Entity)iterator.next();
                String type = entity.getType();
                String pattern = null;
                if (ENTITY_TYPE_PACKAGE_TREE.equals(type)) {
                    pattern = entity.getPackageName() + ".*";
                } else if (ENTITY_TYPE_PACKAGE.equals(type)) {
                    pattern = entity.getPackageName() + "/[^/]*\\.java";
                } else if (ENTITY_TYPE_CLASS.equals(type)) {
                    pattern = entity.getPackageName() + "/" + entity.getName() + ".*";
                }
                if (pattern == null) continue;
                rules.add(new ClassificationRule(pattern, this.API_CLASS));
            }
        }
        return rules.toArray(new ClassificationRule[0]);
    }
}

