/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.cbs.ant.classification;

import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.jtools.jlint.cbs.ant.classification.ClassificationRule;
import com.sap.tc.jtools.jlint.cbs.ant.classification.CodeClass;
import com.sap.tc.jtools.jlint.cbs.ant.classification.dc.IRuleCreator;
import com.sap.tc.jtools.jlint.cbs.ant.classification.dc.J2EEAppRuleCreator;
import com.sap.tc.jtools.jlint.cbs.ant.classification.dc.J2EEServerRuleCreator;
import com.sap.tc.jtools.jlint.cbs.ant.classification.dc.WDRuleCreator;
import com.sap.tc.jtools.util.persistable.Persistable;
import com.sap.tc.jtools.util.structures.Header;
import com.sap.tc.jtools.util.structures.StructureTree;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class CodeClassification
implements Persistable {
    public static final CodeClass ALL_CODE_CLASS = new CodeClass(new String[]{"all"});
    private static List ruleCreators = new ArrayList();
    public static final String DEFAULT_FILENAME = "codeClassification.xml";
    private static final String CODE_CLASSIFICATION_TAG = "codeClassification";
    private List goodRules = new ArrayList();
    private List malformedRules = new ArrayList();

    public CodeClassification(StructureTree tree, DevelopmentComponent dc) {
        if (tree != null) {
            StructureTree[] ruleTrees = tree.getChildren("classificationRule");
            int i = 0;
            while (i < ruleTrees.length) {
                ClassificationRule rule = new ClassificationRule(ruleTrees[i]);
                if (rule.isWellFormed()) {
                    this.goodRules.add(rule);
                } else {
                    this.malformedRules.add(rule);
                }
                ++i;
            }
        }
        if (dc != null) {
            this.createRulesFrom(dc);
        }
    }

    private void createRulesFrom(DevelopmentComponent dc) {
        Iterator iter = ruleCreators.iterator();
        while (iter.hasNext()) {
            IRuleCreator ruleCreator = (IRuleCreator)iter.next();
            ClassificationRule[] rules = ruleCreator.createRules(dc);
            int i = 0;
            while (i < rules.length) {
                if (rules[i].isWellFormed()) {
                    this.goodRules.add(rules[i]);
                } else {
                    this.malformedRules.add(rules[i]);
                }
                ++i;
            }
        }
    }

    private CodeClassification(ClassificationRule[] rules) {
        int i = 0;
        while (i < rules.length) {
            if (rules[i].isWellFormed()) {
                this.goodRules.add(rules[i]);
            } else {
                this.malformedRules.add(rules[i]);
            }
            ++i;
        }
    }

    public CodeClass classify(String fileName) {
        CodeClass codeClass = null;
        Iterator iter = this.goodRules.iterator();
        while (iter.hasNext()) {
            ClassificationRule rule = (ClassificationRule)iter.next();
            if (!rule.matches(fileName)) continue;
            if (codeClass == null) {
                codeClass = rule.getCodeClass().deepClone();
                continue;
            }
            codeClass.addAttributesOf(rule.getCodeClass());
        }
        if (codeClass == null) {
            return ALL_CODE_CLASS;
        }
        return codeClass;
    }

    public StructureTree toStructureTree() {
        StructureTree classificationTree = new StructureTree(new Header(CODE_CLASSIFICATION_TAG));
        Iterator iter = this.goodRules.iterator();
        while (iter.hasNext()) {
            ClassificationRule rule = (ClassificationRule)iter.next();
            classificationTree.addNewChild(rule.toStructureTree());
        }
        return classificationTree;
    }

    public String[] getUnknownUsedAttributes() {
        HashSet unknownAttr = new HashSet();
        Iterator iter = this.goodRules.iterator();
        while (iter.hasNext()) {
            ClassificationRule rule = (ClassificationRule)iter.next();
            unknownAttr.addAll(rule.getCodeClass().getUnknownAttributes());
        }
        Iterator iter2 = this.malformedRules.iterator();
        while (iter2.hasNext()) {
            ClassificationRule rule = (ClassificationRule)iter2.next();
            unknownAttr.addAll(rule.getCodeClass().getUnknownAttributes());
        }
        return unknownAttr.toArray(new String[0]);
    }

    public String[] getMalFormedPatterns() {
        ArrayList<String> malformedPatterns = new ArrayList<String>();
        Iterator iter = this.malformedRules.iterator();
        while (iter.hasNext()) {
            ClassificationRule rule = (ClassificationRule)iter.next();
            malformedPatterns.add(rule.getPattern());
        }
        return malformedPatterns.toArray(new String[0]);
    }

    static {
        ruleCreators.add(new J2EEAppRuleCreator());
        ruleCreators.add(new J2EEServerRuleCreator());
        ruleCreators.add(new WDRuleCreator());
    }
}

