/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.cbs.ant.classification;

import com.sap.tc.jtools.jtci.CodeClassificationConstants;
import java.util.HashSet;
import java.util.Set;

public class CodeClass {
    private Set knownAttributes = new HashSet();
    private Set unknownattr = new HashSet();

    public CodeClass(String[] attributes) {
        this.addAttributes(attributes);
        if (this.knownAttributes.size() == 0) {
            this.knownAttributes.add("all");
        }
    }

    private CodeClass() {
    }

    public String[] getAttributes() {
        return this.knownAttributes.toArray(new String[0]);
    }

    public Set getUnknownAttributes() {
        return this.unknownattr;
    }

    public void addAttributesOf(CodeClass codeClass) {
        this.knownAttributes.addAll(codeClass.knownAttributes);
        this.unknownattr.addAll(codeClass.unknownattr);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CodeClass)) {
            return false;
        }
        return ((CodeClass)obj).knownAttributes.equals(this.knownAttributes);
    }

    public int hashCode() {
        return this.knownAttributes.hashCode();
    }

    private void addAttributes(String[] attributes) {
        int i = 0;
        while (i < attributes.length) {
            if (CodeClassificationConstants.getValue((String)attributes[i]) == 0L) {
                this.unknownattr.add(attributes[i]);
            } else {
                this.knownAttributes.add(attributes[i]);
            }
            ++i;
        }
    }

    public CodeClass deepClone() {
        CodeClass copy = new CodeClass();
        copy.knownAttributes.addAll(this.knownAttributes);
        copy.unknownattr.addAll(this.unknownattr);
        return copy;
    }
}

