/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.cbs.ant.classification;

import com.sap.tc.jtools.jlint.cbs.ant.classification.CodeClass;
import com.sap.tc.jtools.util.persistable.Persistable;
import com.sap.tc.jtools.util.structures.Header;
import com.sap.tc.jtools.util.structures.StructureTree;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ClassificationRule
implements Persistable {
    private String pattern;
    private CodeClass codeClass;
    public static final String RULE_TAG = "classificationRule";
    private static final String FILE_PATTERN_ATTR = "filePattern";
    private static final String ATTRIBUTES_ATTR = "attributes";
    private static final String ATTRIBUTES_SEPARATOR = ",";

    public ClassificationRule(StructureTree tree) {
        this.pattern = tree.getParameter(FILE_PATTERN_ATTR);
        String attrString = tree.getParameter(ATTRIBUTES_ATTR);
        if (attrString == null) {
            attrString = "";
        }
        StringTokenizer tok = new StringTokenizer(attrString, ATTRIBUTES_SEPARATOR);
        ArrayList<String> attrList = new ArrayList<String>(tok.countTokens());
        while (tok.hasMoreTokens()) {
            attrList.add(tok.nextToken().trim());
        }
        this.codeClass = new CodeClass(attrList.toArray(new String[0]));
    }

    public ClassificationRule(String regexpPattern, String[] classificationAttributes) {
        this.pattern = regexpPattern;
        this.codeClass = new CodeClass(classificationAttributes);
    }

    public boolean matches(String fileName) {
        return true;
    }

    public CodeClass getCodeClass() {
        return this.codeClass;
    }

    public StructureTree toStructureTree() {
        Header ruleHeader = new Header(RULE_TAG);
        ruleHeader.setParameter(FILE_PATTERN_ATTR, this.pattern);
        StringBuffer attributesBuf = new StringBuffer();
        String[] attributes = this.codeClass.getAttributes();
        int i = 0;
        while (i < attributes.length) {
            if (i > 0) {
                attributesBuf.append(", ");
            }
            attributesBuf.append(attributes[i].trim());
            ++i;
        }
        ruleHeader.setParameter(ATTRIBUTES_ATTR, attributesBuf.toString());
        return new StructureTree(ruleHeader);
    }

    public boolean isWellFormed() {
        return true;
    }

    public String getPattern() {
        return this.pattern;
    }
}

