/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.cbs.ant;

import com.sap.tc.complib.provider.ProviderException;
import com.sap.tc.jtools.jlint.cbs.ant.JlinInitException;
import com.sap.tc.jtools.jlint.cbs.ant.classification.CodeClassification;
import com.sap.tc.jtools.jlint.cbs.ant.classification.JavaFileList;
import com.sap.tc.jtools.jlint.cbs.ant.classification.JavaTestObjectCreator;
import com.sap.tc.jtools.jlint.cbs.ant.dc.DCUtil;
import com.sap.tc.jtools.jlint.extension.TestProvider;
import com.sap.tc.jtools.jlint.extension.TestProviderInterface;
import com.sap.tc.jtools.jlint.java.JavaFileArrayTestObject;
import com.sap.tc.jtools.jtci.Dispatcher;
import com.sap.tc.jtools.jtci.ParameterTool;
import com.sap.tc.jtools.jtci.PerformRequest;
import com.sap.tc.jtools.jtci.PerformResponse;
import com.sap.tc.jtools.jtci.Test;
import com.sap.tc.jtools.jtci.TestObject;
import com.sap.tc.jtools.jtci.TestSet;
import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.jtci.exceptions.InvalidTestObjectSpecification;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import com.sap.tc.jtools.util.structures.StructureTree;
import com.sap.tc.jtools.util.xml.XMLParseException;
import com.sap.tc.jtools.util.xml.XMLTool;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.compilers.CompilerAdapter;
import org.apache.tools.ant.taskdefs.compilers.CompilerAdapterFactory;
import org.apache.tools.ant.taskdefs.compilers.DefaultCompilerAdapter;
import org.apache.tools.ant.util.FileUtils;

public class JLinCBSCompilerAdapter
extends DefaultCompilerAdapter {
    public static final String PARAMETER_CLASS_FOLDERS = "Class folders";
    public static final String PARAMETER_JAVA_LIBRARIES = "Java libraries";
    public static final String PARAMETER_SOURCE_FOLDERS = "Source folders";
    public static final String ANT_PROPERTY_BUILD_COMPILER = "build.compiler";
    public static final String ANT_PROPERTY_JLIN_HOME = "jlin.home.dir";
    public static final String ANT_PROPERTY_JLIN_LOG_DIR = "jlin.log.dir";
    public static final String ANT_PROPERTY_DC_ROOT_DIR = "jlin.dc.root.dir";
    public static final String ANT_PROPERTY_JLIN_TESTCFG_GLOBAL_FILE = "jlin.testconfig.global.file";
    public static final String ANT_PROPERTY_JLIN_TESTCFG_KEY = "jlin.testconfig.key";
    public static final String ANT_PROPERTY_JLIN_TESTCFG_LOCAL_FILE = "jlin.testconfig.local.file";
    public static final String ANT_PROPERTY_CLASSIFICATION_FILE = "jlin.codeclassification.file";
    public static final String JLIN_SETTINGS_DIRNAME = "jlin_settings";
    public static final String DEFAULT_TESTCFG_GLOBAL_FILENAME = "testconfig/testconfig.xml";
    public static final String DEFAULT_CONFIG_FILENAME = "config/config.xml";
    public static final String EXTERNAL_JAVAC = "extJavac";
    public static final String MODERN_JAVAC = "modern";
    private static final int FILE_NUMBER_MAX = 200;
    private static final String JAR_EXTENSION = ".jar";
    private String jlinHomeDir;
    private String jlinLogDir;
    private String globalTestConfigFile;
    private String localTestConfigFile;
    private String testConfigKey;
    private String classificationFileName;
    private ParameterInterface javaLibraries;
    private ParameterInterface classFolders;
    private ParameterInterface sourceFolders;
    private Map tests = new HashMap();
    private int currentRequestNumber = 0;
    private long startTime;
    private long endTime;
    private String dcRootDir = "";
    Dispatcher dispatcher = null;
    static /* synthetic */ Class class$com$sap$tc$jtools$jlint$cbs$ant$JLinCBSCompilerAdapter;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute() {
        if (!this.doNormalCompile()) {
            return false;
        }
        try {
            boolean init;
            block15: {
                this.startTime = System.currentTimeMillis();
                this.jlinLog("Starting ...", 2);
                init = false;
                String msg = null;
                try {
                    Object var5_4;
                    try {
                        this.initialize();
                        this.copyConfigFilesIfNecessary();
                        init = true;
                    }
                    catch (JlinInitException ie) {
                        msg = "ERROR: " + ((Throwable)((Object)ie)).getMessage();
                        init = false;
                        var5_4 = null;
                        this.logConfiguration();
                        if (msg != null) {
                            this.jlinLog(msg, 0);
                        }
                        break block15;
                    }
                    var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    this.logConfiguration();
                    if (msg != null) {
                        this.jlinLog(msg, 0);
                    }
                    throw throwable;
                }
                this.logConfiguration();
                if (msg != null) {
                    this.jlinLog(msg, 0);
                }
            }
            if (!init) {
                this.jlinLog("Aborting due to initialization exception", 0);
                return true;
            }
            JavaFileArrayTestObject[] testObjects = this.getTestObjects();
            int testObjNo = 0;
            block6: while (true) {
                if (testObjNo >= testObjects.length) {
                    this.logEnd();
                    return true;
                }
                this.jlinLog("request number: " + this.currentRequestNumber);
                PerformRequest performRequest = new PerformRequest("Request_" + this.currentRequestNumber);
                performRequest.addParameter(this.javaLibraries);
                performRequest.addParameter(this.classFolders);
                performRequest.addParameter(this.sourceFolders);
                this.addTests(performRequest);
                int fileCount = 0;
                while (true) {
                    if (testObjNo >= testObjects.length || fileCount >= 200) {
                        this.saveRequest(performRequest, this.currentRequestNumber);
                        PerformResponse performResponse = this.performRequest(performRequest);
                        this.saveResponse(performResponse, this.currentRequestNumber);
                        ++this.currentRequestNumber;
                        continue block6;
                    }
                    performRequest.addSource((TestObject)testObjects[testObjNo]);
                    fileCount += testObjects[testObjNo].getFileNames().length;
                    ++testObjNo;
                }
                break;
            }
        }
        catch (Throwable t) {
            this.jlinLog(t);
            return true;
        }
    }

    private boolean doNormalCompile() {
        CompilerAdapter compiler = this.getCompilerAdapter();
        boolean success = false;
        try {
            this.jlinLog("Source compilation starting...");
            success = compiler.execute();
            if (success) {
                this.jlinLog("Source compilation successfully completed.");
            } else {
                this.jlinLog("Source compilation failed.");
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.attributes.getProject().setProperty(ANT_PROPERTY_BUILD_COMPILER, (class$com$sap$tc$jtools$jlint$cbs$ant$JLinCBSCompilerAdapter == null ? (class$com$sap$tc$jtools$jlint$cbs$ant$JLinCBSCompilerAdapter = JLinCBSCompilerAdapter.class$("com.sap.tc.jtools.jlint.cbs.ant.JLinCBSCompilerAdapter")) : class$com$sap$tc$jtools$jlint$cbs$ant$JLinCBSCompilerAdapter).getName());
            throw throwable;
        }
        this.attributes.getProject().setProperty(ANT_PROPERTY_BUILD_COMPILER, (class$com$sap$tc$jtools$jlint$cbs$ant$JLinCBSCompilerAdapter == null ? (class$com$sap$tc$jtools$jlint$cbs$ant$JLinCBSCompilerAdapter = JLinCBSCompilerAdapter.class$("com.sap.tc.jtools.jlint.cbs.ant.JLinCBSCompilerAdapter")) : class$com$sap$tc$jtools$jlint$cbs$ant$JLinCBSCompilerAdapter).getName());
        return success;
    }

    private CompilerAdapter getCompilerAdapter() {
        String compilerName = this.attributes.isForkedJavac() ? EXTERNAL_JAVAC : MODERN_JAVAC;
        CompilerAdapter compiler = CompilerAdapterFactory.getCompiler((String)compilerName, (Task)this.attributes);
        this.attributes.getProject().setProperty(ANT_PROPERTY_BUILD_COMPILER, compilerName);
        compiler.setJavac(this.attributes);
        return compiler;
    }

    private void setRequestNumber() {
        while (new File(this.jlinLogDir + File.separator + "JLRequest_" + this.currentRequestNumber + ".xml").exists()) {
            ++this.currentRequestNumber;
        }
    }

    private void logEnd() {
        this.jlinLog("Successfully finished.", 2);
        this.endTime = System.currentTimeMillis();
        this.jlinLog("Execution time: " + NumberFormat.getNumberInstance().format(this.endTime - this.startTime) + " ms");
    }

    private void initialize() throws BadTreeException, FileNotFoundException, JlinInitException, IOException, XMLParseException {
        Project project = this.attributes.getProject();
        this.dcRootDir = project.getProperty(ANT_PROPERTY_DC_ROOT_DIR);
        if (this.dcRootDir == null || !new File(this.dcRootDir).isDirectory()) {
            this.jlinLog("ant property jlin.dc.root.dir: " + this.dcRootDir + "  is not a directory. Will be ignored.", 0);
        }
        this.jlinLogDir = project.getProperty(ANT_PROPERTY_JLIN_LOG_DIR);
        if (this.jlinLogDir == null) {
            throw new JlinInitException("ant property jlin.log.dir not set!");
        }
        File projectResultDir = new File(this.jlinLogDir);
        projectResultDir.mkdirs();
        this.jlinHomeDir = project.getProperty(ANT_PROPERTY_JLIN_HOME);
        if (this.jlinHomeDir == null || !new File(this.jlinHomeDir).isDirectory()) {
            throw new JlinInitException("ant property jlin.home.dir: " + this.jlinHomeDir + " is not a directory.");
        }
        this.localTestConfigFile = project.getProperty(ANT_PROPERTY_JLIN_TESTCFG_LOCAL_FILE);
        if (JLinCBSCompilerAdapter.empty(this.localTestConfigFile)) {
            File testconfig = new File(this.dcRootDir, "cfg/jlin_testconfig.xml");
            if (testconfig.isFile()) {
                this.localTestConfigFile = testconfig.getAbsolutePath();
                this.jlinLog("Tests from custom test config file " + testconfig.toString() + " will be run in addition to default tests.", 2);
            } else {
                this.jlinLog("Custom test config file " + testconfig.toString() + " not found.", 2);
            }
        }
        this.globalTestConfigFile = project.getProperty(ANT_PROPERTY_JLIN_TESTCFG_GLOBAL_FILE);
        this.testConfigKey = project.getProperty(ANT_PROPERTY_JLIN_TESTCFG_KEY);
        if (JLinCBSCompilerAdapter.empty(this.globalTestConfigFile) && !JLinCBSCompilerAdapter.empty(this.testConfigKey)) {
            File testCfgFile = new File(this.jlinHomeDir, "testconfig/testconfig_" + this.testConfigKey + ".xml");
            if (testCfgFile.isFile()) {
                this.globalTestConfigFile = testCfgFile.getAbsolutePath();
            } else {
                this.jlinLog("jlin testconfig key: \"" + this.testConfigKey + "\" is unknown. Fallback to default test config.", 1);
            }
        }
        if (JLinCBSCompilerAdapter.empty(this.globalTestConfigFile)) {
            this.globalTestConfigFile = new File(this.jlinHomeDir, DEFAULT_TESTCFG_GLOBAL_FILENAME).getAbsolutePath();
        } else {
            this.jlinLog("Custom test config file " + this.globalTestConfigFile + " will be used.", 2);
        }
        this.classificationFileName = project.getProperty(ANT_PROPERTY_CLASSIFICATION_FILE);
        if (this.classificationFileName == null) {
            this.classificationFileName = new File(this.dcRootDir, "cfg/jlin_classification.xml").getAbsolutePath();
        }
        File configFile = new File(this.jlinHomeDir, DEFAULT_CONFIG_FILENAME);
        TestProvider provider = null;
        provider = TestProvider.isInitialized() ? TestProvider.getTestProvider() : TestProvider.initialize((File)configFile);
        this.dispatcher = new Dispatcher((TestProviderInterface)provider);
        this.setSearchPaths();
        this.setTests();
        this.setRequestNumber();
    }

    private void logConfiguration() throws IOException {
        this.jlinLog("ant properties:");
        this.jlinLog("jlin.home.dir:                   " + this.jlinHomeDir);
        this.jlinLog("jlin.log.dir:                    " + this.jlinLogDir);
        this.jlinLog("jlin.testconfig.global.file:     " + this.globalTestConfigFile);
        this.jlinLog("jlin.testconfig.local.file:      " + this.localTestConfigFile);
        this.jlinLog("jlin.codeclassification.file:    " + this.classificationFileName);
        this.jlinLog("jlin.dc.root.dir:                " + this.dcRootDir);
        this.jlinLog("jlin.testconfig.key:             " + this.testConfigKey);
    }

    private void setTests() throws JlinInitException {
        File globalTestFile = new File(this.globalTestConfigFile);
        TestSet globalTestSet = null;
        try {
            globalTestSet = this.readTestSet(globalTestFile);
        }
        catch (XMLParseException e) {
            this.jlinLog("Exception occured reading testconfig file " + this.globalTestConfigFile, 0);
            this.jlinLog(e);
            File defaultTestConfigFile = new File(this.jlinHomeDir, DEFAULT_TESTCFG_GLOBAL_FILENAME);
            this.jlinLog("Fallback to default testconfig file: " + defaultTestConfigFile.getAbsolutePath());
            try {
                globalTestSet = this.readTestSet(defaultTestConfigFile);
            }
            catch (XMLParseException xpe) {
                throw new JlinInitException(xpe);
            }
        }
        Test[] globalTestArray = globalTestSet.getActiveTests();
        int i = 0;
        while (i < globalTestArray.length) {
            this.tests.put(globalTestArray[i].getName(), globalTestArray[i]);
            ++i;
        }
        if (this.localTestConfigFile != null) {
            TestSet localTestSet = null;
            try {
                localTestSet = this.readTestSet(new File(this.localTestConfigFile));
            }
            catch (XMLParseException e) {
                this.jlinLog("Exception caught reading local testconfig file " + this.localTestConfigFile + ": " + e.getMessage(), 0);
                this.jlinLog("local testconfig file will be ignored.", 0);
                return;
            }
            Test[] localTests = localTestSet.getActiveTests();
            int i2 = 0;
            while (i2 < localTests.length) {
                String name = localTests[i2].getName();
                if (!this.tests.containsKey(name)) {
                    this.tests.put(localTests[i2].getName(), localTests[i2]);
                }
                ++i2;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TestSet readTestSet(File testSetFile) throws XMLParseException {
        Properties macros = new Properties();
        macros.setProperty("CURRENT_DIRECTORY", testSetFile.getParent());
        TestSet testSet = null;
        Reader fr = null;
        try {
            try {
                fr = new BufferedReader(new FileReader(testSetFile));
                testSet = new TestSet(XMLTool.parseReader((Reader)fr).resolveMacros(macros));
            }
            catch (FileNotFoundException e) {
                throw new XMLParseException(e.getMessage());
            }
            catch (BadTreeException e) {
                throw new XMLParseException(e.getMessage());
            }
            catch (IOException e) {
                throw new XMLParseException(e.getMessage());
            }
            Object var9_5 = null;
        }
        catch (Throwable throwable) {
            Object var9_6 = null;
            try {
                fr.close();
                throw throwable;
            }
            catch (IOException e1) {
                throw new XMLParseException(e1.getMessage());
            }
        }
        try {}
        catch (IOException e1) {
            throw new XMLParseException(e1.getMessage());
        }
        fr.close();
        return testSet;
    }

    private void saveResponse(PerformResponse performResponse, int currentRequestIndex) {
        File responseFile = new File(this.jlinLogDir, "JLResults_" + currentRequestIndex + ".xml");
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(responseFile));
            XMLTool.writeDocument((StructureTree)performResponse.toStructureTree(), (Writer)writer);
            writer.close();
            this.jlinLog("Perform response saved to file " + responseFile.getAbsolutePath());
        }
        catch (Exception e) {
            this.jlinLog(e);
        }
    }

    private PerformResponse performRequest(PerformRequest performRequest) {
        PerformResponse performResponse = null;
        try {
            this.jlinLog("Starting perform request...");
            performResponse = this.dispatcher.processRequest(performRequest);
            this.jlinLog("Request processed");
        }
        catch (Exception e) {
            this.jlinLog(e);
        }
        return performResponse;
    }

    private void saveRequest(PerformRequest performRequest, int currentRequestIndex) {
        try {
            File reqFile = new File(this.jlinLogDir, "JLRequest_" + currentRequestIndex + ".xml");
            BufferedWriter writer = new BufferedWriter(new FileWriter(reqFile));
            XMLTool.writeDocument((StructureTree)performRequest.toStructureTree(), (Writer)writer);
            writer.close();
            this.jlinLog("Perform request saved to file " + reqFile.getAbsolutePath());
        }
        catch (IOException ioe) {
            this.jlinLog(ioe);
        }
    }

    private void addTests(PerformRequest performRequest) {
        Iterator iter = this.tests.values().iterator();
        while (iter.hasNext()) {
            performRequest.addTest((Test)iter.next());
        }
    }

    private void setSearchPaths() {
        ArrayList<String> jarLibraries = new ArrayList<String>();
        ArrayList<String> sourceFoldersList = new ArrayList<String>();
        ArrayList<String> classFoldersList = new ArrayList<String>();
        this.includeJavaRuntime = true;
        String[] mixedLibraries = this.getCompileClasspath().list();
        int i = 0;
        while (i < mixedLibraries.length) {
            if (mixedLibraries[i].endsWith(JAR_EXTENSION)) {
                jarLibraries.add(mixedLibraries[i].replace('\\', '/'));
            } else {
                sourceFoldersList.add(mixedLibraries[i].replace('\\', '/'));
                classFoldersList.add(mixedLibraries[i].replace('\\', '/'));
            }
            ++i;
        }
        Javac javac = this.getJavac();
        String[] sources = javac.getSrcdir().list();
        int i2 = 0;
        while (i2 < sources.length) {
            sourceFoldersList.add(sources[i2].replace('\\', '/'));
            ++i2;
        }
        File destDir = javac.getDestdir();
        if (destDir == null) {
            int i3 = 0;
            while (i3 < sources.length) {
                classFoldersList.add(sources[i3].replace('\\', '/'));
                ++i3;
            }
        } else {
            classFoldersList.add(destDir.toString().replace('\\', '/'));
        }
        this.javaLibraries = ParameterTool.createParameter((String)PARAMETER_JAVA_LIBRARIES, (String)"STRING[]", (Object)jarLibraries.toArray(new String[jarLibraries.size()]));
        this.classFolders = ParameterTool.createParameter((String)PARAMETER_CLASS_FOLDERS, (String)"STRING[]", (Object)classFoldersList.toArray(new String[classFoldersList.size()]));
        this.sourceFolders = ParameterTool.createParameter((String)PARAMETER_SOURCE_FOLDERS, (String)"STRING[]", (Object)sourceFoldersList.toArray(new String[sourceFoldersList.size()]));
    }

    private JavaFileArrayTestObject[] getTestObjects() throws IOException, InvalidTestObjectSpecification {
        String[] srcDirs = this.getJavac().getSrcdir().list();
        HashMap<String, String[]> fileMap = new HashMap<String, String[]>(srcDirs.length);
        ArrayList<JavaFileList> javaFileBundleList = new ArrayList<JavaFileList>();
        File[] filesToBeCompiled = this.getJavac().getFileList();
        ArrayList<String> srcFiles = new ArrayList<String>(filesToBeCompiled.length);
        int i = 0;
        while (i < filesToBeCompiled.length) {
            srcFiles.add(filesToBeCompiled[i].getCanonicalPath());
            ++i;
        }
        int i2 = 0;
        while (i2 < srcDirs.length) {
            ArrayList<String> matchingFiles = new ArrayList<String>();
            String srcDir = this.project.resolveFile(srcDirs[i2]).getCanonicalPath().replace('\\', '/');
            Iterator iter = srcFiles.iterator();
            while (iter.hasNext()) {
                String src = ((String)iter.next()).replace('\\', '/');
                if (!src.startsWith(srcDir)) continue;
                matchingFiles.add(src.substring(srcDir.length() + 1));
                iter.remove();
            }
            fileMap.put(srcDir, matchingFiles.toArray(new String[matchingFiles.size()]));
            ++i2;
        }
        Iterator iter = fileMap.keySet().iterator();
        while (iter.hasNext()) {
            String baseDir = (String)iter.next();
            String[] files = (String[])fileMap.get(baseDir);
            if (files.length < 200) {
                javaFileBundleList.add(new JavaFileList(baseDir, files));
                continue;
            }
            int fileCount = 0;
            while (fileCount < files.length) {
                int arraySize = fileCount + 200 < files.length ? 200 : files.length - fileCount;
                String[] fileArrayChunk = new String[arraySize];
                System.arraycopy(files, fileCount, fileArrayChunk, 0, arraySize);
                javaFileBundleList.add(new JavaFileList(baseDir, fileArrayChunk));
                fileCount += arraySize;
            }
        }
        JavaTestObjectCreator creator = this.getTestObjCreator();
        return creator.createTestObjects(javaFileBundleList.toArray(new JavaFileList[0]));
    }

    /*
     * Unable to fully structure code
     */
    private JavaTestObjectCreator getTestObjCreator() {
        block21: {
            dc = null;
            try {
                dc = DCUtil.parseDCDef(this.dcRootDir);
                this.jlinLog(".dcdef file will be used for code classification.", 2);
            }
            catch (ProviderException e1) {
                this.jlinLog("Exception caught parsing .dcdef file; file will be ignored.", 0);
                this.jlinLog(e1);
            }
            classificationFile = new File(this.classificationFileName);
            classification = null;
            if (!classificationFile.isFile()) {
                this.jlinLog("Custom code classification file " + this.classificationFileName + " not found.", 2);
                classification = new CodeClassification(null, dc);
            } else {
                fileReader = null;
                try {
                    fileReader = new BufferedReader(new FileReader(classificationFile));
                    classification = new CodeClassification(XMLTool.parseReader((Reader)fileReader), dc);
                    this.jlinLog("Custom code classification file " + classificationFile.toString() + " will be used.", 2);
                    var9_6 = null;
                    ** if (fileReader == null) goto lbl-1000
                }
                catch (Throwable var8_19) {
                    var9_10 = null;
                    if (fileReader != null) {
                        try {
                            fileReader.close();
                        }
                        catch (IOException e) {
                            this.jlinLog(e);
                            classification = new CodeClassification(null, dc);
                        }
                    }
                    throw var8_19;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        fileReader.close();
                    }
                    catch (IOException e) {
                        this.jlinLog(e);
                        classification = new CodeClassification(null, dc);
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block21;
                    catch (FileNotFoundException e) {
                        this.handleReadClassificationException(e, classificationFile);
                        classification = new CodeClassification(null, dc);
                        var9_7 = null;
                        if (fileReader != null) {
                            try {
                                fileReader.close();
                            }
                            catch (IOException e) {
                                this.jlinLog(e);
                                classification = new CodeClassification(null, dc);
                            }
                        }
                        break block21;
                    }
                    catch (IOException e) {
                        this.handleReadClassificationException(e, classificationFile);
                        classification = new CodeClassification(null, dc);
                        var9_8 = null;
                        if (fileReader != null) {
                            try {
                                fileReader.close();
                            }
                            catch (IOException e) {
                                this.jlinLog(e);
                                classification = new CodeClassification(null, dc);
                            }
                        }
                        break block21;
                    }
                    catch (XMLParseException e) {
                        this.handleReadClassificationException((Exception)e, classificationFile);
                        classification = new CodeClassification(null, dc);
                        var9_9 = null;
                        if (fileReader != null) {
                            try {
                                fileReader.close();
                            }
                            catch (IOException e) {
                                this.jlinLog(e);
                                classification = new CodeClassification(null, dc);
                            }
                        }
                    }
                }
            }
        }
        this.checkClassification(classification);
        return new JavaTestObjectCreator(classification);
    }

    private void checkClassification(CodeClassification classification) {
        String[] malformedPatterns;
        String[] unknownAttr = classification.getUnknownUsedAttributes();
        if (unknownAttr.length > 0) {
            StringBuffer msg = new StringBuffer("Unknown code classification attributes used will be ignored: ");
            int i = 0;
            while (i < unknownAttr.length) {
                if (i > 0) {
                    msg.append(", ");
                }
                msg.append(unknownAttr[i]);
                ++i;
            }
            this.jlinLog(msg.toString(), 0);
        }
        if ((malformedPatterns = classification.getMalFormedPatterns()).length > 0) {
            StringBuffer msg = new StringBuffer("Malformed regular expressions will be ignored: ");
            int i = 0;
            while (i < malformedPatterns.length) {
                if (i > 0) {
                    msg.append(", ");
                }
                msg.append(malformedPatterns[i]);
                ++i;
            }
            this.jlinLog(msg.toString(), 0);
        }
        this.jlinLog("For details on which test has been run on which source and code classification, see the JLRequest*.xml files in " + this.jlinLogDir, 2);
    }

    private void handleReadClassificationException(Exception e, File classificationFile) {
        this.jlinLog("exception caught reading " + classificationFile.toString() + ": " + e.toString(), 0);
        this.jlinLog("File will be ignored.", 0);
        this.jlinLog(e);
    }

    private static boolean empty(String string) {
        return string == null || string.trim().equals("");
    }

    private void jlinLog(String message) {
        this.jlinLog(message, 3);
    }

    private void jlinLog(String message, int severity) {
        this.attributes.log("[JLin] " + message, severity);
    }

    private void jlinLog(Throwable t) {
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        this.jlinLog("Exception occured:\n" + writer.toString(), 0);
    }

    private void copyConfigFilesIfNecessary() {
        File testconfigFile = new File(this.jlinLogDir, "jlin_settings/variants/testconfig.xml");
        File testDescriptorFile = new File(this.jlinLogDir, "jlin_settings/tests/tests.xml");
        if (testconfigFile.isFile() && testDescriptorFile.isFile()) {
            return;
        }
        FileUtils fileUtils = FileUtils.newFileUtils();
        try {
            fileUtils.copyFile(new File(this.jlinHomeDir, DEFAULT_TESTCFG_GLOBAL_FILENAME), testconfigFile);
            TestProvider testProvider = TestProvider.isInitialized() ? TestProvider.getTestProvider() : TestProvider.initialize((File)new File(this.jlinHomeDir, DEFAULT_CONFIG_FILENAME));
            testDescriptorFile.getParentFile().mkdirs();
            XMLTool.writeDocument((StructureTree)testProvider.getTestDescriptionSet().toStructureTree(), (Writer)new BufferedWriter(new FileWriter(testDescriptorFile)));
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

