/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.license;

import com.togethersoft.selena.license.ClassMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.StringTokenizer;

public class StackTrace {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String DESCRAMBLED_METHOD_PREFIX = "; ";
    private String myTrace;

    public StackTrace(String string) {
        if (string == null) {
            string = "";
        }
        this.myTrace = string;
    }

    public String descramble(ClassMap classMap) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        BufferedReader bufferedReader = new BufferedReader(new StringReader(this.myTrace));
        try {
            String string = bufferedReader.readLine();
            while (string != null) {
                printWriter.println(this.descrambleUnambiguous(string, classMap));
                String string2 = this.descrambleUmbiguous(string, classMap);
                if (!string2.equals("")) {
                    printWriter.println(this.descrambleUmbiguous(string, classMap));
                }
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        stringWriter.flush();
        return stringWriter.toString();
    }

    private String descrambleUmbiguous(String string, ClassMap classMap) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t", false);
        while (stringTokenizer.hasMoreTokens()) {
            int n2;
            String string2 = stringTokenizer.nextToken();
            String[] stringArray = classMap.descrambleMethod(string2 = this.convertToDescramble(string2));
            if (stringArray.length > 0) {
                n2 = 0;
                while (n2 < stringArray.length) {
                    stringBuffer.append(DESCRAMBLED_METHOD_PREFIX);
                    stringBuffer.append(stringArray[n2]);
                    stringBuffer.append(LINE_SEPARATOR);
                    ++n2;
                }
                continue;
            }
            if (string2.indexOf(".") == -1) continue;
            n2 = string2.lastIndexOf(".");
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n2 + 1);
            if ((string3 = classMap.descrambleClass(string3)) == "---Problems with Unscrambling it---") continue;
            stringBuffer.append(DESCRAMBLED_METHOD_PREFIX);
            stringBuffer.append(string3);
            stringBuffer.append(".");
            stringBuffer.append(string4);
            stringBuffer.append(LINE_SEPARATOR);
        }
        return stringBuffer.toString();
    }

    private String descrambleUnambiguous(String string, ClassMap classMap) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = this.convertToDescramble(string2);
            if (classMap.descrambleClass(string3) != "---Problems with Unscrambling it---") {
                stringBuffer.append(classMap.descrambleClass(string3));
                continue;
            }
            if (classMap.descramblePackage(string3) != "---Problems with Unscrambling it---") {
                stringBuffer.append(classMap.descramblePackage(string3));
                continue;
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private String convertToDescramble(String string) {
        int n2 = (string = string.replace('/', '.')).indexOf("(");
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        return string;
    }
}

