/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.license;

import com.togethersoft.selena.license.ClassMap;
import com.togethersoft.selena.license.ConfigProperties;
import com.togethersoft.selena.license.ErrorHandler$1;
import com.togethersoft.selena.license.Messages;
import com.togethersoft.selena.license.PathUtil;
import com.togethersoft.selena.license.StackTrace;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.boot.IPlatformConfiguration;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;

public class ErrorHandler
implements ILogListener {
    private static String ourBuildNumber;
    private static ClassMap ourClassMap;
    private static final String ERROR_EMAIL = "mailto:Exception.Selena@togethersoft.com?Subject=Together Error Report";
    private static final String SESSION_MARKER = "!SESSION";
    private static final String WSAD_FEATURE_MARKER = "wsappdev";
    private static final String BUILD_NUM_FILE = "buildnum.txt";
    private static final String CLASS_MAP_FILE;
    private static final String UNKNOWN;
    private static final String EOL;
    private static final String UNKNOWN_TYPE = "unknown";
    private static final String WSWB_PLATFORM = "Eclipse";
    private static final String WSAD_PLATFORM = "WS";
    private static final String ERROR_TYPE = "ERROR";
    private static final String WARNING_TYPE = "WARNING";
    private static final String INFO_TYPE = "INFO";
    private static final String OK_TYPE = "OK";
    private static final Integer ERROR_SEVERITY;
    private static final Integer WARNING_SEVERITY;
    private static final Integer INFO_SEVERITY;
    private static final Integer OK_SEVERITY;
    private Map myTypes;
    private Map myPropertyNames;
    private volatile boolean myIsShowing;
    private volatile int myErrorCount;

    public ErrorHandler() {
        this.init();
    }

    public void logging(IStatus iStatus, String string) {
        if (iStatus != null && this.isValid(iStatus)) {
            if (this.myErrorCount > 0) {
                ++this.myErrorCount;
                return;
            }
            this.myErrorCount = 1;
            this.displayExceptionDialog(iStatus);
        }
    }

    protected void init() {
        this.myTypes = new HashMap();
        this.myPropertyNames = new HashMap();
        this.myTypes.put(OK_SEVERITY, OK_TYPE);
        this.myTypes.put(INFO_SEVERITY, INFO_TYPE);
        this.myTypes.put(WARNING_SEVERITY, WARNING_TYPE);
        this.myTypes.put(ERROR_SEVERITY, ERROR_TYPE);
        this.myTypes.put(null, UNKNOWN_TYPE);
        this.myPropertyNames.put(OK_SEVERITY, "error.report.dialog.ok");
        this.myPropertyNames.put(INFO_SEVERITY, "error.report.dialog.info");
        this.myPropertyNames.put(WARNING_SEVERITY, "error.report.dialog.warning");
        this.myPropertyNames.put(ERROR_SEVERITY, "error.report.dialog.error");
        this.myPropertyNames.put(null, "error.report.dialog.error");
    }

    protected boolean isValid(IStatus iStatus) {
        if (!ConfigProperties.getPreferenceStore().getBoolean("error.report.dialog")) {
            return false;
        }
        String string = (String)this.myTypes.get(new Integer(iStatus.getSeverity()));
        String string2 = (String)this.myPropertyNames.get(new Integer(iStatus.getSeverity()));
        if (string == null || string2 == null || !ConfigProperties.getPreferenceStore().getBoolean(string2)) {
            return false;
        }
        if (ConfigProperties.getPreferenceStore().getBoolean("error.report.dialog.exception") && iStatus.getException() == null) {
            return false;
        }
        return !"Unhandled exception caught in event loop.".equals(iStatus.getMessage()) || iStatus.getException() != null;
    }

    protected String getTypeName(IStatus iStatus) {
        if (iStatus == null) {
            return UNKNOWN_TYPE;
        }
        return (String)this.myTypes.get(new Integer(iStatus.getSeverity()));
    }

    protected void displayExceptionDialog(IStatus iStatus) {
        Display.getDefault().asyncExec((Runnable)new ErrorHandler$1(this, iStatus));
    }

    protected void sendLogFile(IStatus iStatus) {
        Object object;
        IPath iPath = Platform.getLogFileLocation();
        Clipboard clipboard = new Clipboard(Display.getDefault());
        FileTransfer fileTransfer = FileTransfer.getInstance();
        String string = ErrorHandler.getFileContents(iPath);
        if (string.lastIndexOf(SESSION_MARKER) >= 0) {
            string = string.substring(string.lastIndexOf(SESSION_MARKER));
        }
        if (iStatus.getException() != null) {
            object = new StringWriter();
            iStatus.getException().printStackTrace(new PrintWriter((Writer)object));
            StackTrace stackTrace = new StackTrace(((StringWriter)object).getBuffer().toString());
            System.gc();
            if (ErrorHandler.getClassMap() != null) {
                String string2 = stackTrace.descramble(ErrorHandler.getClassMap());
                string = string + EOL + EOL + Messages.getString("ErrorHandler.Last_exception_descrambled____12") + EOL + EOL + string2;
                ourClassMap = null;
                System.gc();
            }
        }
        object = ErrorHandler.getBuildNumber();
        object = Messages.getString("ErrorHandler.TWSE_version____13") + (String)object;
        string = EOL + (String)object + EOL + EOL + string;
        clipboard.setContents(new Object[]{string}, new Transfer[]{TextTransfer.getInstance()});
        clipboard.dispose();
        Program.launch((String)("mailto:Exception.Selena@togethersoft.com?Subject=Together Error Report, " + (String)object));
    }

    protected static ClassMap getClassMap() {
        if (ourClassMap != null) {
            return ourClassMap;
        }
        File file = ErrorHandler.findFileInRoot(CLASS_MAP_FILE);
        if (file == null) {
            return null;
        }
        ourClassMap = new ClassMap(file);
        return ourClassMap;
    }

    protected static File findFileInRoot(String string) {
        String[] stringArray = PathUtil.getSiteUrls();
        if (stringArray == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            File file = new File(stringArray[n2]);
            if (!file.getAbsolutePath().endsWith("wswb")) {
                File file2 = new File(file, string);
                if (!file2.exists() || !file2.canRead()) {
                    file2 = new File(file.getParentFile(), string);
                }
                if (file2.exists() && file2.canRead()) {
                    return file2;
                }
            }
            ++n2;
        }
        return null;
    }

    protected static String getFileContents(IPath iPath) {
        File file = iPath.toFile();
        if (file == null || !file.exists() || !file.canRead()) {
            return null;
        }
        byte[] byArray = new byte[(int)file.length()];
        try {
            new FileInputStream(file).read(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        return new String(byArray);
    }

    protected static String getBuildNumber() {
        if (ourBuildNumber != null) {
            return ourBuildNumber;
        }
        File file = ErrorHandler.findFileInRoot(BUILD_NUM_FILE);
        ourBuildNumber = file == null ? UNKNOWN : ErrorHandler.getFileContents((IPath)new Path(file.getAbsolutePath()));
        if (ourBuildNumber == null) {
            ourBuildNumber = UNKNOWN;
        }
        return ourBuildNumber;
    }

    protected static String getPlatformName() {
        IPlatformConfiguration.IFeatureEntry[] iFeatureEntryArray = BootLoader.getCurrentPlatformConfiguration().getConfiguredFeatureEntries();
        if (iFeatureEntryArray != null) {
            int n2 = 0;
            while (n2 < iFeatureEntryArray.length) {
                IPlatformConfiguration.IFeatureEntry iFeatureEntry = iFeatureEntryArray[n2];
                if (iFeatureEntry.getFeatureIdentifier() != null && iFeatureEntry.getFeatureIdentifier().indexOf(WSAD_FEATURE_MARKER) > 0) {
                    return WSAD_PLATFORM;
                }
                ++n2;
            }
        }
        return WSWB_PLATFORM;
    }

    protected static String getCurrentDate() {
        Date date = new Date(System.currentTimeMillis());
        return DateFormat.getDateInstance(3, Locale.getDefault()).format(date);
    }

    static String access$000() {
        return EOL;
    }

    static int access$100(ErrorHandler errorHandler) {
        return errorHandler.myErrorCount;
    }

    static int access$102(ErrorHandler errorHandler, int n2) {
        errorHandler.myErrorCount = n2;
        return errorHandler.myErrorCount;
    }

    static {
        CLASS_MAP_FILE = ErrorHandler.getBuildNumber() + "." + ErrorHandler.getPlatformName() + ".scramble.map";
        UNKNOWN = "unknown (probably compiled) : " + ErrorHandler.getCurrentDate();
        EOL = System.getProperty("line.separator");
        ERROR_SEVERITY = new Integer(4);
        WARNING_SEVERITY = new Integer(2);
        INFO_SEVERITY = new Integer(1);
        OK_SEVERITY = new Integer(0);
    }
}

