/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.license;

import com.togethersoft.selena.license.ClassMap;
import com.togethersoft.selena.license.StackTrace;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;

public class Descrambler {
    public static final String BUILD_NUM_KEY = "-build";
    public static final String UPLOAD_LOCATION_KEY = "-upload";
    public static final String MAP_FILE_KEY = "-map";
    public static final String MULTIPLE_EXECUTION_KEY = "-multiple";
    public static final String WSAD_KEY = "-wsad";
    private static final String HELP_KEYS = "--h /? --help /help --?";
    public static final String MAP_FILE_PATH_KEY = "-mapfile";
    public static final String UPLOAD_LOCATION_DEFAULT = "\\\\Czprsptw01\\java\\DeploySelena\\upload";
    private static final String WSAD_MAP_PREFIX = ".WSAD";
    private static final String[] MAP_FILE_DEFAULT_SUFFIX = new String[]{".scramble.map", ".WSWB.scramble.map"};
    private static final String EXIT_STING = "n";
    private String myBuildNum = null;
    private String myUploadLocation = null;
    private String myMapFileName = null;
    private String myMapFilePath = null;
    private boolean myMultipleExecuition = false;
    private boolean myWSAD = false;
    private File myMapFile = null;
    private ClassMap myMap = null;
    private String[] myArguments;

    public static void main(String[] stringArray) {
        Descrambler.printHeader();
        if (stringArray.length == 1 && HELP_KEYS.indexOf(stringArray[0]) != -1) {
            Descrambler.printHelp();
            return;
        }
        Descrambler descrambler = new Descrambler(stringArray);
        descrambler.descrambleClip();
        System.out.println("Exiting.");
        System.exit(0);
    }

    private static void printHeader() {
        System.out.println("Stack Trace descrambler for ZelixKlassMaster.");
        System.out.println("(c) TogetherSoft");
        System.out.println("");
    }

    private static void printHelp() {
        System.out.println("Parameters:");
        System.out.println("\t-build <build_number> [-upload <upload_direcotry>] [-map <scrambler_map_file>] [-multiple] [-wsad]");
        System.out.println("");
        System.out.println("Where:");
        System.out.println("\t<build_number>\t\t-\tfull number for build (like: 460.2)");
        System.out.println("\t<upload_directory>\t-\tdirectory where builds are stored (like: j:\\DeploySelena\\upload)");
        System.out.println("\t<scrambler_map_file>\t-\tname of the mapping file, created by ZelixKlassMaster (tm) scrambler (like: 462.1.scramble.map)");
        System.out.println("\t-multiple\t\t-\tload map file onece and perform several stacktrace translations");
        System.out.println("\t-wsad\t\t-\tuse WSAD-specific map file");
        System.out.println("By default you should specify only the number of the build - all the other parameters should be substituted automatically");
        System.out.println("");
    }

    private Descrambler(String[] stringArray) {
        this.parseArguments(stringArray);
    }

    private void descrambleClip() {
        ClassMap classMap = this.getMap();
        if (classMap == null) {
            return;
        }
        System.gc();
        do {
            Object object;
            block7: {
                if (this.myMultipleExecuition) {
                    try {
                        while (System.in.available() > 0) {
                            System.in.read();
                        }
                        System.out.print("TranslateException? ([Y]/n): ");
                        int n2 = System.in.read();
                        System.out.println();
                        object = new byte[]{(byte)n2};
                        String string = new String((byte[])object);
                        if (string.equalsIgnoreCase(EXIT_STING)) {
                        }
                        break block7;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    break;
                }
            }
            StackTrace stackTrace = this.getClipContents();
            object = stackTrace.descramble(classMap);
            this.setClipContents((String)object);
        } while (this.myMultipleExecuition);
    }

    private StackTrace getClipContents() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        try {
            String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            return new StackTrace(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
        }
        System.out.println("ERROR: Unable to read clipboard.");
        return new StackTrace("");
    }

    private void setClipContents(String string) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(string);
        clipboard.setContents(stringSelection, stringSelection);
    }

    private ClassMap getMap() {
        if (this.myMap != null) {
            return this.myMap;
        }
        if (!this.isValidParameters()) {
            return null;
        }
        this.myMap = new ClassMap(this.myMapFile);
        return this.myMap;
    }

    private void parseArguments(String[] stringArray) {
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (MULTIPLE_EXECUTION_KEY.equals(stringArray[n2])) {
                this.myMultipleExecuition = true;
            } else if (WSAD_KEY.equals(stringArray[n2])) {
                this.myWSAD = true;
            } else if (n2 + 1 < stringArray.length) {
                if (BUILD_NUM_KEY.equals(stringArray[n2])) {
                    this.myBuildNum = stringArray[++n2];
                } else if (UPLOAD_LOCATION_KEY.equals(stringArray[n2])) {
                    this.myUploadLocation = stringArray[++n2];
                } else if (MAP_FILE_KEY.equals(stringArray[n2])) {
                    this.myMapFileName = stringArray[++n2];
                } else if (MAP_FILE_PATH_KEY.equals(stringArray[n2])) {
                    this.myMapFilePath = stringArray[++n2];
                }
            }
            ++n2;
        }
    }

    private boolean isValidParameters() {
        int n2;
        if (this.myMapFile == null) {
            if (this.myMapFilePath != null) {
                this.myMapFile = new File(this.myMapFilePath);
            } else {
                if (this.myBuildNum == null) {
                    System.out.println("\tNo buildnum was specified.");
                    return false;
                }
                System.out.println("\tBuild number specified: " + this.myBuildNum);
                if (this.myUploadLocation != null) {
                    System.out.println("\tUpload location specified: " + this.myUploadLocation);
                } else {
                    this.myUploadLocation = UPLOAD_LOCATION_DEFAULT;
                    System.out.println("\tUsing upload location: " + this.myUploadLocation);
                }
                if (this.myMapFileName != null) {
                    System.out.println("\tMap file name specified: " + this.myMapFileName);
                    this.myMapFile = this.getMapFile(this.myMapFileName);
                } else {
                    n2 = 0;
                    while (n2 < MAP_FILE_DEFAULT_SUFFIX.length) {
                        this.myMapFile = this.getMapFile(this.myBuildNum + (this.myWSAD ? WSAD_MAP_PREFIX : "") + MAP_FILE_DEFAULT_SUFFIX[n2]);
                        if (this.myMapFile.exists()) {
                            this.myMapFileName = this.myMapFile.getName();
                            break;
                        }
                        ++n2;
                    }
                    System.out.println("\tUsing map file name: " + this.myMapFileName);
                }
            }
        }
        System.out.println("\tUsing map file: " + this.myMapFile.getAbsolutePath());
        System.out.println("");
        int n3 = n2 = this.myMapFile.exists() && !this.myMapFile.isDirectory() ? 1 : 0;
        if (n2 == 0) {
            System.out.println("Incorrecd map file specified.");
        }
        return n2 != 0;
    }

    private File getMapFile(String string) {
        return new File(this.myUploadLocation + File.separatorChar + this.getMapfileDirectory(this.myBuildNum) + File.separatorChar + string);
    }

    private String getMapfileDirectory(String string) {
        return string.replace('.', File.separatorChar);
    }
}

