/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.license;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class ClassMap {
    private static final String ZELIX_PACKAGE_PREFIX = "Package:";
    private static final String ZELIX_CLASS_PREFIX = "Class:";
    private static final String ZELIX_METHOD_PREFIX = "MethodsOf:";
    private static final String ZELIX_ATTRIBUTE_PREFIX = "FieldsOf:";
    private static final String ZELIX_OTHER_PREFIXES_SUBSTRING = ":";
    private static final String ZELIX_NAME_SEPARATOR = "=>";
    private static final String ZELIX_NAME_NOT_CHANGED_KEYWORD = "NameNotChanged";
    public static final String ORIGINAL_LINE_DELIMITERS = " \t";
    public static final String UNIFIED_LINE_DELIMITER = " ";
    public static final String MEMBER_NAME_PREFIX = ".";
    public static final String ATTRIBUTE_PARAMETER_START = "(";
    public static final String ATTRIBUTE_PARAMETER_END = ")";
    public static final String UNABLE_TO_UNSCRAMBLE = "---Problems with Unscrambling it---";
    private Map myScrambledMethods = new HashMap();
    private Map myUnscrambledMethods = new HashMap();
    private Map myScrambledAttributes = new HashMap();
    private Map myUnscrambledAttributes = new HashMap();
    private Map myScrambledClasses = new HashMap();
    private Map myUnScrambledClasses = new HashMap();
    private Map myScrambledPackages = new HashMap();
    private Map myUnScrambledPackages = new HashMap();
    private String myCurrentClassName = null;
    private boolean myProcessingMethods = false;

    public ClassMap(File file) {
        if (!file.exists() || file.isDirectory()) {
            System.out.println("Specified map-file nod existis or is a direcotry: " + file.getAbsolutePath());
            return;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = bufferedReader.readLine();
            while (string != null) {
                String string2 = this.getPureLine(string);
                if (string2.startsWith(ZELIX_PACKAGE_PREFIX)) {
                    this.processPackage(string2.substring(ZELIX_PACKAGE_PREFIX.length()));
                } else if (string2.startsWith(ZELIX_CLASS_PREFIX)) {
                    this.processClass(string2.substring(ZELIX_CLASS_PREFIX.length()));
                } else if (string2.startsWith(ZELIX_METHOD_PREFIX)) {
                    this.setCurrentClassName(string2.substring(ZELIX_METHOD_PREFIX.length()), true);
                } else if (string2.startsWith(ZELIX_ATTRIBUTE_PREFIX)) {
                    this.setCurrentClassName(string2.substring(ZELIX_METHOD_PREFIX.length()), false);
                } else if (string2.indexOf(ZELIX_OTHER_PREFIXES_SUBSTRING) == -1) {
                    if (this.myProcessingMethods) {
                        this.processMethod(string2);
                    } else {
                        this.processAttribute(string2);
                    }
                }
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String[] descrambleMethod(String string) {
        Collection collection = (Collection)this.myUnscrambledMethods.get(string);
        if (collection == null) {
            return new String[0];
        }
        return collection.toArray(new String[collection.size()]);
    }

    public String descrambleAttribute(String string) {
        if (this.myUnscrambledAttributes.containsKey(string)) {
            return (String)this.myUnscrambledAttributes.get(string);
        }
        return UNABLE_TO_UNSCRAMBLE;
    }

    public String descramblePackage(String string) {
        if (this.myUnScrambledPackages.containsKey(string)) {
            return (String)this.myUnScrambledPackages.get(string);
        }
        return UNABLE_TO_UNSCRAMBLE;
    }

    public String descrambleClass(String string) {
        if (this.myUnScrambledClasses.containsKey(string)) {
            return (String)this.myUnScrambledClasses.get(string);
        }
        return UNABLE_TO_UNSCRAMBLE;
    }

    private void processPackage(String string) {
        this.parseString(string, this.myUnScrambledPackages, this.myScrambledPackages);
    }

    private void processClass(String string) {
        this.parseString(string, this.myUnScrambledClasses, this.myScrambledClasses);
    }

    private void processMethod(String string) {
        if (this.myCurrentClassName == null) {
            return;
        }
        String string2 = (String)this.myScrambledClasses.get(this.myCurrentClassName);
        if (string2 == null) {
            // empty if block
        }
        this.parseString(string, this.myUnscrambledMethods, this.myScrambledMethods, true, this.myCurrentClassName + MEMBER_NAME_PREFIX, string2 + MEMBER_NAME_PREFIX);
    }

    private void processAttribute(String string) {
        if (this.myCurrentClassName == null) {
            return;
        }
        String string2 = (String)this.myScrambledClasses.get(this.myCurrentClassName);
        if (string2 == null) {
            // empty if block
        }
        this.parseString(string, this.myUnscrambledAttributes, this.myScrambledAttributes, false, this.myCurrentClassName + MEMBER_NAME_PREFIX, string2 + MEMBER_NAME_PREFIX);
    }

    private void parseString(String string, Map map, Map map2) {
        this.parseString(string, map, map2, false, "", "");
    }

    private void parseString(String string, Map map, Map map2, boolean bl, String string2, String string3) {
        Collection<String> collection;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, UNIFIED_LINE_DELIMITER);
        while (stringTokenizer.hasMoreTokens()) {
            collection = stringTokenizer.nextToken();
            if (string4 != null) {
                string5 = collection;
                break;
            }
            if (ZELIX_NAME_SEPARATOR.equals(collection)) {
                string4 = string6;
            } else if (ZELIX_NAME_NOT_CHANGED_KEYWORD.equals(collection)) {
                string4 = string6;
                string5 = string6;
            }
            string6 = collection;
        }
        if (string4 != null && string5 != null) {
            string4 = string2 + string4;
            string5 = string3 + string5;
            if (map2.containsKey(string4)) {
                // empty if block
            }
            map2.put(string4, string5);
            if (bl) {
                collection = (Collection)map.get(string5);
                if (collection == null) {
                    collection = new ArrayList<String>();
                    map.put(string5, collection);
                }
                collection.add(string4);
            } else {
                if (map.containsKey(string5)) {
                    // empty if block
                }
                map.put(string5, string4);
            }
        } else if (string4 != null || string5 != null) {
            // empty if block
        }
    }

    private void setCurrentClassName(String string, boolean bl) {
        this.myCurrentClassName = string.trim();
        this.myProcessingMethods = bl;
    }

    private String getPureLine(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ORIGINAL_LINE_DELIMITERS);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.indexOf(ATTRIBUTE_PARAMETER_START) != -1) {
                bl = true;
            }
            if (string2.indexOf(ATTRIBUTE_PARAMETER_END) != -1) {
                bl = false;
            }
            stringBuffer.append(string2);
            if (bl) continue;
            stringBuffer.append(UNIFIED_LINE_DELIMITER);
        }
        return stringBuffer.toString().trim();
    }
}

