/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.tools;

import com.sap.engine.interfaces.webservices.runtime.HTTPProxyResolver;
import com.sap.engine.lib.xml.util.BASE64Encoder;
import com.sap.engine.services.webservices.jaxm.soap.HTTPSocket;
import com.sap.engine.services.webservices.jaxrpc.exceptions.InvalidResponseCodeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WSDLDownloadResolver
implements EntityResolver {
    private String proxyHost;
    private int proxyPort;
    private String username;
    private String password;
    private HTTPProxyResolver proxyResolver;
    private static Properties cached = new Properties();

    public static String encodeAuth(String userName, String password) {
        byte[] result = BASE64Encoder.encode((byte[])(userName + ":" + password).getBytes());
        return new String(result, 0, result.length);
    }

    public String getPassword() {
        return this.password;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(int port) {
        this.proxyPort = port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setHTTPProxyResolver(HTTPProxyResolver proxyResolver) {
        this.proxyResolver = proxyResolver;
    }

    public InputSource resolveEntity(String publicID, String systemID) throws SAXException, IOException {
        if (systemID == null) {
            return null;
        }
        if (cached.getProperty(systemID) != null) {
            ClassLoader loader = this.getClass().getClassLoader();
            InputStream in = loader.getResourceAsStream("com/sap/engine/services/webservices/tools/cached/" + cached.getProperty(systemID));
            InputSource source = new InputSource(in);
            source.setSystemId(systemID);
            return source;
        }
        if (systemID != null && (systemID.startsWith("http://") || systemID.startsWith("https://"))) {
            OutputStream out;
            URL url = new URL(systemID);
            HTTPSocket socket = new HTTPSocket(url);
            socket.setIgnoreServerCertificates(true);
            socket.setRequestMethod("GET");
            socket.setHeader("Content-Length", "0");
            socket.setHeader("Connection", "close");
            if (this.proxyHost != null) {
                socket.setProxy(this.proxyHost, this.proxyPort);
            } else if (this.proxyResolver != null) {
                socket.setHTTPProxyResolver(this.proxyResolver);
            }
            if (this.username != null) {
                socket.setHeader("Authorization", "Basic " + WSDLDownloadResolver.encodeAuth(this.username, this.password));
            }
            try {
                out = socket.getOutputStream();
            }
            catch (IOException ioe) {
                StringBuffer buf = new StringBuffer("Cannot connect to ");
                buf.append(systemID);
                if (this.proxyHost != null) {
                    buf.append(", passing via http proxy: " + this.proxyHost + ":" + this.proxyPort);
                }
                if (this.username != null) {
                    buf.append(", used user to connect: " + this.username);
                }
                if (ioe.getLocalizedMessage() != null) {
                    buf.append(": " + ioe.getLocalizedMessage());
                }
                throw new IOException(buf.toString());
            }
            out.write("\r\n".getBytes());
            out.flush();
            InputStream in = socket.getInputStream();
            int responseCode = socket.getResponseCode();
            if (responseCode != 200) {
                if (responseCode == 301 && socket.getHeader("Location") != null) {
                    String[] location = socket.getHeader("Location");
                    return this.resolveEntity(publicID, location[0]);
                }
                String responseMsg = socket.getResponseMessage();
                Hashtable headers = socket.getHeaders();
                throw new InvalidResponseCodeException(responseCode, responseMsg, headers);
            }
            InputSource source = new InputSource(in);
            source.setSystemId(systemID);
            return source;
        }
        return null;
    }

    static {
        cached.setProperty("http://www.w3.org/2001/XMLSchema.xsd", "XMLSchema.xsd");
        cached.setProperty("http://www.w3.org/2001/XMLSchema.dtd", "XMLSchema.dtd");
        cached.setProperty("http://www.w3.org/2001/datatypes.dtd", "datatypes.dtd");
        cached.setProperty("http://www.w3.org/2001/xml.xsd", "xml.xsd");
    }
}

