/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.tools;

import com.sap.engine.lib.xml.parser.NestedSAXParseException;
import com.sap.engine.lib.xml.util.NestedException;
import com.sap.exception.IBaseException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Locale;
import javax.xml.transform.TransformerException;

public class ExceptionManager {
    public static Throwable getOriginalError(Throwable thr) {
        Throwable cause = null;
        if (thr instanceof IBaseException) {
            cause = ((IBaseException)thr).getCause();
        } else if (thr instanceof NestedException) {
            cause = ((NestedException)thr).getCause();
        } else if (thr instanceof NestedSAXParseException) {
            cause = ((NestedSAXParseException)thr).getException();
        } else if (thr instanceof TransformerException) {
            cause = ((TransformerException)thr).getException();
        } else if (thr instanceof RemoteException) {
            cause = ((RemoteException)thr).detail;
        } else if (thr instanceof InvocationTargetException) {
            cause = ((InvocationTargetException)thr).getTargetException();
        }
        if (cause != null) {
            return ExceptionManager.getOriginalError(cause);
        }
        return thr;
    }

    public static String getErrorMessage(Throwable thr) {
        Throwable originalError = ExceptionManager.getOriginalError(thr);
        if (originalError instanceof UnknownHostException) {
            if (originalError.getMessage() != null) {
                return "Unknown host. Check your proxy settings: " + originalError.getMessage();
            }
            return originalError.toString();
        }
        if (originalError instanceof ClassCastException) {
            return originalError.toString();
        }
        String msg = originalError instanceof IBaseException ? ((IBaseException)originalError).getLocalizedMessage(new Locale("en", "")) : originalError.getMessage();
        if (msg != null) {
            return msg;
        }
        return originalError.toString();
    }

    private static String getChainedErrors(Throwable thr) {
        if (thr == null) {
            return null;
        }
        Throwable cause = null;
        if (thr instanceof IBaseException) {
            cause = ((IBaseException)thr).getCause();
        } else if (thr instanceof NestedException) {
            cause = ((NestedException)thr).getCause();
        } else if (thr instanceof NestedSAXParseException) {
            cause = ((NestedSAXParseException)thr).getException();
        } else if (thr instanceof TransformerException) {
            cause = ((TransformerException)thr).getException();
        } else if (thr instanceof RemoteException) {
            cause = ((RemoteException)thr).detail;
        } else if (thr instanceof InvocationTargetException) {
            cause = ((InvocationTargetException)thr).getTargetException();
        }
        String res = thr.toString();
        if (cause != null) {
            res = res + "->";
            res = res + ExceptionManager.getChainedErrors(cause);
            return res;
        }
        return res;
    }

    public static void logThrowable(int severity, Category category, Location location, String method, Throwable throwable) {
        StringWriter writer = new StringWriter();
        PrintWriter wrapper = new PrintWriter(writer);
        throwable.printStackTrace(wrapper);
        if (category != null) {
            category.logT(severity, location, method, ExceptionManager.getChainedErrors(throwable));
        }
        location.logT(severity, method, throwable.toString());
        location.logT(severity, method, writer.toString());
    }

    public static void logThrowable(int severity, Category category, Location location, String method, String message, Throwable throwable) {
        StringWriter writer = new StringWriter();
        PrintWriter wrapper = new PrintWriter(writer);
        throwable.printStackTrace(wrapper);
        if (category != null) {
            category.logT(severity, location, method, message + " " + ExceptionManager.getChainedErrors(throwable));
        }
        location.logT(severity, method, throwable.toString());
        location.logT(severity, method, writer.toString());
    }

    public static void traceThrowable(int severity, Location location, String method, Throwable throwable) {
        StringWriter writer = new StringWriter();
        PrintWriter wrapper = new PrintWriter(writer);
        throwable.printStackTrace(wrapper);
        location.logT(severity, method, throwable.toString());
        location.logT(severity, method, writer.toString());
    }
}

