/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.wsdl2java.soapbinding;

import com.sap.engine.interfaces.webservices.runtime.HTTPProxyResolver;
import com.sap.engine.lib.xml.util.BASE64Encoder;
import com.sap.engine.services.webservices.jaxm.soap.HTTPSocket;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.PropertyContext;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.soapbinding.Cookie;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.soapbinding.HTTPTransportInterface;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;

public class HTTPTransport
implements HTTPTransportInterface {
    public static final String REQUEST_METHOD_POST = "POST";
    public static final String REQUEST_METHOD_GET = "GET";
    public static final String REQUEST_LOGGING_PROPERTY = "RequestLogging";
    public static final String RESPONSE_LOGGING_PROPERTY = "ResponseLogging";
    public static final String HTTP_PROXY_RESOLVER_PROPERTY = "HTTPProxyResolver";
    private String endpointURL;
    private String requestMethod;
    private PropertyContext config = new PropertyContext();
    private HTTPSocket httpSocket;
    private Hashtable headers = new Hashtable();

    public void init(String endpoint, String requestMethod, PropertyContext config) throws Exception {
        this.headers.clear();
        this.endpointURL = endpoint;
        this.requestMethod = requestMethod;
        if (config != null) {
            this.config = config;
        }
        this.httpSocket = this.createHTTPSocket(this.endpointURL, this.requestMethod);
    }

    public String getEndpoint() {
        return this.endpointURL;
    }

    public void setEndpoint(String endpoint) throws Exception {
        this.endpointURL = endpoint;
        this.httpSocket = this.createHTTPSocket(this.endpointURL, this.requestMethod);
    }

    public PropertyContext getFeature(String featureName) {
        return this.config.getSubContext(featureName);
    }

    private HTTPSocket createHTTPSocket(String endpoint, String requestMethod) throws Exception {
        PropertyContext feature;
        String timeOut;
        boolean secure = false;
        HTTPSocket sock = null;
        URL url = null;
        if (endpoint.toLowerCase().startsWith("https")) {
            String httpEndpoint = "http" + endpoint.substring(5);
            URL tmpUrl = new URL(httpEndpoint);
            URLStreamHandler httpsHandler = null;
            try {
                httpsHandler = (URLStreamHandler)Class.forName("iaik.protocol.https.Handler").newInstance();
            }
            catch (Exception ex) {
                throw new Exception("Could not create https handler:" + ex.getClass().getName() + " " + ex.getMessage());
            }
            url = new URL("https", tmpUrl.getHost(), tmpUrl.getPort(), tmpUrl.getFile(), httpsHandler);
        } else {
            url = new URL(endpoint);
        }
        if (url != null && url.getProtocol().toLowerCase().indexOf("https") != -1) {
            secure = true;
        }
        sock = !secure ? new HTTPSocket(url) : new HTTPSocket(url);
        sock.setRequestMethod(requestMethod);
        sock.setHeader("Connection", "close");
        Object inputLogger = this.config.getProperty(RESPONSE_LOGGING_PROPERTY);
        Object outputLogger = this.config.getProperty(REQUEST_LOGGING_PROPERTY);
        if (inputLogger != null || outputLogger != null) {
            OutputStream outputLog;
            OutputStream inputLog;
            try {
                inputLog = (OutputStream)inputLogger;
                outputLog = (OutputStream)outputLogger;
            }
            catch (ClassCastException cce) {
                throw new Exception("OutputStream expected for REQUEST_LOGGING_PROPERTY and RESPONSE_LOGGING_PROPERTY: " + cce.toString());
            }
            sock.setLogger(inputLog, outputLog);
        }
        if (this.featureSet("http://www.sap.com/webas/630/soap/features/timeout/") && (timeOut = (String)(feature = this.getFeature("http://www.sap.com/webas/630/soap/features/timeout/")).getProperty("timeout")) != null) {
            try {
                int realTimeout = Integer.parseInt(timeOut);
                sock.setSocketTimeout(realTimeout);
            }
            catch (NumberFormatException x) {
                sock.setSocketTimeout(60000);
            }
        }
        return sock;
    }

    private static String encodeAuth(String userName, String password) {
        byte[] result = BASE64Encoder.encode((byte[])(userName + ":" + password).getBytes());
        return new String(result, 0, result.length);
    }

    private void copyClientCertificates(PropertyContext config, HTTPSocket socket) {
        PropertyContext feature;
        String authenticationMethod;
        if (config.getSubContext("http://www.sap.com/webas/630/soap/features/authentication") != null) {
            PropertyContext authenticationContext = config.getSubContext("http://www.sap.com/webas/630/soap/features/authentication");
            authenticationMethod = (String)authenticationContext.getProperty("AuthenticationMethod");
            if ("CertAuth".equals(authenticationMethod)) {
                // empty if block
            }
            List clientCertificateList = (List)authenticationContext.getProperty("clientCertificateList");
            this.httpSocket.setClientCertificateList(clientCertificateList);
            Boolean ignoreServerCerts = (Boolean)authenticationContext.getProperty("ignoreSSLServerCertificates");
            if (ignoreServerCerts != null) {
                this.httpSocket.setIgnoreServerCertificates(ignoreServerCerts);
                if (!ignoreServerCerts.booleanValue()) {
                    List serverCertificateList = (List)authenticationContext.getProperty("serverCertificateList");
                    this.httpSocket.setServerCertificateList(serverCertificateList);
                }
            }
        }
        if (this.featureSet("http://www.sap.com/webas/630/soap/features/authentication") && "BasicAuth".equals(authenticationMethod = (String)(feature = this.getFeature("http://www.sap.com/webas/630/soap/features/authentication")).getProperty("AuthenticationMethod"))) {
            String userName = (String)feature.getProperty("AuthenticationCredentialUser");
            String password = (String)feature.getProperty("AuthenticationCredentialPassword");
            if (userName != null) {
                this.httpSocket.setHeader("Authorization", "Basic " + HTTPTransport.encodeAuth(userName, password));
            }
        }
    }

    public OutputStream getRequestStream() throws Exception {
        String sessionMethod;
        PropertyContext feature;
        String proxyHost;
        this.copyClientCertificates(this.config, this.httpSocket);
        boolean preconfiguredProxy = false;
        if (this.featureSet("http://www.sap.com/webas/630/soap/features/proxy") && (proxyHost = (String)(feature = this.getFeature("http://www.sap.com/webas/630/soap/features/proxy")).getProperty("proxyHost")) != null) {
            int port;
            String proxyPort = (String)feature.getProperty("proxyPort");
            if (proxyPort == null) {
                throw new Exception("ProxyHost found, but proxyPort is null");
            }
            try {
                port = Integer.parseInt(proxyPort);
            }
            catch (Exception e) {
                throw new Exception("Transport configuration exception: " + e);
            }
            String proxyUser = (String)feature.getProperty("proxyUser");
            String proxyPass = (String)feature.getProperty("proxyPassword");
            this.httpSocket.setProxy(proxyHost, port, proxyUser, proxyPass);
            preconfiguredProxy = true;
        }
        if (!preconfiguredProxy) {
            HTTPProxyResolver proxyResolver = (HTTPProxyResolver)this.config.getProperty(HTTP_PROXY_RESOLVER_PROPERTY);
            this.httpSocket.setHTTPProxyResolver(proxyResolver);
        }
        if (this.featureSet("http://www.sap.com/webas/630/soap/features/session/") && "httpCookies".equals(sessionMethod = (String)(feature = this.getFeature("http://www.sap.com/webas/630/soap/features/session/")).getProperty("SessionMethod"))) {
            Object cookieObject;
            boolean maintainSession = true;
            if ("no".equals(feature.getProperty("maintainSession"))) {
                maintainSession = false;
                feature.setProperty("maintainSession", "yes");
            }
            if ((cookieObject = feature.getProperty("SessionCoockie")) != null) {
                ArrayList cookies = (ArrayList)cookieObject;
                int i = 0;
                while (i < cookies.size()) {
                    String line = Cookie.getAsRequestString((Cookie)cookies.get(i));
                    this.httpSocket.setHeader("Cookie", line);
                    ++i;
                }
                if (!maintainSession) {
                    feature.clearProperty("SessionCoockie");
                    this.httpSocket.setHeader("maintainSession", "no");
                }
            }
        }
        Enumeration headerkeys = this.headers.keys();
        while (headerkeys.hasMoreElements()) {
            String headerName = (String)headerkeys.nextElement();
            String[] headerValue = (String[])this.headers.get(headerName);
            int i = 0;
            while (i < headerValue.length) {
                this.httpSocket.setHeader(headerName, headerValue[i]);
                ++i;
            }
        }
        return this.httpSocket.getOutputStream();
    }

    public int getResponseCode() throws Exception {
        return this.httpSocket.getResponseCode();
    }

    private String analyzeCookie(String cookie) {
        StringTokenizer tokenizer = new StringTokenizer(cookie, ";", false);
        StringBuffer currentCookie = new StringBuffer();
        StringBuffer result = new StringBuffer();
        StringBuffer domain = new StringBuffer();
        StringBuffer path = new StringBuffer();
        String version = "";
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken().trim();
            if ("Secure".equals(token) || token.startsWith("Max-Age=") || token.startsWith("Comment=")) continue;
            if (token.startsWith("Domain=")) {
                domain.setLength(0);
                domain.append("; $");
                domain.append(token);
                continue;
            }
            if (token.startsWith("Path=")) {
                path.setLength(0);
                path.append("; $");
                path.append(token);
                continue;
            }
            if (token.startsWith("Version=")) {
                version = "$" + token + "; ";
                continue;
            }
            if ("Discard".equals(token) || token.length() == 0) continue;
            if (currentCookie.length() == 0) {
                currentCookie.append(token);
                continue;
            }
            if (result.length() != 0) {
                result.append("; ");
            }
            result.append((Object)currentCookie);
            result.append((Object)path);
            result.append((Object)domain);
            currentCookie.setLength(0);
            path.setLength(0);
            domain.setLength(0);
            currentCookie.append(token);
        }
        if (currentCookie.length() != 0) {
            if (result.length() != 0) {
                result.append("; ");
            }
            result.append((Object)currentCookie);
            result.append((Object)path);
            result.append((Object)domain);
        }
        if (result.length() != 0) {
            return version + result.toString();
        }
        return "";
    }

    public InputStream getResponseStream() throws IOException {
        PropertyContext feature;
        String sessionMethod;
        this.headers.clear();
        Enumeration answerheaders = this.httpSocket.getHeaderNames();
        while (answerheaders.hasMoreElements()) {
            String headerName = (String)answerheaders.nextElement();
            String[] headerValue = this.httpSocket.getHeader(headerName);
            this.headers.put(headerName, headerValue);
        }
        if (this.featureSet("http://www.sap.com/webas/630/soap/features/session/") && "httpCookies".equals(sessionMethod = (String)(feature = this.getFeature("http://www.sap.com/webas/630/soap/features/session/")).getProperty("SessionMethod"))) {
            String[] cookies;
            boolean maintainSession = true;
            if ("no".equals(feature.getProperty("maintainSession"))) {
                maintainSession = false;
                feature.setProperty("maintainSession", "yes");
            }
            if ((cookies = this.httpSocket.getHeader("Set-Cookie")) != null && cookies.length > 0) {
                ArrayList content = feature.getProperty("SessionCoockie");
                int i = 0;
                while (i < cookies.length) {
                    if (cookies[i].indexOf("sap-contextid=") != -1) {
                        int pos = cookies[i].indexOf("sap-contextid=");
                        if (cookies[i].indexOf(";", pos) != -1) {
                            if ("sap-contextid=0".equals(content)) {
                                content = null;
                                break;
                            }
                        } else if ("sap-contextid=0".equals(content)) {
                            content = null;
                            break;
                        }
                    }
                    ArrayList cookieLine = Cookie.readCookies(cookies[i]);
                    int j = 0;
                    while (j < cookieLine.size()) {
                        if (content == null) {
                            content = new ArrayList();
                        }
                        Cookie.updateCookies(cookieLine, content);
                        ++j;
                    }
                    ++i;
                }
                if (maintainSession && content != null) {
                    feature.setProperty("SessionCoockie", content);
                }
            }
        }
        return this.httpSocket.getInputStream();
    }

    public void closeSession() throws Exception {
        this.httpSocket.disconnect();
    }

    public boolean featureSet(String featureName) {
        PropertyContext context = this.getFeature(featureName);
        return context.isDefined();
    }

    public String[] getHeader(String headerName) {
        return (String[])this.headers.get(headerName);
    }

    public Hashtable getHeaders() {
        return this.headers;
    }

    public Enumeration listHeaders() {
        return this.headers.keys();
    }

    public void setHeader(String headerName, String[] headerValues) {
        this.headers.put(headerName, headerValues);
    }

    public void setHeader(String headerName, String headerValue) {
        this.headers.put(headerName, new String[]{headerValue});
    }

    public String getContentType() throws Exception {
        return this.httpSocket.getContentType();
    }

    public String getResponseMessaget() throws Exception {
        return this.httpSocket.getResponseMessage();
    }
}

