/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.wsdl2java.soapbinding;

import com.sap.engine.services.webservices.jaxrpc.wsdl2java.AbstractMessage;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.soapbinding.ClientSOAPMessage;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.soapbinding.ContentTypeImpl;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.soapbinding.HTTPTransport;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;

public class ClientMimeMessage
extends AbstractMessage {
    private static final String CONTENT_TYPE = "content-type";
    private static final String TEXTXML_TYPE = "text/xml";
    private static final String PRIMARY_TYPE = "multipart";
    private static final String SUB_TYPE = "related";
    private static final String START_PARAMETER = "start";
    private static final String CID = "cid:";
    private MimeMultipart mimeMessage;
    private ClientSOAPMessage soapMessage = new ClientSOAPMessage();
    private Hashtable cidMappings = new Hashtable();
    private Hashtable clMappings = new Hashtable();

    public void initDeserializationMode(final HTTPTransport transport) throws Exception {
        block13: {
            BodyPart rootPart = null;
            String ctHeader = transport.getContentType();
            try {
                if (ctHeader == null) {
                    InputStream input = transport.getResponseStream();
                    byte[] barr = new byte[1000];
                    int count = input.read(barr);
                    String perm = "";
                    if (count > 0) {
                        perm = new String(barr, 0, count);
                    }
                    throw new Exception("Incorrect http message! No content-type header is found. Mesasge DUMP [" + perm + "]");
                }
                final ContentTypeImpl contentType = new ContentTypeImpl(ctHeader);
                if (contentType.getPrimaryType().equalsIgnoreCase(PRIMARY_TYPE) && contentType.getSubType().equalsIgnoreCase(SUB_TYPE)) {
                    ContentTypeImpl partCt;
                    this.mimeMessage = new MimeMultipart(new DataSource(){

                        public InputStream getInputStream() throws IOException {
                            return transport.getResponseStream();
                        }

                        public OutputStream getOutputStream() throws IOException {
                            return null;
                        }

                        public String getContentType() {
                            return contentType.createStandardType().toString();
                        }

                        public String getName() {
                            return "";
                        }
                    });
                    String stpValue = contentType.getParameter(START_PARAMETER);
                    if (stpValue != null) {
                        rootPart = this.mimeMessage.getBodyPart(stpValue);
                        if (rootPart == null) {
                            throw new Exception("Could not find bodypart with cid: '" + stpValue + "'");
                        }
                    } else if (this.mimeMessage.getCount() > 0) {
                        rootPart = this.mimeMessage.getBodyPart(0);
                    } else {
                        throw new Exception("Incorrect mime message!");
                    }
                    if (!(partCt = new ContentTypeImpl(rootPart.getContentType())).getBaseType().equalsIgnoreCase(TEXTXML_TYPE)) {
                        throw new Exception("Incorrect root part content-type: '" + rootPart.getContentType() + "'");
                    }
                    this.loadMappingTables(rootPart);
                    this.soapMessage.initDeserializationMode(rootPart.getInputStream());
                    break block13;
                }
                if (contentType.getPrimaryType().equalsIgnoreCase("text") && contentType.getSubType().equalsIgnoreCase("xml")) {
                    this.soapMessage.initDeserializationMode(transport.getResponseStream());
                    break block13;
                }
                throw new Exception("Incorrect content-type found '" + contentType.toString() + "'");
            }
            catch (Exception e) {
                if (e instanceof Exception) {
                    throw e;
                }
                throw new Exception(e.getMessage());
            }
        }
    }

    public MimeMultipart initSerializationMode() {
        this.soapMessage.initSerializationMode();
        this.mimeMessage = new MimeMultipart(SUB_TYPE);
        return this.mimeMessage;
    }

    public MimeMultipart getMultiPartObject() {
        return this.mimeMessage;
    }

    public ClientSOAPMessage getSOAPMessage() {
        return this.soapMessage;
    }

    public BodyPart getPart(String hrefValue) {
        if (hrefValue.startsWith(CID)) {
            return (BodyPart)this.cidMappings.get(hrefValue.substring(CID.length()));
        }
        return (BodyPart)this.clMappings.get(hrefValue);
    }

    private void loadMappingTables(BodyPart rootPart) throws Exception {
        try {
            int parts = this.mimeMessage.getCount();
            int i = 0;
            while (i < parts) {
                BodyPart tPart = this.mimeMessage.getBodyPart(i);
                if (rootPart != tPart) {
                    String cidh = this.getSingleHeaderValue("Content-ID", tPart);
                    String clh = this.getSingleHeaderValue("Content-Location", tPart);
                    if (cidh != null) {
                        cidh = cidh.substring(1, cidh.length() - 1);
                        this.cidMappings.put(cidh, tPart);
                    } else if (clh != null) {
                        this.clMappings.put(clh, tPart);
                    } else {
                        throw new Exception("Could not extract either Content-ID nor Content-Location header values.");
                    }
                }
                ++i;
            }
        }
        catch (MessagingException e) {
            throw new Exception(e.getMessage());
        }
    }

    private String getSingleHeaderValue(String headerName, BodyPart part) throws MessagingException {
        String[] headers = part.getHeader(headerName);
        if (headers == null) {
            return null;
        }
        if (headers.length != 1) {
            return null;
        }
        return headers[0];
    }

    public void writeTo(OutputStream outputStream) throws Exception {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            this.soapMessage.writeTo(buffer);
            InternetHeaders headers = new InternetHeaders();
            headers.addHeader("Content-type", TEXTXML_TYPE);
            MimeBodyPart rootPart = new MimeBodyPart(headers, buffer.toByteArray());
            this.mimeMessage.addBodyPart((BodyPart)rootPart, 0);
            this.mimeMessage.writeTo(outputStream);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }
}

