/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.wsdl2java.httpgetpost;

import com.sap.engine.lib.xml.parser.URLLoaderBase;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenReader;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenReaderImpl;
import com.sap.engine.services.webservices.jaxrpc.encoding.DeserializerBase;
import com.sap.engine.services.webservices.jaxrpc.encoding.SOAPDeserializationContext;
import com.sap.engine.services.webservices.jaxrpc.encoding.SOAPSerializationContext;
import com.sap.engine.services.webservices.jaxrpc.encoding.SerializerBase;
import com.sap.engine.services.webservices.jaxrpc.encoding.TypeMappingImpl;
import com.sap.engine.services.webservices.jaxrpc.util.CodeGenerator;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.AbstractProtocol;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ClientTransportBinding;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.PropertyContext;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ProtocolList;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ServiceParam;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.features.DefaultProviders;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.httpgetpost.URLEncoder;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.FeatureType;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.GlobalFeatures;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LocalFeatures;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.PropertyType;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.soapbinding.HTTPTransport;
import com.sap.engine.services.webservices.wsdl.WSDLBinding;
import com.sap.engine.services.webservices.wsdl.WSDLBindingChannel;
import com.sap.engine.services.webservices.wsdl.WSDLBindingOperation;
import com.sap.engine.services.webservices.wsdl.WSDLChannel;
import com.sap.engine.services.webservices.wsdl.WSDLDefinitions;
import com.sap.engine.services.webservices.wsdl.WSDLException;
import com.sap.engine.services.webservices.wsdl.WSDLExtension;
import com.sap.engine.services.webservices.wsdl.WSDLMessage;
import com.sap.engine.services.webservices.wsdl.WSDLOperation;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.SerializerFactory;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.rpc.encoding.TypeMappingRegistry;

public class HttpGetPostBinding
implements ClientTransportBinding {
    public static final String HTTP_BINDING_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/http/";
    public static final String HTTP_GET_POST_BINDING = "HTTP Get/Post Transport binding";
    public static final String[] SUPPORTED_FEATURES = new String[]{"http://www.sap.com/webas/630/soap/features/authentication", "http://www.sap.com/webas/630/soap/features/proxy"};
    public static final String VERB = "verb";
    public static final String VERB_GET = "GET";
    public static final String VERB_POST = "POST";
    public static final String LOCATION = "location";
    public static final String REQUESTMETHOD = "requestMethod";
    public static final String URLENCODED = "urlEncoded";
    public static final String URLREPLACEMENT = "urlReplacement";
    public static final String MIME_CONTENT = "content";
    public static final String MIME_TYPE = "application/x-www-form-urlencoded";
    public static final String MIME_BINDING_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/mime/";
    public static final String MIME_XML = "mimeXml";
    public static String CONTENT_TYPE_HEADER = "Content-Type";
    public static String CONTENT_LENGTH_HEADER = "Content-Length";
    private TypeMappingRegistry registry;
    private SOAPSerializationContext serializationContext = new SOAPSerializationContext();
    private SOAPDeserializationContext deserializationContext = new SOAPDeserializationContext();
    private XMLTokenReaderImpl parser = new XMLTokenReaderImpl();
    private ServiceParam[] inputParams;
    private ServiceParam[] outputParams;
    private ServiceParam[] faultParams;
    private HTTPTransport transport = new HTTPTransport();

    public boolean isFeatureImplemented(String featureName, PropertyContext property) {
        if ("http://www.sap.com/webas/630/soap/features/proxy".equals(featureName)) {
            return true;
        }
        return "http://www.sap.com/webas/630/soap/features/authentication".equals(featureName);
    }

    public String getName() {
        return HTTP_GET_POST_BINDING;
    }

    public String[] getFeatures() {
        return SUPPORTED_FEATURES;
    }

    public boolean recognizeBinding(WSDLBinding bindingElement) {
        ArrayList extensions = bindingElement.getExtensions();
        if (extensions.size() == 0) {
            return false;
        }
        WSDLExtension extension = (WSDLExtension)extensions.get(0);
        return extension.getLocalName().equals("binding") && HTTP_BINDING_NAMESPACE.equals(extension.getURI());
    }

    public void getMainBindingConfig(WSDLBinding binding, PropertyContext context) throws WSDLException {
        ArrayList extensions = binding.getExtensions();
        if (extensions.size() == 1) {
            WSDLExtension extensionElement = (WSDLExtension)extensions.get(0);
            String verb = extensionElement.getAttribute(VERB);
            if (verb == null) {
                verb = VERB_POST;
            }
            context.setProperty(VERB, verb);
        }
    }

    public String loadAddress(WSDLExtension extension) throws WSDLException {
        if (HTTP_BINDING_NAMESPACE.equals(extension.getURI()) && extension.getLocalName().equals("address")) {
            String location = extension.getAttribute(LOCATION);
            if (location == null) {
                throw new WSDLException(" Location not specified in http:address");
            }
            return location;
        }
        throw new WSDLException(" The port HTTP Extension is invalid ");
    }

    public void getOperationBindingConfig(WSDLBindingOperation obinding, WSDLOperation operation, PropertyContext context, WSDLDefinitions definitions) throws WSDLException {
        WSDLBindingChannel outputBinding;
        ArrayList operationBinding = obinding.getExtensions();
        if (operationBinding.size() == 0) {
            throw new WSDLException("http:operation tag is mandatory in http binding !");
        }
        WSDLExtension extension = (WSDLExtension)operationBinding.get(0);
        if (HTTP_BINDING_NAMESPACE.equals(extension.getURI()) && extension.getLocalName().equals("operation")) {
            String location = extension.getAttribute(LOCATION);
            if (location == null) {
                throw new WSDLException(" Location not specified in http:operation");
            }
            context.setProperty(LOCATION, location);
        }
        WSDLBindingChannel inputBinding = obinding.getInput();
        PropertyContext inputContext = context.getSubContext("input");
        ArrayList extensions = inputBinding.getExtensions();
        if (extensions.size() == 1) {
            WSDLExtension extension2 = (WSDLExtension)extensions.get(0);
            if (extension2.getLocalName().equals(URLENCODED) && HTTP_BINDING_NAMESPACE.equals(extension2.getURI())) {
                inputContext.setProperty(REQUESTMETHOD, URLENCODED);
            }
            if (extension2.getLocalName().equals(URLREPLACEMENT) && HTTP_BINDING_NAMESPACE.equals(extension2.getURI())) {
                inputContext.setProperty(REQUESTMETHOD, URLREPLACEMENT);
            }
            if (extension2.getLocalName().equals(MIME_CONTENT) && MIME_BINDING_NAMESPACE.equals(extension2.getURI())) {
                String type = extension2.getAttribute("type");
                if (type == null) {
                    throw new WSDLException("mime:content with no type specified found !");
                }
                if (type.equals(MIME_TYPE)) {
                    inputContext.setProperty(REQUESTMETHOD, MIME_TYPE);
                } else {
                    throw new WSDLException("only application/x-www-form-urlencoded is possible as http binding request content type !");
                }
            }
        }
        if ((outputBinding = obinding.getOutput()) != null) {
            PropertyContext outputContext = context.getSubContext("output");
            extensions = outputBinding.getExtensions();
            int i = 0;
            while (i < extensions.size()) {
                WSDLExtension extension3 = (WSDLExtension)extensions.get(i);
                if (extension3.getLocalName().equals(MIME_XML) && MIME_BINDING_NAMESPACE.equals(extension3.getURI())) {
                    String part = extension3.getAttribute("part");
                    if (part == null) {
                        WSDLChannel channel = operation.getOutput();
                        if (channel == null) {
                            throw new WSDLException("There is no output in binded prortType operation " + operation.getName());
                        }
                        com.sap.engine.lib.xml.util.QName messageName = channel.getMessage();
                        WSDLMessage message = definitions.getMessage(messageName.getLocalName(), messageName.getURI());
                        if (message == null) {
                            throw new WSDLException("There is no message named " + messageName.getLocalName());
                        }
                        if (message.getPartCount() == 1) {
                            part = message.getPart(0).getName();
                        }
                    }
                    if (part != null) {
                        outputContext.setProperty(part, "text/xml");
                    }
                }
                ++i;
            }
        }
    }

    private void makeHttpRequest(String endpoint, ServiceParam[] inputParams, PropertyContext operationContext, PropertyContext context, HTTPTransport transport, String verb, ProtocolList globalProtocols, ProtocolList localProtocols) throws Exception {
        String finalEndpoint;
        PropertyContext featureContext = context.getSubContext("featureConfig");
        String location = (String)operationContext.getProperty(LOCATION);
        if (location == null) {
            throw new Exception("Ivalid binding configuration. Operation locaion tag must be specified !");
        }
        URL baseAddress = URLLoaderBase.fileOrURLToURL(null, (String)endpoint);
        PropertyContext inputContext = operationContext.getSubContext("input");
        String requestMethod = (String)inputContext.getProperty(REQUESTMETHOD);
        if (requestMethod == null) {
            throw new Exception("Invalid binding confifuration. Operation request method must be ser !");
        }
        if (requestMethod.equals(URLENCODED)) {
            finalEndpoint = baseAddress.toString() + location;
            transport.init(finalEndpoint + '?' + this.getEncodedForm(inputParams), verb, featureContext);
            globalProtocols.handleRequest(null, context);
            localProtocols.handleRequest(null, context);
            transport.getRequestStream().flush();
        }
        if (requestMethod.equals(URLREPLACEMENT)) {
            String replacedVariant = this.getReplacementForm(location, inputParams);
            String finalEndpoint2 = baseAddress + replacedVariant;
            transport.init(finalEndpoint2, verb, featureContext);
            globalProtocols.handleRequest(null, context);
            localProtocols.handleRequest(null, context);
            transport.getRequestStream().flush();
        }
        if (requestMethod.equals(MIME_TYPE)) {
            finalEndpoint = baseAddress.toString() + location;
            String content = this.getEncodedForm(inputParams);
            transport.init(finalEndpoint, verb, featureContext);
            transport.setHeader(CONTENT_LENGTH_HEADER, String.valueOf(content.length()));
            transport.setHeader(CONTENT_TYPE_HEADER, MIME_TYPE);
            globalProtocols.handleRequest(null, context);
            localProtocols.handleRequest(null, context);
            OutputStream output = transport.getRequestStream();
            output.write(content.getBytes());
            output.flush();
        }
    }

    private XMLTokenReader getOutputReader(HTTPTransport transport) throws Exception {
        InputStream inputStream = transport.getResponseStream();
        this.parser.init(inputStream);
        this.parser.begin();
        this.parser.moveToNextElementStart();
        return this.parser;
    }

    private void decodeResponse(ServiceParam[] outputParams, PropertyContext operationContext, HTTPTransport transport, ProtocolList globalProtocols, ProtocolList localProtocols, PropertyContext context) throws Exception {
        TypeMappingImpl typeMapping = (TypeMappingImpl)this.registry.getDefaultTypeMapping();
        this.deserializationContext.clearContext();
        this.deserializationContext.setTypeMapping(typeMapping);
        PropertyContext outputContext = operationContext.getSubContext("output");
        Enumeration enumeration = outputContext.getProperyKeys();
        boolean flag = false;
        if (enumeration.hasMoreElements()) {
            String partName = (String)enumeration.nextElement();
            String partType = (String)outputContext.getProperty(partName);
            int i = 0;
            while (i < outputParams.length) {
                if (outputParams[i].name.equals(partName)) {
                    if (!outputParams[i].isElement) {
                        throw new Exception("Binded http response part must be element !");
                    }
                    String contentType = transport.getContentType();
                    if (contentType == null) {
                        throw new Exception("No content type specified !");
                    }
                    if (contentType.indexOf(partType) == -1) {
                        throw new Exception("Content type should be " + partType + " but found " + contentType);
                    }
                    XMLTokenReader reader = this.getOutputReader(transport);
                    QName elementType = typeMapping.getTypeForElement(outputParams[i].schemaName);
                    DeserializerFactory factory = typeMapping.getDeserializer(outputParams[i].contentClass, elementType);
                    DeserializerBase deserializer = (DeserializerBase)factory.getDeserializerAs("");
                    outputParams[i].content = deserializer.deserialize(reader, this.deserializationContext, outputParams[i].contentClass);
                }
                ++i;
            }
            flag = true;
        }
        globalProtocols.handleResponse(null, context);
        localProtocols.handleResponse(null, context);
        transport.closeSession();
    }

    public void startOperation(ServiceParam[] inputParams, ServiceParam[] outputParams, ServiceParam[] faultParams) {
        this.inputParams = inputParams;
        this.outputParams = outputParams;
        this.faultParams = faultParams;
    }

    public void call(PropertyContext context, ProtocolList globalProtocols, ProtocolList localProtocols) throws Exception {
        PropertyContext configContext = context.getSubContext("bindingConfig");
        if (!configContext.isDefined()) {
            throw new Exception(" No binding configuration provided in context !");
        }
        String endpoint = (String)configContext.getProperty("endpointUrl");
        if (endpoint == null) {
            throw new Exception(" Endpoint not specified in binding context !");
        }
        String verb = (String)configContext.getProperty(VERB);
        if (verb == null) {
            throw new Exception("Ivalid binding configuration ! HTTP binding verb not set !");
        }
        context.setProperty("transportInterface", this.transport);
        this.makeHttpRequest(endpoint, this.inputParams, configContext, context, this.transport, verb, globalProtocols, localProtocols);
        int responseCode = this.transport.getResponseCode();
        if (responseCode == 200) {
            this.decodeResponse(this.outputParams, configContext, this.transport, globalProtocols, localProtocols, context);
            return;
        }
        if (responseCode == 500) {
            throw new Exception("Internal Server Error !");
        }
        throw new Exception("Transport Error ! Response code (" + responseCode + ") " + this.transport.getResponseMessaget());
    }

    public ServiceParam[] getResponseParts() {
        return new ServiceParam[0];
    }

    public ServiceParam[] getFaultParts() {
        return new ServiceParam[0];
    }

    public void setTypeMappingRegistry(TypeMappingRegistry registry) {
        this.registry = registry;
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        return this.registry;
    }

    public boolean isCompatible(AbstractProtocol protocol) {
        return false;
    }

    public void generateCustom(String packageName, File outputDir, WSDLDefinitions definitions, PropertyContext context, WSDLOperation operation) {
    }

    public void addImport(CodeGenerator generator) {
    }

    public void addConstructorCode(CodeGenerator generator) {
    }

    public void addVariables(CodeGenerator generator) {
    }

    private String getReplacementForm(String locationUrl, ServiceParam[] parts) throws Exception {
        TypeMapping typeMapping = this.registry.getDefaultTypeMapping();
        this.serializationContext.clearContext();
        StringBuffer result = new StringBuffer();
        boolean flag = false;
        int i = 0;
        while (i < locationUrl.length()) {
            flag = true;
            int j = 0;
            while (j < parts.length) {
                if (locationUrl.startsWith('(' + parts[j].name + ')', i)) {
                    SerializerFactory factory = typeMapping.getSerializer(parts[i].contentClass, parts[i].schemaName);
                    SerializerBase serializer = (SerializerBase)factory.getSerializerAs(null);
                    String value = serializer.serialize(parts[i].content, this.serializationContext);
                    if (value == null) {
                        value = "";
                    }
                    result.append(URLEncoder.encode(value));
                    flag = false;
                    i += parts[j].name.length() + 1;
                    break;
                }
                ++j;
            }
            if (flag) {
                result.append(locationUrl.charAt(i));
            }
            ++i;
        }
        return result.toString();
    }

    private String getEncodedForm(ServiceParam[] parts) throws Exception {
        TypeMapping typeMapping = this.registry.getDefaultTypeMapping();
        this.serializationContext.clearContext();
        StringBuffer result = new StringBuffer();
        boolean firstFlag = false;
        int i = 0;
        while (i < parts.length) {
            SerializerFactory factory = typeMapping.getSerializer(parts[i].contentClass, parts[i].schemaName);
            SerializerBase serializer = (SerializerBase)factory.getSerializerAs(null);
            String value = serializer.serialize(parts[i].content, this.serializationContext);
            if (value != null) {
                if (firstFlag) {
                    result.append('&');
                }
                result.append(URLEncoder.encode(parts[i].name));
                result.append('=');
                result.append(URLEncoder.encode(value));
                firstFlag = true;
            }
            ++i;
        }
        return result.toString();
    }

    public void flush(PropertyContext context, ProtocolList globalProtocols) throws Exception {
    }

    public GlobalFeatures importGlobalFeatures(GlobalFeatures globalFeatures, WSDLBinding binding) {
        if (globalFeatures.getFeature("http://www.sap.com/webas/630/soap/features/authentication") == null) {
            FeatureType securityFeature = new FeatureType();
            securityFeature.setName("http://www.sap.com/webas/630/soap/features/authentication");
            String provider = DefaultProviders.getProvider(securityFeature.getName());
            if (provider != null) {
                securityFeature.setProvider(provider);
            }
            securityFeature.setOriginal(false);
            PropertyType property = new PropertyType();
            property.setName("AuthenticationMechanism");
            property.setValue("None");
            securityFeature.addProperty(property);
            globalFeatures.addFeature(securityFeature);
        }
        return globalFeatures;
    }

    public LocalFeatures importLocalFeatures(LocalFeatures features, WSDLBindingOperation operation) {
        return features;
    }
}

