/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.wsdl2java;

import com.sap.engine.interfaces.webservices.runtime.HTTPProxy;
import com.sap.engine.interfaces.webservices.runtime.HTTPProxyResolver;
import com.sap.engine.services.webservices.wsdl.WSDLDOMLoader;
import com.sap.engine.services.webservices.wsdl.WSDLDefinitions;

public class SLDPort {
    private String wsdl;
    private String portName;

    public SLDPort(String wsdl, String portName) {
        this.wsdl = wsdl;
        this.portName = portName;
    }

    public String getPortName() {
        return this.portName;
    }

    public String getWsdl() {
        return this.wsdl;
    }

    public void setPortName(String string) {
        this.portName = string;
    }

    public void setWsdl(String string) {
        this.wsdl = string;
    }

    public WSDLDefinitions getAsDefinitions(HTTPProxyResolver proxyResolver) throws Exception {
        String proxyHost = null;
        int proxyPort = -1;
        if (this.wsdl.startsWith("http://") || this.wsdl.startsWith("https://")) {
            HTTPProxy proxy;
            String host;
            int schemaLength = this.wsdl.startsWith("http://") ? 7 : 8;
            int index = this.wsdl.indexOf("/", schemaLength);
            if (index == -1) {
                throw new Exception("Cannot determine host from WSDL: " + this.wsdl);
            }
            String hostPortPair = this.wsdl.substring(schemaLength, index);
            int colon = hostPortPair.indexOf(":");
            if (colon != -1) {
                host = hostPortPair.substring(0, colon);
                int port = Integer.parseInt(hostPortPair.substring(colon + 1));
            } else {
                host = hostPortPair;
                int port = 80;
            }
            if (host != null && (proxy = proxyResolver.getHTTPProxyForHost(host)) != null && proxy.useProxyForAddress(host)) {
                proxyHost = proxy.getProxyHost();
                proxyPort = proxy.getProxyPort();
            }
        }
        WSDLDOMLoader loader = new WSDLDOMLoader();
        if (proxyHost != null) {
            loader.setHttpProxy(proxyHost, "" + proxyPort);
        }
        return loader.loadWSDLDocument(this.wsdl);
    }
}

