/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.wsdl2java;

import com.sap.engine.interfaces.webservices.client.ClientFeatureProvider;
import com.sap.engine.interfaces.webservices.runtime.component.ClientComponentFactory;
import com.sap.engine.services.webservices.jaxrpc.util.NameConvertor;
import com.sap.engine.services.webservices.jaxrpc.util.PackageBuilder;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ClassGenerator;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ClientTransportBinding;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LogicalPortFactory;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LogicalPorts;
import com.sap.engine.services.webservices.wsdl.WSDLDOMLoader;
import com.sap.engine.services.webservices.wsdl.WSDLDefinitions;
import java.io.File;
import java.util.Hashtable;
import org.xml.sax.EntityResolver;

public class ProxyGeneratorServer {
    private PackageBuilder builder = new PackageBuilder();
    private String aditionalClassPath = null;
    private ClientComponentFactory factory;
    private Hashtable locationMap = null;
    private String additionalClasspath;

    public ProxyGeneratorServer(ClientComponentFactory factory) {
        this.factory = factory;
    }

    public void setLocationMap(Hashtable locationMap) {
        this.locationMap = locationMap;
    }

    public void setAdditionalClasspath(String additionalClasspath) {
        this.additionalClasspath = additionalClasspath;
    }

    public LogicalPorts generateProxy(File wsdlName, File outputDir, String outputPackage, boolean compile) throws Exception {
        if (!outputDir.isDirectory()) {
            throw new Exception(" Output directory name given is not a directory name !");
        }
        outputDir.mkdirs();
        if (wsdlName == null) {
            throw new Exception(" Incorrect WSDL name passed !");
        }
        WSDLDOMLoader loader = new WSDLDOMLoader();
        WSDLDefinitions definitions = null;
        definitions = this.locationMap != null ? loader.loadMirrorWSDLDocument(wsdlName.getAbsolutePath(), this.locationMap) : loader.loadWSDLDocument(wsdlName.getAbsolutePath());
        ClassGenerator generator = new ClassGenerator();
        if (outputPackage == null) {
            System.out.println(" * No output package specified. targetNamespace URI will be used.");
            NameConvertor convertor = new NameConvertor();
            outputPackage = convertor.uriToPackage(definitions.getTargetNamespace());
        }
        System.out.println(" * Output root package set to : " + outputPackage);
        ClientFeatureProvider[] tbindingsInterface = this.factory.listClientransportBindingInterfaces();
        ClientTransportBinding[] tbindings = new ClientTransportBinding[tbindingsInterface.length];
        int i = 0;
        while (i < tbindingsInterface.length) {
            tbindings[i] = (ClientTransportBinding)tbindingsInterface[i];
            ++i;
        }
        generator.init(definitions, outputDir, outputPackage, tbindings);
        LogicalPorts result = generator.generateStubs();
        if (this.aditionalClassPath != null) {
            this.builder.setAditionalClassPath(this.aditionalClassPath);
        } else {
            this.builder.setAditionalClassPath("");
        }
        this.builder.setPackageRoot(outputDir);
        this.builder.setPackageName(outputPackage);
        if (compile) {
            this.builder.compilePackage();
        }
        return result;
    }

    public LogicalPorts generateProxy(File wsdlName, File outputDir, String outputPackage, boolean compile, File logicalPorts) throws Exception {
        LogicalPortFactory plfactory = new LogicalPortFactory();
        LogicalPorts ports = plfactory.loadLogicalPorts(logicalPorts);
        return this.generateProxy(wsdlName, null, outputDir, outputPackage, compile, ports);
    }

    public LogicalPorts generateProxy(File wsdlName, EntityResolver wsdlResolver, File outputDir, String outputPackage, boolean compile, LogicalPorts ports) throws Exception {
        if (wsdlName == null) {
            throw new Exception(" Incorrect WSDL name passed !");
        }
        WSDLDOMLoader loader = new WSDLDOMLoader();
        if (wsdlResolver != null) {
            loader.setWSDLResolver(wsdlResolver);
        }
        WSDLDefinitions definitions = null;
        definitions = this.locationMap != null ? loader.loadMirrorWSDLDocument(wsdlName.getAbsolutePath(), this.locationMap) : loader.loadWSDLDocument(wsdlName.getAbsolutePath());
        return this.generateProxy(definitions, outputDir, outputPackage, compile, ports);
    }

    private LogicalPorts generateProxy(WSDLDefinitions definitions, File outputDir, String outputPackage, boolean compile, LogicalPorts ports) throws Exception {
        if (!outputDir.isDirectory()) {
            throw new Exception(" Output directory name given is not a directory name !");
        }
        outputDir.mkdirs();
        ClassGenerator generator = new ClassGenerator();
        if (outputPackage == null) {
            System.out.println(" * No output package specified. targetNamespace URI will be used.");
            NameConvertor convertor = new NameConvertor();
            outputPackage = convertor.uriToPackage(definitions.getTargetNamespace());
        }
        System.out.println(" * Output root package set to : " + outputPackage);
        ClientFeatureProvider[] tbindingsInterface = this.factory.listClientransportBindingInterfaces();
        ClientTransportBinding[] tbindings = new ClientTransportBinding[tbindingsInterface.length];
        int i = 0;
        while (i < tbindingsInterface.length) {
            tbindings[i] = (ClientTransportBinding)tbindingsInterface[i];
            ++i;
        }
        generator.init(definitions, outputDir, outputPackage, tbindings);
        LogicalPorts result = generator.generateStubs(ports);
        generator.generateServiceImpl(result, null, true);
        if (this.aditionalClassPath != null) {
            this.builder.setAditionalClassPath(this.aditionalClassPath);
        } else {
            this.builder.setAditionalClassPath("");
        }
        this.builder.setPackageRoot(outputDir);
        this.builder.setPackageName(outputPackage);
        if (compile) {
            this.builder.setAditionalClassPath(this.additionalClasspath);
            this.builder.compilePackage();
        }
        return result;
    }
}

