/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.wsdl2java;

import com.sap.engine.lib.schema.components.ComplexTypeDefinition;
import com.sap.engine.lib.schema.components.TypeDefinitionBase;
import com.sap.engine.services.webservices.jaxrpc.encoding.FieldInfo;
import com.sap.engine.services.webservices.jaxrpc.exceptions.ProxyGeneratorException;
import com.sap.engine.services.webservices.jaxrpc.schema2java.SchemaToJavaGenerator;
import com.sap.engine.services.webservices.jaxrpc.schema2java.SchemaToJavaGeneratorException;
import com.sap.engine.services.webservices.jaxrpc.util.CodeGenerator;
import com.sap.engine.services.webservices.jaxrpc.util.PackageBuilder;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.BeanHandler;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.GeneratorEnvironment;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.InterfaceHandler;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.OperationInterface;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.PortalHandler;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ServiceParam;
import com.sap.engine.services.webservices.wsdl.WSDLChannel;
import com.sap.engine.services.webservices.wsdl.WSDLDOMLoader;
import com.sap.engine.services.webservices.wsdl.WSDLDefinitions;
import com.sap.engine.services.webservices.wsdl.WSDLException;
import com.sap.engine.services.webservices.wsdl.WSDLFault;
import com.sap.engine.services.webservices.wsdl.WSDLMessage;
import com.sap.engine.services.webservices.wsdl.WSDLOperation;
import com.sap.engine.services.webservices.wsdl.WSDLPart;
import com.sap.engine.services.webservices.wsdl.WSDLPortType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.namespace.QName;

public class InterfaceGenerator {
    private InterfaceHandler ihandler = null;
    private ArrayList exceptionMessages = null;
    private Hashtable nullTable = null;
    private Properties uriToPackageMapping = null;
    private String typesSubpackage = "types";
    private Hashtable handlerRegistry = null;
    public static final String BEANS = "JAVA_BEANS";
    public static final String CLASSES = "JAVA_CLASSES";
    public static final String PORTALS = "PORTALS";
    public GeneratorEnvironment environment;
    private PackageBuilder builder = new PackageBuilder();
    private String httpProxyHost;
    private String httpProxyPort;

    public void setHTTPProxy(String proxyHost, String proxyPort) {
        this.httpProxyHost = proxyHost;
        this.httpProxyPort = proxyPort;
    }

    public void clearHTTPProxy() {
        this.httpProxyHost = null;
        this.httpProxyPort = null;
    }

    public InterfaceGenerator() {
        this.exceptionMessages = new ArrayList();
        this.nullTable = new Hashtable();
        this.nullTable.put("int", "0");
        this.nullTable.put("long", "0");
        this.nullTable.put("byte", "(byte) 0");
        this.nullTable.put("double", "0.0");
        this.nullTable.put("float", "0.0f");
        this.nullTable.put("boolean", "false");
        this.nullTable.put("short", "0");
        this.nullTable.put("float", "0.0f");
        this.handlerRegistry = new Hashtable();
        this.ihandler = new BeanHandler();
        this.handlerRegistry.put(BEANS, new BeanHandler());
        this.handlerRegistry.put(PORTALS, new PortalHandler());
        this.environment = new GeneratorEnvironment();
    }

    public String getNull(String type) {
        if (type == null) {
            return "";
        }
        String result = "null";
        if (this.nullTable.get(type) != null) {
            result = (String)this.nullTable.get(type);
        }
        return result;
    }

    public void init(WSDLDefinitions definitions, String outputDir, String outputPackage, InterfaceHandler handler, Properties uriToPackageMapping) throws ProxyGeneratorException {
        this.environment.definitions = definitions;
        try {
            this.environment.definitions.loadSchemaInfo();
        }
        catch (WSDLException e) {
            throw new ProxyGeneratorException("webservices_3205", (Throwable)((Object)e));
        }
        this.environment.schema = definitions.getSchemaInfo();
        this.environment.outputRootDir = new File(outputDir);
        this.environment.outputRootDir.mkdirs();
        this.environment.outputPackage = outputPackage;
        this.ihandler = handler;
        this.environment.clear();
        this.environment.iGenerator = this;
        this.exceptionMessages.clear();
        this.uriToPackageMapping = uriToPackageMapping;
    }

    public boolean isDocumentStyle(WSDLOperation operation) throws ProxyGeneratorException {
        WSDLChannel input = operation.getInput();
        WSDLChannel output = operation.getOutput();
        if (input == null || output == null) {
            return false;
        }
        WSDLMessage inputMessage = this.getMessage(input.getMessage(), operation.getName());
        WSDLMessage outputMessage = this.getMessage(output.getMessage(), operation.getName());
        if (inputMessage.getPartCount() != 1 || outputMessage.getPartCount() != 1) {
            return false;
        }
        WSDLPart ipart = inputMessage.getPart(0);
        WSDLPart opart = outputMessage.getPart(0);
        if (ipart.getStyle() == 2 || opart.getStyle() == 2) {
            return false;
        }
        TypeDefinitionBase itype = this.environment.schema.getElementType(ipart.getType().getURI(), ipart.getType().getLocalName());
        TypeDefinitionBase otype = this.environment.schema.getElementType(opart.getType().getURI(), opart.getType().getLocalName());
        if (this.environment.schema.isSimple(itype) || this.environment.schema.isSimple(otype)) {
            return false;
        }
        if (this.environment.schema.isDocumentArray((ComplexTypeDefinition)itype)) {
            return false;
        }
        if (this.environment.schema.isDocumentArray((ComplexTypeDefinition)otype)) {
            return false;
        }
        int ikind = this.environment.schema.getComplexTypeKind((ComplexTypeDefinition)itype);
        int okind = this.environment.schema.getComplexTypeKind((ComplexTypeDefinition)otype);
        if (!(ikind != 4 && ikind != 3 || okind != 4 && okind != 3)) {
            FieldInfo info;
            ArrayList inElements = this.environment.schema.getComplexFieldInfo((ComplexTypeDefinition)itype);
            ArrayList outElements = this.environment.schema.getComplexFieldInfo((ComplexTypeDefinition)otype);
            ArrayList outAttribs = this.environment.schema.getComplexAttributeInfo((ComplexTypeDefinition)otype);
            ArrayList inAttribs = this.environment.schema.getComplexAttributeInfo((ComplexTypeDefinition)itype);
            if (inAttribs.size() != 0) {
                return false;
            }
            if (outAttribs.size() != 0 || outElements.size() > 1) {
                return false;
            }
            int i = 0;
            while (i < inElements.size()) {
                info = (FieldInfo)inElements.get(i);
                if (info.getFieldModel() != 1) {
                    return false;
                }
                if (inElements.size() == 1 && itype.getName().equals(info.getTypeLocalName())) {
                    if (itype.getTargetNamespace() != null && itype.getTargetNamespace().equals(info.getTypeUri())) {
                        return false;
                    }
                    if (itype.getTargetNamespace() == info.getTypeUri()) {
                        return false;
                    }
                }
                ++i;
            }
            return outElements.size() == 0 || (info = (FieldInfo)outElements.get(0)).getFieldModel() == 1;
        }
        return false;
    }

    private void prepareSchema() throws ProxyGeneratorException {
        try {
            String typesPackage = this.typesSubpackage;
            if (this.environment.outputPackage != null && this.environment.outputPackage.length() != 0) {
                typesPackage = this.environment.outputPackage + "." + typesPackage;
            }
            if (this.environment.schema == null) {
                this.environment.schema = new SchemaToJavaGenerator();
                this.environment.schema.prepareAll(typesPackage);
            } else {
                this.environment.schema.setMirrorLocations(this.environment.definitions.getMirrorLocations());
                this.environment.schema.setMirrorMapping(this.environment.definitions.getMirrorMapping());
                this.environment.schema.setHttpProxy(this.httpProxyHost, this.httpProxyPort);
                if (!this.environment.schema.isLoaded() || this.uriToPackageMapping != null) {
                    if (this.uriToPackageMapping != null) {
                        this.environment.schema.setUriToPackagetMapping(this.uriToPackageMapping);
                    }
                    this.environment.schema.prepareAll(typesPackage);
                }
            }
            this.environment.javaToSchemaMapping = this.environment.schema.getJavaToSchemaMapping();
        }
        catch (SchemaToJavaGeneratorException e) {
            throw new ProxyGeneratorException("webservices_3205", (Throwable)((Object)e));
        }
    }

    private void generateSchema() throws ProxyGeneratorException {
        try {
            String typesPackage = this.typesSubpackage;
            if (this.environment.outputPackage != null && this.environment.outputPackage.length() != 0) {
                typesPackage = this.environment.outputPackage + "." + typesPackage;
            }
            if (this.environment.schema == null) {
                this.environment.schema = new SchemaToJavaGenerator();
                this.environment.schema.prepareAll(typesPackage);
            } else {
                this.environment.schema.setMirrorLocations(this.environment.definitions.getMirrorLocations());
                this.environment.schema.setMirrorMapping(this.environment.definitions.getMirrorMapping());
                this.environment.schema.setHttpProxy(this.httpProxyHost, this.httpProxyPort);
                if (this.uriToPackageMapping != null) {
                    this.environment.schema.setUriToPackagetMapping(this.uriToPackageMapping);
                }
                this.environment.schema.setContainerMode(true);
                this.environment.schema.generateAll(this.environment.outputRootDir, typesPackage);
                File[] filesArr = this.environment.schema.getFileList();
                int i = 0;
                while (i < filesArr.length) {
                    this.environment.outputFiles.add(filesArr[i]);
                    ++i;
                }
            }
            this.environment.javaToSchemaMapping = this.environment.schema.getJavaToSchemaMapping();
        }
        catch (SchemaToJavaGeneratorException e) {
            throw new ProxyGeneratorException("webservices_3205", (Throwable)((Object)e));
        }
    }

    private File getNewJavaFile(File baseDir, String packageName, String className) throws ProxyGeneratorException {
        if (packageName != null && packageName.length() != 0) {
            className = packageName + "." + className;
        }
        return this.getNewJavaFile(baseDir, className);
    }

    private File getNewJavaFile(File baseDir, String className) throws ProxyGeneratorException {
        File f = new File(baseDir, className.replace('.', File.separatorChar) + ".java");
        try {
            File fParent = f.getParentFile();
            if (!fParent.exists()) {
                fParent.mkdirs();
            }
            f.createNewFile();
        }
        catch (IOException e) {
            throw new ProxyGeneratorException("webservices_3207", e, f.getAbsolutePath());
        }
        this.environment.outputFiles.add(f);
        return f;
    }

    private String getExceptionClassName(WSDLMessage message, boolean packageSet) throws ProxyGeneratorException {
        if (message.getPartCount() == 1) {
            WSDLPart part = message.getPart(0);
            TypeDefinitionBase type = this.getPartType(part);
            String result = message.getName();
            if (!(this.environment.schema.isSimple(type) || this.environment.schema.isSoapArray(type) || (result = type.getName()) != null && result.length() != 0)) {
                result = part.getType().getLocalName() + "Exception";
            }
            result = this.environment.convertor.attributeToClassName(result);
            if (this.environment.outputPackage != null && this.environment.outputPackage.length() != 0 && packageSet) {
                result = this.environment.outputPackage + "." + result;
            }
            return result;
        }
        throw new ProxyGeneratorException("webservices_3211", message.getQName().toString());
    }

    private void writePackage(CodeGenerator generator) {
        if (this.environment.outputPackage != null && this.environment.outputPackage.length() != 0) {
            generator.addLine("package " + this.environment.outputPackage + ";");
        }
    }

    private void addExceptionMessage(WSDLMessage message) throws ProxyGeneratorException {
        WSDLPart part;
        TypeDefinitionBase type;
        if (this.exceptionMessages.contains(message)) {
            return;
        }
        ArrayList messageParts = message.getParts();
        if (messageParts.size() == 1 && !this.environment.schema.isSimple(type = this.getPartType(part = (WSDLPart)messageParts.get(0))) && !this.environment.schema.isSoapArray(type)) {
            int i = 0;
            while (i < this.exceptionMessages.size()) {
                WSDLPart cpart;
                TypeDefinitionBase ctype;
                WSDLMessage cmessage = (WSDLMessage)this.exceptionMessages.get(i);
                if (cmessage.getPartCount() == 1 && (ctype = this.getPartType(cpart = cmessage.getPart(0))) == type) {
                    return;
                }
                ++i;
            }
        }
        this.exceptionMessages.add(message);
    }

    public TypeDefinitionBase getPartType(WSDLPart part) throws ProxyGeneratorException {
        com.sap.engine.lib.xml.util.QName typeLink = part.getType();
        TypeDefinitionBase type = part.getStyle() == 2 ? this.environment.schema.getType(typeLink.getURI(), typeLink.getLocalName()) : this.environment.schema.getElementType(typeLink.getURI(), typeLink.getLocalName());
        if (type == null) {
            throw new ProxyGeneratorException("webservices_3210", typeLink.toString());
        }
        return type;
    }

    public void checkParams(WSDLOperation operation) throws ProxyGeneratorException {
        WSDLChannel input = operation.getInput();
        WSDLChannel output = operation.getOutput();
        if (input == null || output == null) {
            return;
        }
        WSDLMessage inMessage = this.environment.definitions.getMessage(input.getMessage());
        WSDLMessage outMessage = this.environment.definitions.getMessage(output.getMessage());
        if (inMessage == null) {
            throw new ProxyGeneratorException("webservices_3208", input.getMessage().toString(), operation.getName());
        }
        if (outMessage == null) {
            throw new ProxyGeneratorException("webservices_3208", output.getMessage().toString(), operation.getName());
        }
        ArrayList inMessageParts = inMessage.getParts();
        ArrayList outMessageParts = outMessage.getParts();
        if (outMessageParts.size() == 1) {
            return;
        }
        int i = 0;
        while (i < inMessageParts.size()) {
            WSDLPart partIn = (WSDLPart)inMessageParts.get(i);
            int j = 0;
            while (j < outMessageParts.size()) {
                WSDLPart partOut = (WSDLPart)outMessageParts.get(j);
                if (partIn.getName().equals(partOut.getName())) {
                    throw new ProxyGeneratorException("webservices_3209", operation.getName());
                }
                ++j;
            }
            ++i;
        }
    }

    public WSDLMessage getMessage(com.sap.engine.lib.xml.util.QName messageLink, String operationName) throws ProxyGeneratorException {
        WSDLMessage message = this.environment.definitions.getMessage(messageLink.getLocalName(), messageLink.getURI());
        if (message == null) {
            throw new ProxyGeneratorException("webservices_3208", messageLink.toString(), operationName);
        }
        return message;
    }

    public String processAOperationHeader(String methodName, WSDLOperation operation) throws ProxyGeneratorException {
        StringBuffer result = new StringBuffer();
        com.sap.engine.lib.xml.util.QName messageInName = operation.getInput().getMessage();
        com.sap.engine.lib.xml.util.QName messageOutName = operation.getOutput().getMessage();
        WSDLMessage inMessage = this.environment.definitions.getMessage(messageInName);
        WSDLMessage outMessage = this.environment.definitions.getMessage(messageOutName);
        WSDLPart inpart = inMessage.getPart(0);
        WSDLPart outpart = outMessage.getPart(0);
        com.sap.engine.lib.xml.util.QName inType = inpart.getType();
        com.sap.engine.lib.xml.util.QName outType = outpart.getType();
        ComplexTypeDefinition inTypeDefinition = (ComplexTypeDefinition)this.environment.schema.getElementType(inType.getURI(), inType.getLocalName());
        ComplexTypeDefinition outTypeDefinition = (ComplexTypeDefinition)this.environment.schema.getElementType(outType.getURI(), outType.getLocalName());
        ArrayList inFields = this.environment.schema.getComplexFieldInfo(inTypeDefinition);
        ArrayList outFields = this.environment.schema.getComplexFieldInfo(outTypeDefinition);
        result.append("public ");
        this.environment.returnType = null;
        if (outFields.size() != 0) {
            FieldInfo info = (FieldInfo)outFields.get(0);
            this.environment.returnType = info.getTypeJavaName();
            result.append(info.getTypeJavaName());
        } else {
            result.append("void");
        }
        result.append(" " + methodName + "(");
        boolean flag = false;
        int i = 0;
        while (i < inFields.size()) {
            if (flag) {
                result.append(", ");
            }
            FieldInfo info = (FieldInfo)inFields.get(i);
            result.append(info.getTypeJavaName() + " _" + info.getFieldJavaName());
            flag = true;
            ++i;
        }
        result.append(")");
        return result.toString();
    }

    public String[] getExceptions(ArrayList faults, String operationName) throws ProxyGeneratorException {
        String[] result = new String[faults.size()];
        int i = 0;
        while (i < faults.size()) {
            WSDLFault fault = (WSDLFault)faults.get(i);
            WSDLMessage message = this.getMessage(fault.getMessage(), operationName);
            this.addExceptionMessage(message);
            result[i] = this.getExceptionClassName(message, true);
            ++i;
        }
        return result;
    }

    public OperationInterface fillOperationInfo(String methodName, WSDLOperation operation) throws ProxyGeneratorException {
        OperationInterface operationInterface = new OperationInterface();
        operationInterface.operationName = operation.getName();
        operationInterface.operationJavaName = methodName;
        operationInterface.operationRequestName = operation.getName();
        operationInterface.operationResponseName = operation.getName() + "Response";
        WSDLPortType portType = (WSDLPortType)operation.getParentNode();
        operationInterface.portTypeName = new QName(portType.getNamespace(), portType.getNamespace());
        if (this.isDocumentStyle(operation)) {
            WSDLMessage inMessage = this.environment.definitions.getMessage(operation.getInput().getMessage());
            WSDLMessage outMessage = this.environment.definitions.getMessage(operation.getOutput().getMessage());
            WSDLPart inPart = inMessage.getPart(0);
            WSDLPart outPart = outMessage.getPart(0);
            operationInterface.operationRequestName = inPart.getType().getLocalName();
            operationInterface.operationRequestNamespace = inPart.getType().getURI();
            operationInterface.operationResponseName = outPart.getType().getLocalName();
            operationInterface.operationResponseNamespace = outPart.getType().getURI();
            com.sap.engine.lib.xml.util.QName inType = inPart.getType();
            com.sap.engine.lib.xml.util.QName outType = outPart.getType();
            ComplexTypeDefinition inTypeDefinition = (ComplexTypeDefinition)this.environment.schema.getElementType(inType.getURI(), inType.getLocalName());
            ComplexTypeDefinition outTypeDefinition = (ComplexTypeDefinition)this.environment.schema.getElementType(outType.getURI(), outType.getLocalName());
            ArrayList inFields = this.environment.schema.getComplexFieldInfo(inTypeDefinition);
            ArrayList outFields = this.environment.schema.getComplexFieldInfo(outTypeDefinition);
            if (outFields.size() == 1) {
                FieldInfo info = (FieldInfo)outFields.get(0);
                operationInterface.outputParams = new ServiceParam[1];
                ServiceParam param = new ServiceParam();
                param.isElement = false;
                param.schemaName = info.getTypeQName();
                param.contentClassName = info.getTypeJavaName();
                param.name = info.getFieldLocalName();
                param.namespace = info.getFieldUri();
                operationInterface.outputParams[0] = param;
            } else {
                operationInterface.outputParams = new ServiceParam[0];
            }
            operationInterface.inputParams = new ServiceParam[inFields.size()];
            int i = 0;
            while (i < inFields.size()) {
                FieldInfo info = (FieldInfo)inFields.get(i);
                ServiceParam param = new ServiceParam();
                param.isElement = false;
                param.schemaName = info.getTypeQName();
                param.contentClassName = info.getTypeJavaName();
                param.name = info.getFieldLocalName();
                param.namespace = info.getFieldUri();
                operationInterface.inputParams[i] = param;
                ++i;
            }
        } else {
            ServiceParam param;
            ArrayList parts;
            WSDLMessage message;
            WSDLChannel input = operation.getInput();
            WSDLChannel output = operation.getOutput();
            if (output != null) {
                message = this.getMessage(output.getMessage(), operation.getName());
                parts = message.getParts();
                if (parts.size() == 1) {
                    WSDLPart part = (WSDLPart)parts.get(0);
                    operationInterface.outputParams = new ServiceParam[1];
                    param = new ServiceParam();
                    param.wsdlPartName = part.getName();
                    TypeDefinitionBase type = this.getPartType(part);
                    if (part.getStyle() == 1) {
                        operationInterface.isDocumentStyle = true;
                        param.isElement = true;
                        param.name = part.getType().getLocalName();
                        param.namespace = part.getType().getURI();
                        operationInterface.operationResponseName = param.name;
                        operationInterface.operationResponseNamespace = param.namespace;
                    } else {
                        param.isElement = false;
                        param.name = part.getName();
                    }
                    param.contentClassName = this.environment.schema.getJavaPrimitive(type);
                    param.schemaName = new QName(type.getTargetNamespace(), type.getName());
                    operationInterface.outputParams[0] = param;
                } else {
                    operationInterface.outputParams = new ServiceParam[0];
                }
            }
            if (input != null) {
                message = this.getMessage(input.getMessage(), operation.getName());
                parts = message.getParts();
                operationInterface.inputParams = new ServiceParam[parts.size()];
                int i = 0;
                while (i < parts.size()) {
                    param = new ServiceParam();
                    WSDLPart part = (WSDLPart)parts.get(i);
                    param.wsdlPartName = part.getName();
                    TypeDefinitionBase type = this.getPartType(part);
                    if (part.getStyle() == 1) {
                        operationInterface.isDocumentStyle = true;
                        param.isElement = true;
                        param.name = part.getType().getLocalName();
                        param.namespace = part.getType().getURI();
                        operationInterface.operationRequestName = param.name;
                        operationInterface.operationRequestNamespace = param.namespace;
                    } else {
                        param.isElement = false;
                        param.name = part.getName();
                    }
                    param.contentClassName = this.environment.schema.getJavaPrimitive(type);
                    param.schemaName = new QName(type.getTargetNamespace(), type.getName());
                    operationInterface.inputParams[i] = param;
                    ++i;
                }
            }
        }
        ArrayList faults = operation.getFaultList();
        operationInterface.faultParams = new ServiceParam[faults.size()];
        int i = 0;
        while (i < faults.size()) {
            WSDLFault fault = (WSDLFault)faults.get(i);
            WSDLMessage message = this.environment.definitions.getMessage(fault.getMessage());
            WSDLPart part = message.getPart(0);
            TypeDefinitionBase type = this.getPartType(part);
            ServiceParam param = new ServiceParam();
            param.wsdlPartName = part.getNamespace();
            if (part.getStyle() == 2) {
                param.name = part.getName();
                param.isElement = false;
                param.schemaName = new QName(part.getType().getURI(), part.getType().getName());
                param.contentClassName = this.environment.schema.getJavaPrimitive(type);
            } else {
                param.name = part.getType().getName();
                param.namespace = part.getType().getURI();
                param.isElement = true;
                param.schemaName = new QName(type.getTargetNamespace(), type.getName());
                param.contentClassName = this.environment.schema.getJavaPrimitive(type);
            }
            operationInterface.faultParams[i] = param;
            ++i;
        }
        return operationInterface;
    }

    public String generateOperationHeader(String methodName, WSDLOperation operation) throws ProxyGeneratorException {
        if (this.isDocumentStyle(operation)) {
            return this.processAOperationHeader(methodName, operation);
        }
        return this.processOperationHeader(methodName, operation);
    }

    public String processOperationHeader(String methodName, WSDLOperation operation) throws ProxyGeneratorException {
        TypeDefinitionBase type;
        WSDLPart part;
        StringBuffer result = new StringBuffer();
        result.append("public ");
        WSDLChannel input = operation.getInput();
        WSDLChannel output = operation.getOutput();
        this.environment.returnType = null;
        if (output != null) {
            com.sap.engine.lib.xml.util.QName messagelink = output.getMessage();
            WSDLMessage message = this.getMessage(messagelink, operation.getName());
            ArrayList parts = message.getParts();
            if (parts.size() == 1) {
                part = (WSDLPart)parts.get(0);
                type = this.getPartType(part);
                this.environment.returnType = this.environment.schema.getJavaPrimitive(type);
                result.append(this.environment.returnType + " ");
            } else {
                result.append("void ");
            }
        } else {
            result.append("void ");
        }
        result.append(methodName + "(");
        if (input != null) {
            WSDLMessage message = this.getMessage(input.getMessage(), operation.getName());
            ArrayList parts = message.getParts();
            int i = 0;
            while (i < parts.size()) {
                part = (WSDLPart)parts.get(i);
                type = this.getPartType(part);
                String paramType = this.environment.schema.getJavaPrimitive(type);
                if (i != 0) {
                    result.append(", ");
                }
                result.append(paramType + " " + this.environment.convertor.attributeToIdentifier(part.getName()));
                ++i;
            }
        }
        result.append(")");
        return result.toString();
    }

    private void processExceptionComplexType(WSDLMessage message, CodeGenerator generator) throws ProxyGeneratorException {
        String className = this.getExceptionClassName(message, false);
        ArrayList messageParts = message.getParts();
        WSDLPart part = (WSDLPart)messageParts.get(0);
        TypeDefinitionBase partType = this.getPartType(part);
        String typeName = this.environment.schema.getJavaPrimitive(partType);
        String fieldJavaName = this.environment.convertor.attributeToIdentifier(part.getName());
        ArrayList fields = this.environment.schema.getComplexFieldInfo((ComplexTypeDefinition)partType);
        generator.clear(2);
        this.writePackage(generator);
        generator.addLine();
        generator.addLine("public class " + className + " extends java.lang.Exception {");
        generator.addLine("  private " + typeName + " " + fieldJavaName + ";");
        generator.addLine();
        generator.addLine("  public void init(" + typeName + " " + fieldJavaName + ") {");
        generator.addLine("    this." + fieldJavaName + "=" + fieldJavaName + ";");
        generator.addLine("  }");
        generator.addLine();
        if (fields.size() != 0) {
            generator.addLine("  public " + className + "() {");
            generator.addLine("    this." + fieldJavaName + "= new " + typeName + "();");
            generator.addLine("  }");
        }
        generator.addLine();
        generator.addLine("  public Class getContentClass() {");
        generator.addLine("    return " + typeName + ".class;");
        generator.addLine("  }");
        generator.addIndent();
        generator.add("  public " + className + "(");
        int i = 0;
        while (i < fields.size()) {
            FieldInfo field = (FieldInfo)fields.get(i);
            if (field.fieldModel != 1) {
                throw new ProxyGeneratorException("webservices_3212", part.getName());
            }
            if (i != 0) {
                generator.add(", ");
            }
            if (field.maxOccurs != 1) {
                generator.add(field.typeJavaName + "[] " + this.environment.convertor.attributeToIdentifier(field.fieldLocalName));
            } else {
                generator.add(field.typeJavaName + " " + this.environment.convertor.attributeToIdentifier(field.fieldLocalName));
            }
            ++i;
        }
        generator.add(") {");
        generator.addNewLine();
        generator.addLine("    this." + fieldJavaName + "= new " + typeName + "();");
        int i2 = 0;
        while (i2 < fields.size()) {
            FieldInfo field = (FieldInfo)fields.get(i2);
            generator.addLine("    this." + fieldJavaName + "." + field.getSetterMethod() + "(" + this.environment.convertor.attributeToIdentifier(field.fieldLocalName) + ");");
            ++i2;
        }
        generator.addLine("  }");
        generator.addLine();
        int i3 = 0;
        while (i3 < fields.size()) {
            FieldInfo field = (FieldInfo)fields.get(i3);
            if (field.fieldModel != 1) {
                throw new ProxyGeneratorException("webservices_3212", part.getName());
            }
            if (field.maxOccurs != 1) {
                generator.addLine("  public " + field.typeJavaName + "[] " + field.getGetterMethod() + "() {");
                generator.addLine("    return this." + fieldJavaName + "." + field.getGetterMethod() + "();");
                generator.addLine("  }");
            } else {
                generator.addLine("  public " + field.typeJavaName + " " + field.getGetterMethod() + "() {");
                generator.addLine("    return this." + fieldJavaName + "." + field.getGetterMethod() + "();");
                generator.addLine("  }");
            }
            ++i3;
        }
        generator.addLine("}");
        generator.addLine();
        File outFile = this.getNewJavaFile(this.environment.outputRootDir, this.environment.outputPackage, className);
        this.writeFile(generator, outFile);
    }

    private void writeFile(CodeGenerator generator, File outputFile) throws ProxyGeneratorException {
        try {
            PrintWriter output = new PrintWriter(new FileOutputStream(outputFile), true);
            output.write(generator.toString());
            output.close();
        }
        catch (FileNotFoundException e) {
            throw new ProxyGeneratorException("webservices_3207", outputFile.getAbsolutePath());
        }
    }

    private void processExceptionSimpleType(WSDLMessage message, CodeGenerator generator) throws ProxyGeneratorException {
        String className = this.getExceptionClassName(message, false);
        ArrayList messageParts = message.getParts();
        WSDLPart part = (WSDLPart)messageParts.get(0);
        com.sap.engine.lib.xml.util.QName type = part.getType();
        TypeDefinitionBase partType = this.getPartType(part);
        String typeName = this.environment.schema.getJavaPrimitive(partType);
        String fieldName = part.getName();
        if (part.getStyle() == 1) {
            fieldName = type.getLocalName();
        }
        String fieldJavaName = this.environment.convertor.attributeToIdentifier(fieldName);
        String methodName = this.environment.convertor.attributeToMethodName("get" + this.environment.convertor.attributeToClassName(fieldName));
        generator.clear(2);
        this.writePackage(generator);
        generator.addLine();
        generator.addLine("public class " + className + " extends java.lang.Exception {");
        generator.addLine("  private " + typeName + " " + fieldJavaName + ";");
        generator.addLine();
        generator.addLine("  public " + className + "(" + typeName + " " + fieldJavaName + ") {");
        generator.addLine("    this." + fieldJavaName + "=" + fieldJavaName + ";");
        generator.addLine("  }");
        generator.addLine();
        generator.addLine("  public " + className + "() {");
        generator.addLine("  }");
        generator.addLine();
        generator.addLine("  public void init(" + typeName + " " + fieldJavaName + ") {");
        generator.addLine("    this." + fieldJavaName + "=" + fieldJavaName + ";");
        generator.addLine("  }");
        generator.addLine("  public " + typeName + " " + methodName + "() {");
        generator.addLine("    return this." + fieldJavaName + ";");
        generator.addLine("  }");
        generator.addLine("  public Class getContentClass() {");
        generator.addLine("    return " + typeName + ".class;");
        generator.addLine("  }");
        generator.addLine("}");
        generator.addLine();
        File outFile = this.getNewJavaFile(this.environment.outputRootDir, this.environment.outputPackage, className);
        this.writeFile(generator, outFile);
    }

    private void generateExceptions(ArrayList messages) throws ProxyGeneratorException {
        CodeGenerator codeGenerator = new CodeGenerator();
        int i = 0;
        while (i < messages.size()) {
            WSDLMessage message = (WSDLMessage)messages.get(i);
            WSDLPart part = message.getPart(0);
            TypeDefinitionBase type = this.getPartType(part);
            if (this.environment.schema.isSimple(type) || this.environment.schema.isSoapArray(type)) {
                this.processExceptionSimpleType(message, codeGenerator);
            } else {
                this.processExceptionComplexType(message, codeGenerator);
            }
            ++i;
        }
    }

    public void generateAll(boolean compile) throws ProxyGeneratorException {
        this.generateAll(true, compile);
    }

    public void generateAll(boolean schemas, boolean compile) throws ProxyGeneratorException {
        if (schemas) {
            this.generateSchema();
        } else {
            this.prepareSchema();
        }
        if (!this.ihandler.startGenreration(this.environment) && this.environment.generateException != null) {
            if (this.environment.generateException instanceof ProxyGeneratorException) {
                throw (ProxyGeneratorException)((Object)this.environment.generateException);
            }
            throw new ProxyGeneratorException("webservices_3205", this.environment.generateException);
        }
        ArrayList portTypes = this.environment.definitions.getPortTypes();
        int i = 0;
        while (i < portTypes.size()) {
            WSDLPortType portType = (WSDLPortType)portTypes.get(i);
            if (!this.ihandler.processPortType(portType, this.environment) && this.environment.generateException != null) {
                if (this.environment.generateException instanceof ProxyGeneratorException) {
                    throw (ProxyGeneratorException)((Object)this.environment.generateException);
                }
                throw new ProxyGeneratorException("webservices_3205", this.environment.generateException);
            }
            this.generateExceptions(this.exceptionMessages);
            ++i;
        }
        if (!this.ihandler.endGeneration(this.environment) && this.environment.generateException != null) {
            if (this.environment.generateException instanceof ProxyGeneratorException) {
                throw (ProxyGeneratorException)((Object)this.environment.generateException);
            }
            throw new ProxyGeneratorException("webservices_3205", this.environment.generateException);
        }
        if (compile) {
            this.builder.setPackageRoot(this.environment.outputRootDir);
            this.builder.setPackageName(this.environment.outputPackage);
            try {
                this.builder.compilePackage();
            }
            catch (Exception e) {
                throw new ProxyGeneratorException("webservices_3205", e);
            }
        }
    }

    public void generatePortal(String wsdlpath, String outputDir, String packageName, boolean compile, Hashtable uriToPackageMapping) throws WSDLException, ProxyGeneratorException {
        InterfaceGenerator generator = new InterfaceGenerator();
        WSDLDOMLoader loader = new WSDLDOMLoader();
        WSDLDefinitions definitions = loader.loadWSDLDocument(wsdlpath);
        generator.init(definitions, outputDir, packageName, new PortalHandler(), null);
        generator.generateAll(true, compile);
    }

    public void generateBean(String wsdlpath, String outputDir, String packageName, boolean compile, Hashtable uriToPackageMapping) throws WSDLException, ProxyGeneratorException {
        InterfaceGenerator generator = new InterfaceGenerator();
        WSDLDOMLoader loader = new WSDLDOMLoader();
        WSDLDefinitions definitions = loader.loadWSDLDocument(wsdlpath);
        generator.init(definitions, outputDir, packageName, new BeanHandler(), null);
        generator.generateAll(true, compile);
    }

    public void generateBean(String httpProxyhost, String httpProxyport, String wsdlpath, String outputDir, String packageName, boolean compile, Hashtable uriToPackageMapping) throws WSDLException, ProxyGeneratorException {
        InterfaceGenerator generator = new InterfaceGenerator();
        WSDLDOMLoader loader = new WSDLDOMLoader();
        loader.setHttpProxy(httpProxyhost, httpProxyport);
        WSDLDefinitions definitions = loader.loadWSDLDocument(wsdlpath);
        generator.init(definitions, outputDir, packageName, new BeanHandler(), null);
        generator.generateAll(true, compile);
    }

    public void generatePortal(String httpProxyhost, String httpProxyport, String wsdlpath, String outputDir, String packageName, boolean compile, Hashtable uriToPackageMapping) throws WSDLException, ProxyGeneratorException {
        InterfaceGenerator generator = new InterfaceGenerator();
        WSDLDOMLoader loader = new WSDLDOMLoader();
        loader.setHttpProxy(httpProxyhost, httpProxyport);
        WSDLDefinitions definitions = loader.loadWSDLDocument(wsdlpath);
        generator.init(definitions, outputDir, packageName, new PortalHandler(), null);
        generator.generateAll(true, compile);
    }

    public static void main(String[] args) throws WSDLException, ProxyGeneratorException {
        InterfaceGenerator generator = new InterfaceGenerator();
        WSDLDOMLoader loader = new WSDLDOMLoader();
        System.out.println(System.getProperty("http.proxyHost"));
        loader.setHttpProxy("proxy", "8080");
        WSDLDefinitions definitions = loader.loadWSDLDocument("E:/wsrp_service.wsdl");
        generator.init(definitions, "E:/outputDir/", "wsrpPortals", new PortalHandler(), null);
        generator.setHTTPProxy("proxy", "8080");
        generator.generateAll(true, true);
        generator.environment.printInterfaces();
        System.out.println();
        System.out.println(System.getProperty("http.proxyHost"));
    }
}

