/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.wsdl2java;

import com.sap.engine.services.webservices.jaxrpc.exceptions.ProxyGeneratorException;
import com.sap.engine.services.webservices.jaxrpc.util.CodeGenerator;
import com.sap.engine.services.webservices.jaxrpc.util.NameConvertor;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.GeneratorEnvironment;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;

public class InterfaceDefinition {
    private NameConvertor convertor;
    private String interfaceName;
    private String packageName;
    private String qualifiedName;
    private CodeGenerator content = new CodeGenerator();
    private String[] extendsInterfaces;
    private CodeGenerator output = new CodeGenerator();
    private String[] imports;

    public InterfaceDefinition() {
        this.convertor = new NameConvertor();
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
        this.qualifiedName = this.packageName != null && this.packageName.length() != 0 ? this.packageName + "." + interfaceName : interfaceName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
        this.qualifiedName = packageName != null && packageName.length() != 0 ? packageName + "." + this.interfaceName : this.interfaceName;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public void setQualifiedName(String qualifiedName) {
        this.qualifiedName = qualifiedName;
        this.packageName = this.convertor.getPackage(qualifiedName);
        this.interfaceName = this.convertor.getClassName(qualifiedName);
    }

    public CodeGenerator getContent() {
        return this.content;
    }

    public void setContent(CodeGenerator content) {
        this.content = content;
    }

    public String[] getExtendsInterfaces() {
        return this.extendsInterfaces;
    }

    public void setExtendsInterfaces(String[] extendsInterfaces) {
        this.extendsInterfaces = extendsInterfaces;
    }

    public CodeGenerator getOutput() {
        return this.output;
    }

    public void setOutput(CodeGenerator output) {
        this.output = output;
    }

    public String[] getImports() {
        return this.imports;
    }

    public void setImports(String[] imports) {
        this.imports = imports;
    }

    public File save(File outputDir) throws ProxyGeneratorException {
        File outFile = GeneratorEnvironment.getNewJavaFile(outputDir, this.qualifiedName);
        this.generateOutput();
        this.writeFile(this.output, outFile);
        return outFile;
    }

    private void writePackage(CodeGenerator generator) {
        if (this.packageName != null && this.packageName.length() != 0) {
            generator.addLine("package " + this.packageName + ";");
        }
    }

    private void writeFile(CodeGenerator generator, File outputFile) throws ProxyGeneratorException {
        try {
            PrintWriter output = new PrintWriter(new FileOutputStream(outputFile), true);
            output.write(generator.toString());
            output.close();
        }
        catch (FileNotFoundException e) {
            throw new ProxyGeneratorException("webservices_3207", outputFile.getAbsolutePath());
        }
    }

    private void generateOutput() {
        int i;
        this.output.clear(2);
        this.writePackage(this.output);
        if (this.imports != null) {
            i = 0;
            while (i < this.imports.length) {
                this.output.addLine("import " + this.imports[i] + ";");
                ++i;
            }
        }
        this.output.addNewLine();
        this.output.add("public interface " + this.interfaceName);
        if (this.extendsInterfaces != null && this.extendsInterfaces.length > 0) {
            this.output.add(" extends ");
            i = 0;
            while (i < this.extendsInterfaces.length) {
                this.output.add(this.extendsInterfaces[i]);
                if (i != this.extendsInterfaces.length - 1) {
                    this.output.add(",");
                }
                ++i;
            }
        }
        this.output.add(" {");
        this.output.addNewLine();
        this.output.startSection();
        this.output.append(this.content);
        this.output.endSection();
        this.output.addLine("}");
    }
}

