/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.util;

import com.sap.engine.lib.xml.names.XMLNameMapper;
import com.sap.engine.lib.xml.parser.URLLoaderBase;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class NameConvertor {
    private String holderPack = "javax.xml.rpc.holders";
    private char separator = File.separatorChar;
    private char point = (char)46;
    private StringBuffer result = null;
    private XMLNameMapper mapper = null;
    private Hashtable holderMapping = null;
    public static HashSet reservedWords = null;
    private Hashtable wrapperMapping = null;
    private Hashtable unwrapperMapping = null;
    private Hashtable mimeTypes = null;
    private HashSet customReserved = null;
    private boolean useCustomReserved = false;
    private Hashtable names = new Hashtable();
    private Hashtable objectToNames = new Hashtable();

    public NameConvertor() {
        this.customReserved = new HashSet();
        this.result = new StringBuffer();
        this.mapper = new XMLNameMapper();
        this.wrapperMapping = new Hashtable();
        this.unwrapperMapping = new Hashtable();
        this.holderMapping = new Hashtable();
        this.mimeTypes = new Hashtable();
        this.holderMappingInit();
        this.wrapperMappingInit();
        this.unwrapperMappingInit();
        this.mimeTypesInit();
    }

    public void addCustomReserved(String word) {
        this.customReserved.add(word);
    }

    public void clearCustomReserved() {
        this.customReserved.clear();
    }

    public void enableCustomReserved() {
        this.useCustomReserved = true;
    }

    public void disableCustomReserved() {
        this.useCustomReserved = false;
    }

    private void mimeTypesInit() {
        this.mimeTypes.put("image/gif", "java.awt.Image");
        this.mimeTypes.put("image/jpeg", "java.awt.Image");
        this.mimeTypes.put("text/plain", "java.lang.String");
        this.mimeTypes.put("multipart/*", "javax.mail.internet.MimeMultipart");
        this.mimeTypes.put("text/xml", "javax.xml.transform.Source");
        this.mimeTypes.put("application/xml", "javax.xml.transform.Source");
    }

    private void unwrapperMappingInit() {
        this.unwrapperMapping.put("java.lang.Boolean", "boolean");
        this.unwrapperMapping.put("java.lang.Byte", "byte");
        this.unwrapperMapping.put("java.lang.Double", "double");
        this.unwrapperMapping.put("java.lang.Float", "float");
        this.unwrapperMapping.put("java.lang.Integer", "int");
        this.unwrapperMapping.put("java.lang.Long", "long");
        this.unwrapperMapping.put("java.lang.Short", "short");
    }

    private void wrapperMappingInit() {
        this.wrapperMapping.put("boolean", "java.lang.Boolean");
        this.wrapperMapping.put("byte", "java.lang.Byte");
        this.wrapperMapping.put("double", "java.lang.Double");
        this.wrapperMapping.put("float", "java.lang.Float");
        this.wrapperMapping.put("int", "java.lang.Integer");
        this.wrapperMapping.put("long", "java.lang.Long");
        this.wrapperMapping.put("short", "java.lang.Short");
    }

    public boolean isPrimitive(String type) {
        return this.wrapperMapping.get(type) != null;
    }

    public String wrap(String type) {
        if (this.wrapperMapping.get(type) != null) {
            return (String)this.wrapperMapping.get(type);
        }
        return type;
    }

    public String unwrap(String type) {
        if (this.unwrapperMapping.get(type) != null) {
            return (String)this.unwrapperMapping.get(type);
        }
        return type;
    }

    private void holderMappingInit() {
        this.holderMapping.put("java.lang.String", "StringHolder");
        this.holderMapping.put("int", "IntHolder");
        this.holderMapping.put("long", "LongHolder");
        this.holderMapping.put("byte", "ByteHolder");
        this.holderMapping.put("boolean", "BooleanHolder");
        this.holderMapping.put("byte[]", "ByteArrayHolder");
        this.holderMapping.put("double", "DoubleHolder");
        this.holderMapping.put("float", "FloatHolder");
        this.holderMapping.put("short", "ShortHolder");
        this.holderMapping.put("java.util.Calendar", "CalendarHolder");
        this.holderMapping.put("java.math.BigInteger", "BigIntegerHolder");
        this.holderMapping.put("java.math.BigDecimal", "BigDecimalHolder");
        this.holderMapping.put("java.lang.Boolean", "BooleanWrapperHolder");
        this.holderMapping.put("java.lang.Byte", "ByteWrapperHolder");
        this.holderMapping.put("java.lang.Double", "DoubleWrapperHolder");
        this.holderMapping.put("java.lang.Float", "FloatWrapperHolder");
        this.holderMapping.put("java.lang.Integer", "IntegerWrapperHolder");
        this.holderMapping.put("java.lang.Long", "LongWrapperHolder");
        this.holderMapping.put("java.lang.Object", "ObjectHolder");
        this.holderMapping.put("java.lang.Short", "ShortWrapperHolder");
    }

    public String getValueAsObject(String name, boolean holder, String type) {
        if (holder) {
            name = name + ".value";
        }
        if (this.isPrimitive(type)) {
            return "new " + this.wrap(type) + "(" + name + ")";
        }
        return name;
    }

    public String packageToPath(String packageName) {
        if (packageName == null || packageName.length() == 0) {
            return "";
        }
        this.result.setLength(0);
        int found = -1;
        int beg = 0;
        while ((found = packageName.indexOf(this.point, beg)) != -1) {
            this.result.append(this.separator);
            this.result.append(packageName.substring(beg, found));
            beg = found + 1;
        }
        if (beg < packageName.length()) {
            this.result.append(this.separator);
            this.result.append(packageName.substring(beg));
        }
        this.result.append(this.separator);
        return this.result.toString();
    }

    public String attributeToClassName(String attribute) {
        return this.mapper.toClassIdentifier(attribute);
    }

    public String attributeToMethodName(String attribute) {
        String result = this.mapper.toMethodIdentifier(attribute);
        if (this.useCustomReserved && this.customReserved.contains(result)) {
            result = result + "Temp";
        }
        if (reservedWords.contains(result)) {
            result = result + "Temp";
        }
        return result;
    }

    public String primitiveToHolder(String javaPrimitive) throws Exception {
        String result = (String)this.holderMapping.get(javaPrimitive);
        if (result == null) {
            throw new Exception(" Java primitive type " + javaPrimitive + " could not be recognized !");
        }
        result = this.holderPack + "." + result;
        return result;
    }

    public String complexToHolder(String javaComplex) {
        String result = this.getLocalClass(javaComplex);
        int pos1 = result.indexOf(91);
        if (pos1 != -1) {
            result = result.substring(0, pos1);
            result = Character.toUpperCase(result.charAt(0)) + result.substring(1);
            result = result + "Array";
        }
        return result + "Holder";
    }

    public String attributeToIdentifier(String attribute) {
        String result = this.mapper.toMethodIdentifier(attribute);
        if (this.useCustomReserved && this.customReserved.contains(result)) {
            result = result + "Temp";
        }
        if (reservedWords.contains(result)) {
            result = result + "Temp";
        }
        return result;
    }

    public String getLocalClass(String qJavaName) {
        int pos = qJavaName.lastIndexOf(46);
        if (pos == -1) {
            return qJavaName;
        }
        return qJavaName.substring(pos + 1);
    }

    public String getPackageClass(String qJavaName) {
        int pos = qJavaName.lastIndexOf(46);
        if (pos == -1) {
            return null;
        }
        return qJavaName.substring(0, pos);
    }

    public String uriToPackage(String uri) throws Exception {
        URL url = null;
        String packageName = null;
        try {
            url = URLLoaderBase.fileOrURLToURL(null, (String)uri);
            packageName = url.getHost();
            if ((packageName == null || packageName.length() == 0) && (packageName = url.getFile()).lastIndexOf(".") != -1) {
                packageName = packageName.substring(0, packageName.lastIndexOf("."));
            }
        }
        catch (IOException e) {
            throw new Exception("Unable to create package name from uri {" + uri + "} ! Please select some package name !");
        }
        StringTokenizer tokenizer = new StringTokenizer(packageName, ".");
        String result = null;
        if (tokenizer.countTokens() == 1) {
            return tokenizer.nextToken().toLowerCase();
        }
        result = tokenizer.nextToken().toLowerCase();
        while (tokenizer.hasMoreTokens()) {
            result = tokenizer.nextToken().toLowerCase() + '.' + result;
        }
        return result;
    }

    public String findMimeType(String contentType) {
        String replacement = (String)this.mimeTypes.get(contentType);
        if (replacement == null) {
            return "javax.activation.DataHandler";
        }
        return replacement;
    }

    public void addClassName(String className) {
        String packageName = this.getPackage(className);
        className = this.getClassName(className);
        HashSet<String> container = (HashSet<String>)this.names.get(packageName);
        if (container == null) {
            container = new HashSet<String>();
            this.names.put(packageName, container);
        }
        container.add(className);
    }

    public void addClassName(String packageName, String className) {
        HashSet<String> container;
        if (packageName == null) {
            packageName = "";
        }
        if ((container = (HashSet<String>)this.names.get(packageName)) == null) {
            container = new HashSet<String>();
            this.names.put(packageName, container);
        }
        container.add(className);
    }

    public String getPackage(String className) {
        String packageName = "";
        if (className.lastIndexOf(".") != -1) {
            packageName = className.substring(0, className.lastIndexOf("."));
        }
        return packageName;
    }

    public String getClassName(String className) {
        if (className.lastIndexOf(".") != -1) {
            className = className.substring(className.lastIndexOf(".") + 1);
        }
        return className;
    }

    public boolean contains(String className) {
        String packageName = this.getPackage(className);
        className = this.getClassName(className);
        if (this.names.containsKey(packageName)) {
            HashSet container = (HashSet)this.names.get(packageName);
            return container.contains(className);
        }
        return false;
    }

    public boolean conains(String packageName, String className) {
        if (packageName == null) {
            packageName = "";
        }
        if (this.names.containsKey(packageName)) {
            HashSet container = (HashSet)this.names.get(packageName);
            return container.contains(className);
        }
        return false;
    }

    public void clear() {
        this.names.clear();
        this.objectToNames.clear();
    }

    public void mapObjectToName(Object obj, String className) {
        this.objectToNames.put(obj, className);
    }

    public static void main(String[] args) throws Exception {
        String uri = "http://schemas.xmlsoap.org/wsdl/";
        NameConvertor convertor = new NameConvertor();
        String packageName = convertor.uriToPackage(uri);
        System.out.println(packageName);
    }

    static {
        reservedWords = new HashSet(51);
        reservedWords.add("abstract");
        reservedWords.add("break");
        reservedWords.add("byte");
        reservedWords.add("boolean");
        reservedWords.add("catch");
        reservedWords.add("case");
        reservedWords.add("class");
        reservedWords.add("char");
        reservedWords.add("continue");
        reservedWords.add("default");
        reservedWords.add("double");
        reservedWords.add("do");
        reservedWords.add("else");
        reservedWords.add("extends");
        reservedWords.add("false");
        reservedWords.add("final");
        reservedWords.add("float");
        reservedWords.add("for");
        reservedWords.add("finally");
        reservedWords.add("if");
        reservedWords.add("import");
        reservedWords.add("implements");
        reservedWords.add("int");
        reservedWords.add("interface");
        reservedWords.add("instanceof");
        reservedWords.add("long");
        reservedWords.add("length");
        reservedWords.add("native");
        reservedWords.add("new");
        reservedWords.add("null");
        reservedWords.add("package");
        reservedWords.add("private");
        reservedWords.add("protected");
        reservedWords.add("public");
        reservedWords.add("final");
        reservedWords.add("return");
        reservedWords.add("switch");
        reservedWords.add("synchronized");
        reservedWords.add("short");
        reservedWords.add("static");
        reservedWords.add("super");
        reservedWords.add("try");
        reservedWords.add("true");
        reservedWords.add("this");
        reservedWords.add("throw");
        reservedWords.add("throws");
        reservedWords.add("threadsafe");
        reservedWords.add("transient");
        reservedWords.add("void");
        reservedWords.add("volatile");
        reservedWords.add("while");
    }
}

