/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.schema2java;

import com.sap.engine.lib.schema.components.AttributeUse;
import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.ComplexTypeDefinition;
import com.sap.engine.lib.schema.components.ElementDeclaration;
import com.sap.engine.lib.schema.components.ModelGroup;
import com.sap.engine.lib.schema.components.Particle;
import com.sap.engine.lib.schema.components.Schema;
import com.sap.engine.lib.schema.components.TypeDefinitionBase;
import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.services.webservices.jaxrpc.schema2java.SchemaToJavaGeneratorException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class SoapArrayInfo {
    private TypeDefinitionBase itemType;
    private int dimensions;

    protected SoapArrayInfo(TypeDefinitionBase td) throws SchemaToJavaGeneratorException {
        this.init(td);
    }

    public TypeDefinitionBase getItemType() {
        return this.itemType;
    }

    protected int getDimensions() {
        return this.dimensions;
    }

    private void init(TypeDefinitionBase td) throws SchemaToJavaGeneratorException {
        Particle[] pa;
        ModelGroup mg;
        Base term;
        Particle p;
        if (!(td instanceof ComplexTypeDefinition)) {
            throw new SchemaToJavaGeneratorException("Types extending soapenc:Array should be complex types.");
        }
        ComplexTypeDefinition ctd = (ComplexTypeDefinition)td;
        if (!ctd.isDerivationMethodRestriction()) {
            throw new SchemaToJavaGeneratorException("Type soapenc:Array should only be derived by restriction.");
        }
        AttributeUse[] au = ctd.getAttributeUsesArray();
        if (au != null) {
            int i = 0;
            while (i < au.length) {
                Element e;
                Node node = au[i].getAssociatedDOMNode();
                if (node != null && node instanceof Element && (e = (Element)node).hasAttributeNS("http://schemas.xmlsoap.org/wsdl/", "arrayType")) {
                    this.initWithArrayType(td.getOwnerSchema(), e, e.getAttributeNS("http://schemas.xmlsoap.org/wsdl/", "arrayType"));
                    return;
                }
                ++i;
            }
        }
        if ((p = ctd.getContentTypeContentModel()) != null && (term = p.getTerm()) != null && term instanceof ModelGroup && (mg = (ModelGroup)term).isCompositorSequence() && (pa = mg.getParticlesArray()) != null && pa[0].getTerm() != null && pa[0].getTerm() instanceof ElementDeclaration) {
            this.dimensions = 1;
            this.itemType = ((ElementDeclaration)pa[0].getTerm()).getTypeDefinition();
            return;
        }
        throw new SchemaToJavaGeneratorException("Unable to find info about the item type of a soap array.");
    }

    private void initWithArrayType(Schema sch, Element e, String s) throws SchemaToJavaGeneratorException {
        int indexOfBracket = s.indexOf(91);
        if (indexOfBracket == -1) {
            throw new SchemaToJavaGeneratorException("wsdl:arrayType sould contain at least one '['");
        }
        String qname = s.substring(0, indexOfBracket);
        this.dimensions = 0;
        int depth = 0;
        int ls = s.length();
        int i = indexOfBracket;
        while (i < ls) {
            switch (s.charAt(i)) {
                case '[': {
                    ++depth;
                }
                case ',': {
                    ++this.dimensions;
                    break;
                }
                case ']': {
                    if (depth == 0) {
                        throw new SchemaToJavaGeneratorException("Unable to parse wsdl:arrayType, dimension specifiers ('[', ']', and ',') are not properly nested");
                    }
                    --depth;
                    break;
                }
                default: {
                    throw new SchemaToJavaGeneratorException("Unable to parse wsdl:arrayType, invalid character in the dimension specifiers, '" + s.charAt(i) + "'");
                }
            }
            ++i;
        }
        if (depth != 0) {
            throw new SchemaToJavaGeneratorException("Unable to parse wsdl:arrayType, dimension specifiers ('[', ']', and ',') are not properly nested");
        }
        String uri = DOM.qnameToURI((String)qname, (Node)e);
        String local = DOM.qnameToLocalName((String)qname);
        if (uri == null) {
            throw new SchemaToJavaGeneratorException("Unable to parse wsdl:arrayType, the qname's prefix cannot be resolved to a uri");
        }
        this.itemType = sch.getTopLevelTypeDefinition(uri, local);
        if (this.itemType == null) {
            throw new SchemaToJavaGeneratorException("Unable to parse wsdl:arrayType, qname '" + qname + "' cannot be resolved to a type definition");
        }
    }
}

