/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.exceptions;

import com.sap.engine.services.webservices.jaxrpc.exceptions.accessors.XmlSerializationResourceAccessor;
import com.sap.exception.BaseExceptionInfo;
import com.sap.exception.IBaseException;
import com.sap.localization.LocalizableText;
import com.sap.localization.LocalizableTextFormatter;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;

public class InvalidResponseCodeException
extends IOException
implements IBaseException {
    public static final String INVALID_RESPONSE = "webservices_3500";
    public static final String INVALID_RESPONSE_NOT_FOUND = "webservices_3501";
    private BaseExceptionInfo info;
    private Hashtable responseHeaders;
    private int responseCode;

    public InvalidResponseCodeException(int responseCode, String responseMessage, Hashtable responseHeaders) {
        super(INVALID_RESPONSE);
        this.info = new BaseExceptionInfo((LocalizableText)new LocalizableTextFormatter(XmlSerializationResourceAccessor.getResourceAccessor(), INVALID_RESPONSE, new Object[]{Integer.toString(responseCode), responseMessage}), (Throwable)this);
        this.responseHeaders = responseHeaders;
        this.responseCode = responseCode;
    }

    public InvalidResponseCodeException(int responseCode, String responseMessage, Hashtable responseHeaders, String url) {
        super(INVALID_RESPONSE_NOT_FOUND);
        this.info = new BaseExceptionInfo((LocalizableText)new LocalizableTextFormatter(XmlSerializationResourceAccessor.getResourceAccessor(), INVALID_RESPONSE, new Object[]{Integer.toString(responseCode), responseMessage, url}), (Throwable)this);
        this.responseHeaders = responseHeaders;
        this.responseCode = responseCode;
    }

    public Hashtable getResponseHeaders() {
        return this.responseHeaders;
    }

    public String[] getResponseHeader(String headerName) {
        return (String[])this.responseHeaders.get(headerName);
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public Throwable initCause(Throwable cause) {
        if (this.info != null) {
            return this.info.initCause(cause);
        }
        return this;
    }

    public Throwable getCause() {
        return this.info.getCause();
    }

    public LocalizableText getLocalizableMessage() {
        return this.info.getLocalizableMessage();
    }

    public String getLocalizedMessage() {
        return this.info.getLocalizedMessage();
    }

    public String getLocalizedMessage(Locale loc) {
        return this.info.getLocalizedMessage(loc);
    }

    public String getLocalizedMessage(TimeZone timeZone) {
        return this.info.getLocalizedMessage(timeZone);
    }

    public String getLocalizedMessage(Locale loc, TimeZone timeZone) {
        return this.info.getLocalizedMessage(loc, timeZone);
    }

    public String getNestedLocalizedMessage() {
        return this.info.getNestedLocalizedMessage();
    }

    public String getNestedLocalizedMessage(Locale loc) {
        return this.info.getNestedLocalizedMessage(loc);
    }

    public String getNestedLocalizedMessage(TimeZone timeZone) {
        return this.info.getNestedLocalizedMessage(timeZone);
    }

    public String getNestedLocalizedMessage(Locale loc, TimeZone timeZone) {
        return this.info.getNestedLocalizedMessage(loc, timeZone);
    }

    public void finallyLocalize() {
        this.info.finallyLocalize();
    }

    public void finallyLocalize(Locale loc) {
        this.info.finallyLocalize(loc);
    }

    public void finallyLocalize(TimeZone timeZone) {
        this.info.finallyLocalize(timeZone);
    }

    public void finallyLocalize(Locale loc, TimeZone timeZone) {
        this.info.finallyLocalize(loc, timeZone);
    }

    public String getSystemStackTraceString() {
        StringWriter s = new StringWriter();
        super.printStackTrace(new PrintWriter(s));
        return s.toString();
    }

    public String getStackTraceString() {
        return this.info.getStackTraceString();
    }

    public String getNestedStackTraceString() {
        return this.info.getNestedStackTraceString();
    }

    public void printStackTrace() {
        this.info.printStackTrace();
    }

    public void printStackTrace(PrintStream s) {
        this.info.printStackTrace(s);
    }

    public void printStackTrace(PrintWriter s) {
        this.info.printStackTrace(s);
    }

    public void setLogSettings(Category cat, int severity, Location loc) {
        this.info.setLogSettings(cat, severity, loc);
    }

    public void log() {
        this.info.log();
    }
}

