/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.encoding;

import com.sap.engine.lib.schema.exception.RegularExpressionException;
import com.sap.engine.lib.schema.regular.RegularExpression;

public class SimpleValidator {
    public static boolean checkLengthString(Object value, int minLength, int maxLength) {
        if (value == null && minLength == 0) {
            return true;
        }
        if (value == null) {
            return false;
        }
        String perm = value.toString();
        return perm.length() >= minLength && perm.length() <= maxLength;
    }

    public static boolean checkLengthString(Object value, int length) {
        if (value == null && length == 0) {
            return true;
        }
        if (value == null) {
            return false;
        }
        return value.toString().length() == length;
    }

    public static boolean checkMinLengthString(Object value, int minLength) {
        if (value == null && minLength == 0) {
            return true;
        }
        if (value == null) {
            return false;
        }
        return value.toString().length() >= minLength;
    }

    public static boolean checkMaxLengthString(Object value, int maxLength) {
        if (value == null) {
            return true;
        }
        return value.toString().length() <= maxLength;
    }

    public static boolean validatePattern(RegularExpression regularExpression, String value) {
        try {
            return regularExpression.matcher(value).matches();
        }
        catch (RegularExpressionException e) {
            return false;
        }
    }

    public static boolean validatePattern(Object regularExpression, String value) {
        try {
            return SimpleValidator.getRegularExpression((String)regularExpression).matcher(value).matches();
        }
        catch (RegularExpressionException e) {
            return false;
        }
    }

    private static RegularExpression getRegularExpression(String regularExpression) throws RegularExpressionException {
        RegularExpression result = RegularExpression.compile((String)regularExpression);
        return result;
    }

    public static String getReplace(String value) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (c == '\t') {
                c = ' ';
            }
            if (c == '\n') {
                c = ' ';
            }
            if (c == '\r') {
                c = ' ';
            }
            result.append(c);
            ++i;
        }
        return result.toString();
    }

    public static Object getCollapse(Object value) {
        if (!(value instanceof String)) {
            return value;
        }
        char[] perm = ((String)value).toCharArray();
        boolean flag = false;
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < perm.length) {
            char c = perm[i];
            if (c == '\t') {
                c = ' ';
            }
            if (c == '\n') {
                c = ' ';
            }
            if (c == '\r') {
                c = ' ';
            }
            if (c != ' ') {
                result.append(c);
                flag = true;
            } else if (flag) {
                result.append(c);
                flag = false;
            }
            ++i;
        }
        if (!flag && result.length() != 0) {
            result.setLength(result.length() - 1);
        }
        return result.toString();
    }

    public static boolean checkMaxExclusive(Object number, long max) {
        if (number instanceof Integer) {
            return (long)((Integer)number).intValue() < max;
        }
        if (number instanceof Byte) {
            return (long)((Byte)number).byteValue() < max;
        }
        if (number instanceof Long) {
            return (Long)number < max;
        }
        if (number instanceof Short) {
            return (long)((Short)number).shortValue() < max;
        }
        return true;
    }

    public static boolean checkMaxInclusive(Object number, long max) {
        if (number instanceof Integer) {
            return (long)((Integer)number).intValue() <= max;
        }
        if (number instanceof Byte) {
            return (long)((Byte)number).byteValue() <= max;
        }
        if (number instanceof Long) {
            return (Long)number <= max;
        }
        if (number instanceof Short) {
            return (long)((Short)number).shortValue() <= max;
        }
        return true;
    }

    public static boolean checkMinExclusive(Object number, long min) {
        if (number instanceof Integer) {
            return (long)((Integer)number).intValue() > min;
        }
        if (number instanceof Byte) {
            return (long)((Byte)number).byteValue() > min;
        }
        if (number instanceof Long) {
            return (Long)number > min;
        }
        if (number instanceof Short) {
            return (long)((Short)number).shortValue() > min;
        }
        return true;
    }

    public static boolean checkMinInclusive(Object number, long min) {
        if (number instanceof Integer) {
            return (long)((Integer)number).intValue() >= min;
        }
        if (number instanceof Byte) {
            return (long)((Byte)number).byteValue() >= min;
        }
        if (number instanceof Long) {
            return (Long)number >= min;
        }
        if (number instanceof Short) {
            return (long)((Short)number).shortValue() >= min;
        }
        return true;
    }
}

