/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.encoding;

import com.sap.engine.services.webservices.jaxrpc.encoding.DeserializerBase;
import com.sap.engine.services.webservices.jaxrpc.encoding.InstanceCreator;
import java.rmi.UnmarshalException;

public class SOAPDeserializationState {
    private Object instance = null;
    private boolean complete = false;
    private DeserializerBase deserializer = null;
    private SOAPDeserializationState[] parentStates;
    private int[] parentIndex;
    private int[] parentSubIndex;
    private int parentCount = 0;
    private int topParent = 0;
    private InstanceCreator creator = null;
    private Class resultClass;

    private void resizeParents(int newParentCount) {
        if (this.parentCount == 0) {
            this.parentIndex = new int[newParentCount];
            this.parentSubIndex = new int[newParentCount];
            this.parentStates = new SOAPDeserializationState[newParentCount];
            this.parentCount = newParentCount;
            return;
        }
        if (newParentCount > this.parentCount) {
            newParentCount = (this.parentCount + 1) / 2 + newParentCount;
            int[] pIndexPerm = new int[newParentCount];
            int[] pSubIndexPerm = new int[newParentCount];
            SOAPDeserializationState[] pStatesPerm = new SOAPDeserializationState[newParentCount];
            System.arraycopy(this.parentIndex, 0, pIndexPerm, 0, this.parentCount);
            System.arraycopy(this.parentSubIndex, 0, pSubIndexPerm, 0, this.parentCount);
            System.arraycopy(this.parentStates, 0, pStatesPerm, 0, this.parentCount);
            this.parentIndex = pIndexPerm;
            this.parentSubIndex = pSubIndexPerm;
            this.parentStates = pStatesPerm;
            this.parentCount = newParentCount;
        }
    }

    public void setInstance(Object instance) throws UnmarshalException {
        this.instance = instance;
        this.complete = true;
        this.deserializer = null;
        this.creator = null;
        int i = 0;
        while (i < this.topParent) {
            this.parentStates[i].notify(instance, this.parentIndex[i], this.parentSubIndex[i]);
            ++i;
        }
        this.topParent = 0;
    }

    public Object getInstance() {
        return this.instance;
    }

    public void setDeserializer(DeserializerBase deserializer, Class resultClass) {
        this.resultClass = resultClass;
        this.deserializer = deserializer;
    }

    public DeserializerBase getDeserializer() {
        return this.deserializer;
    }

    public Class getResultClass() {
        return this.resultClass;
    }

    public void registerListener(SOAPDeserializationState parentState, int memberIndex, int memberSubindex) {
        if (this.topParent == this.parentCount) {
            this.resizeParents(this.parentCount + 1);
        }
        this.parentStates[this.topParent] = parentState;
        this.parentIndex[this.topParent] = memberIndex;
        this.parentSubIndex[this.topParent] = memberSubindex;
        ++this.topParent;
    }

    public void notify(Object instance, int memberIndex, int memberSubIndex) throws UnmarshalException {
        if (this.creator != null) {
            this.creator._setFieldObject(instance, memberIndex, memberSubIndex);
            if (this.creator.isCompleted()) {
                this.setInstance(this.creator.getResultObject());
            }
        }
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setInstanceCreator(InstanceCreator creator) {
        this.creator = creator;
    }

    public void doneReading() {
    }
}

