/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.encoding;

import com.sap.engine.services.webservices.jaxrpc.encoding.GeneratedSimpleType;
import com.sap.engine.services.webservices.jaxrpc.encoding.SerializationFactory;
import com.sap.engine.services.webservices.jaxrpc.encoding.SerializationFactoryImpl;
import com.sap.engine.services.webservices.jaxrpc.encoding.TypeMappingRegistryImpl;
import com.sap.engine.services.webservices.jaxrpc.encoding.XMLTypeMapping;
import com.sap.engine.services.webservices.jaxrpc.encoding.primitive.ArrayStruct;
import com.sap.engine.services.webservices.jaxrpc.exceptions.TypeMappingException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.namespace.QName;

public class SDFactoryRegistry
implements Serializable {
    private Hashtable qNameMap = new Hashtable();

    public SDFactoryRegistry() throws TypeMappingException {
        SerializationFactoryImpl factory2;
        SerializationFactoryImpl factory1;
        Hashtable<String, SerializationFactoryImpl> map1 = new Hashtable<String, SerializationFactoryImpl>();
        Hashtable<String, SerializationFactoryImpl> map2 = new Hashtable<String, SerializationFactoryImpl>();
        int i = 0;
        while (i < TypeMappingRegistryImpl.serializerNames.length) {
            String serializerName = TypeMappingRegistryImpl.serializerNames[i];
            if (!map1.containsKey(serializerName)) {
                factory1 = new SerializationFactoryImpl(serializerName);
                factory1.init(this.getClass().getClassLoader());
                map1.put(serializerName, factory1);
                if (factory1.getSerializer() instanceof GeneratedSimpleType) {
                    factory2 = new SerializationFactoryImpl(serializerName);
                    factory2.init(this.getClass().getClassLoader());
                    GeneratedSimpleType serializer = (GeneratedSimpleType)factory2.getSerializer();
                    serializer._setDefaultNamespace("http://schemas.xmlsoap.org/soap/encoding/");
                    map2.put(serializerName, factory2);
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < TypeMappingRegistryImpl.primitiveTypes.length) {
            factory1 = (SerializationFactoryImpl)map1.get(TypeMappingRegistryImpl.serializerNames[i2]);
            this.add(new QName("http://www.w3.org/2001/XMLSchema", TypeMappingRegistryImpl.primitiveTypes[i2]), factory1);
            factory2 = (SerializationFactoryImpl)map2.get(TypeMappingRegistryImpl.serializerNames[i2]);
            if (factory2 != null) {
                this.add(new QName("http://schemas.xmlsoap.org/soap/encoding/", TypeMappingRegistryImpl.primitiveTypes[i2]), factory2);
            }
            ++i2;
        }
        map1.clear();
        map2.clear();
        int i3 = 0;
        while (i3 < TypeMappingRegistryImpl.structureTypes.length) {
            String typeName = TypeMappingRegistryImpl.structureTypes[i3];
            String namespace = "java:sap/standard";
            QName qname = new QName(namespace, typeName);
            ArrayStruct serializer = new ArrayStruct(typeName);
            SerializationFactoryImpl factory = new SerializationFactoryImpl(qname, serializer, serializer);
            this.add(qname, factory);
            ++i3;
        }
    }

    public SerializationFactory add(QName xmlType, String sdClass) {
        XMLTypeMapping typeMapping = new XMLTypeMapping(xmlType, sdClass, sdClass);
        this.qNameMap.put(xmlType, typeMapping);
        return typeMapping.getDefaultFactory();
    }

    public SerializationFactory add(QName xmlType, SerializationFactory factory) {
        XMLTypeMapping typeMapping = new XMLTypeMapping(xmlType, factory);
        this.qNameMap.put(xmlType, typeMapping);
        return typeMapping.getDefaultFactory();
    }

    public SerializationFactory add(QName xmlType, SerializationFactory factory, String javaClass) {
        XMLTypeMapping typeMapping = (XMLTypeMapping)this.qNameMap.get(xmlType);
        if (typeMapping == null) {
            typeMapping = new XMLTypeMapping(xmlType, null);
            typeMapping.addFactory(javaClass, factory);
            this.qNameMap.put(xmlType, typeMapping);
        } else {
            typeMapping.addFactory(javaClass, factory);
        }
        return typeMapping.getFactory(javaClass);
    }

    public void remove(QName xmlType) {
        this.qNameMap.remove(xmlType);
    }

    public XMLTypeMapping getAll(QName xmlType) {
        return (XMLTypeMapping)this.qNameMap.get(xmlType);
    }

    public SerializationFactory get(String javaName, QName xmlType) {
        XMLTypeMapping typeMapping = (XMLTypeMapping)this.qNameMap.get(xmlType);
        if (typeMapping != null) {
            return typeMapping.getFactory(javaName);
        }
        return null;
    }

    public SerializationFactory get(Class javaName, QName xmlType) {
        XMLTypeMapping typeMapping = (XMLTypeMapping)this.qNameMap.get(xmlType);
        if (typeMapping != null) {
            return typeMapping.getFactory(javaName);
        }
        return null;
    }

    public void addAll(QName xmlName, XMLTypeMapping mapping) {
        if (mapping != null) {
            this.qNameMap.put(xmlName, mapping);
        }
    }

    public Enumeration getRegisteredXMLTypes() {
        return this.qNameMap.keys();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        Enumeration keys = this.qNameMap.keys();
        while (keys.hasMoreElements()) {
            result.append(keys.nextElement().toString());
            result.append("\n");
        }
        return result.toString();
    }

    public void clear() {
        this.qNameMap.clear();
    }
}

