/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.encoding;

import com.sap.engine.lib.xml.parser.ParserException;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenReader;
import com.sap.engine.services.webservices.jaxrpc.encoding.DeserializerBase;
import com.sap.engine.services.webservices.jaxrpc.encoding.InstanceCreator;
import com.sap.engine.services.webservices.jaxrpc.encoding.SOAPDeserializationContext;
import com.sap.engine.services.webservices.jaxrpc.encoding.SOAPDeserializationState;
import com.sap.engine.services.webservices.jaxrpc.encoding.primitive.ArrayIterator;
import com.sap.engine.services.webservices.jaxrpc.exceptions.XmlUnmarshalException;
import java.lang.reflect.Array;
import java.rmi.UnmarshalException;

public class ArrayBuilder
implements InstanceCreator {
    private Class resultComponentClass;
    private Object result;
    private SOAPDeserializationContext context;
    private DeserializerBase deserializer;
    private SOAPDeserializationState state;
    private boolean complete = true;
    private int[] arrayDimensions;
    private int[] arrayPosition;
    private int lefttoload = 0;
    private ArrayIterator iterator;
    public static int POOL_COUNT = 5;
    private static ArrayBuilder[] array = new ArrayBuilder[POOL_COUNT];
    private static int used = 0;

    public ArrayBuilder(Class resultComponentClass, int[] arrayDimensions, SOAPDeserializationContext context, DeserializerBase deserializer) {
        this.deserializer = deserializer;
        this.resultComponentClass = resultComponentClass;
        this.arrayDimensions = arrayDimensions;
        this.arrayPosition = new int[arrayDimensions.length];
        this.context = context;
    }

    public void init(Class resultComponentClass, int[] arrayDimensions, SOAPDeserializationContext context, DeserializerBase deserializer) {
        this.result = null;
        this.deserializer = deserializer;
        this.resultComponentClass = resultComponentClass;
        this.arrayDimensions = arrayDimensions;
        this.arrayPosition = new int[arrayDimensions.length];
        this.context = context;
    }

    public static synchronized ArrayBuilder getArrayBuilder(Class resultComponentClass, int[] arrayDimensions, SOAPDeserializationContext context, DeserializerBase deserializer) {
        if (used == 0) {
            return new ArrayBuilder(resultComponentClass, arrayDimensions, context, deserializer);
        }
        ArrayBuilder.array[--ArrayBuilder.used].deserializer = deserializer;
        ArrayBuilder.array[ArrayBuilder.used].resultComponentClass = resultComponentClass;
        ArrayBuilder.array[ArrayBuilder.used].arrayDimensions = arrayDimensions;
        ArrayBuilder.array[ArrayBuilder.used].arrayPosition = new int[arrayDimensions.length];
        ArrayBuilder.array[ArrayBuilder.used].context = context;
        return array[used];
    }

    public static synchronized void reuse(ArrayBuilder builder) {
        if (used < POOL_COUNT) {
            builder.result = null;
            builder.iterator = null;
            ArrayBuilder.array[ArrayBuilder.used] = builder;
            ++used;
        }
    }

    public static void printContent() {
        System.out.println(used);
    }

    public void _setFieldObject(Object instance, int index, int subindex) throws UnmarshalException {
        int i = 0;
        while (i < this.arrayDimensions.length) {
            this.arrayPosition[this.arrayDimensions.length - i - 1] = index % this.arrayDimensions[i];
            index /= this.arrayDimensions[i];
            ++i;
        }
        Object curArr = this.result;
        int i2 = 0;
        while (i2 < this.arrayDimensions.length - 1) {
            curArr = Array.get(curArr, this.arrayPosition[i2]);
            ++i2;
        }
        Array.set(curArr, this.arrayPosition[i2], instance);
        --this.lefttoload;
        if (this.lefttoload == 0) {
            this.complete = true;
        }
    }

    public void setArrayIterator(ArrayIterator iterator) {
        this.iterator = iterator;
    }

    public boolean readContent(XMLTokenReader reader) throws UnmarshalException {
        try {
            reader.passChars();
        }
        catch (ParserException p) {
            throw new XmlUnmarshalException("webservices_3125", p);
        }
        int fieldIndex = 0;
        this.complete = true;
        while (reader.getState() == 1) {
            Object content = this.deserializer.deserialize(reader, this.context, this.resultComponentClass);
            if (!this.iterator.hasMoreElements()) {
                throw new XmlUnmarshalException("webservices_3131");
            }
            if (content == null) {
                this.iterator.setNext(null);
            } else if (content instanceof SOAPDeserializationState) {
                SOAPDeserializationState cState = (SOAPDeserializationState)content;
                if (cState.isComplete()) {
                    this.iterator.setNext(cState.getInstance());
                } else {
                    this.complete = false;
                    if (this.state == null) {
                        this.state = new SOAPDeserializationState();
                        this.state.setInstanceCreator(this);
                    }
                    cState.registerListener(this.state, fieldIndex, 0);
                    ++this.lefttoload;
                    this.iterator.nextPosition();
                }
            } else {
                this.iterator.setNext(content);
            }
            try {
                reader.next();
                reader.passChars();
            }
            catch (ParserException p) {
                throw new XmlUnmarshalException("webservices_3125", p);
            }
            ++fieldIndex;
        }
        if (this.iterator.hasMoreElements()) {
            throw new XmlUnmarshalException("webservices_3131");
        }
        this.result = this.iterator.getArray();
        return this.complete;
    }

    public boolean isCompleted() {
        return this.complete;
    }

    public SOAPDeserializationState getState() {
        return this.state;
    }

    public void setState(SOAPDeserializationState state) {
        state.setInstanceCreator(this);
        this.state = state;
    }

    public Object getResultObject() {
        return this.result;
    }
}

