/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxm.soap;

import com.sap.engine.lib.xml.util.NestedIOException;
import com.sap.engine.services.webservices.jaxm.soap.AttachmentPartImpl;
import com.sap.engine.services.webservices.jaxm.soap.IteratorImpl;
import com.sap.engine.services.webservices.jaxm.soap.MimeMatchingIterator;
import com.sap.engine.services.webservices.jaxm.soap.SAPSoapException;
import com.sap.engine.services.webservices.jaxm.soap.SOAPPartImpl;
import com.sap.engine.services.webservices.jaxm.soap.accessor.NestedSOAPException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParameterList;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class SOAPMessageImpl
extends SOAPMessage {
    private Vector attachments = null;
    private SOAPPartImpl soapPart = null;
    private MimeHeaders headers = null;
    private boolean committed = false;
    private byte[] messageBytes = null;
    private int messageByteCount = 0;
    private ByteArrayOutputStream byteoutputstream = null;
    private static final IteratorImpl emptyIterator = new IteratorImpl();

    public SOAPMessageImpl() {
        this.headers = new MimeHeaders();
        this.committed = false;
        this.messageBytes = null;
        this.messageByteCount = 0;
        this.byteoutputstream = new ByteArrayOutputStream();
    }

    public SOAPMessageImpl(MimeHeaders mimeheaders, final InputStream in) throws IOException, SOAPException {
        this.committed = false;
        this.headers = mimeheaders;
        this.messageBytes = null;
        this.messageByteCount = 0;
        this.byteoutputstream = new ByteArrayOutputStream();
        final String ct = this.getContentType();
        if (ct == null) {
            throw new NestedSOAPException("webservices_3712", "null");
        }
        try {
            ContentType contenttype = new ContentType(ct);
            int i = this.verify(contenttype);
            if (i == 1) {
                String[] contentEncoding = this.headers.getHeader("Content-Encoding");
                if (contentEncoding != null && contentEncoding.length >= 1 && "gzip".equals(contentEncoding[0])) {
                    GZIPInputStream compressedInput = new GZIPInputStream(in);
                    this.getSOAPPart().setContent((Source)new StreamSource(compressedInput));
                } else {
                    this.getSOAPPart().setContent((Source)new StreamSource(in));
                }
            } else {
                MimeMultipart mimemultipart = new MimeMultipart(new DataSource(){

                    public String getContentType() {
                        return ct;
                    }

                    public InputStream getInputStream() {
                        return in;
                    }

                    public String getName() {
                        return "";
                    }

                    public OutputStream getOutputStream() {
                        return null;
                    }
                });
                MimeBodyPart mimebodypart = (MimeBodyPart)mimemultipart.getBodyPart(0);
                if (mimebodypart.getContentType().toUpperCase().indexOf("TEXT/XML") != -1) {
                    SOAPPart part = this.getSOAPPart();
                    part.removeAllMimeHeaders();
                    Enumeration enumeration = mimebodypart.getAllHeaders();
                    while (enumeration.hasMoreElements()) {
                        Header header = (Header)enumeration.nextElement();
                        part.setMimeHeader(header.getName(), header.getValue());
                    }
                    part.setContent((Source)new StreamSource(mimebodypart.getInputStream()));
                    int j = 1;
                    while (j < mimemultipart.getCount()) {
                        MimeBodyPart mimebodypart1 = (MimeBodyPart)mimemultipart.getBodyPart(j);
                        AttachmentPartImpl attachmentpartimpl = new AttachmentPartImpl();
                        attachmentpartimpl.setContent(mimebodypart1.getContent(), mimebodypart1.getContentType());
                        Enumeration en = mimebodypart1.getAllHeaders();
                        while (en.hasMoreElements()) {
                            Header temp = (Header)en.nextElement();
                            attachmentpartimpl.setMimeHeader(temp.getName(), temp.getValue());
                        }
                        this.addAttachmentPart(attachmentpartimpl);
                        ++j;
                    }
                    this.committed = false;
                } else {
                    int j = 0;
                    while (j < mimemultipart.getCount()) {
                        MimeBodyPart mimebodypart1 = (MimeBodyPart)mimemultipart.getBodyPart(j);
                        AttachmentPartImpl attachmentpartimpl = new AttachmentPartImpl();
                        Enumeration en = mimebodypart1.getAllHeaders();
                        while (en.hasMoreElements()) {
                            Header temp = (Header)en.nextElement();
                            attachmentpartimpl.setMimeHeader(temp.getName(), temp.getValue());
                            attachmentpartimpl.setDataHandler(mimebodypart1.getDataHandler());
                        }
                        this.addAttachmentPart(attachmentpartimpl);
                        ++j;
                    }
                }
            }
        }
        catch (Exception throwable) {
            if (throwable instanceof SOAPException) {
                throw (SOAPException)throwable;
            }
            throw new NestedSOAPException("webservices_3706", throwable);
        }
    }

    public String getSOAPAction() {
        String[] soapActionHeaders = this.headers.getHeader("SOAPAction");
        if (soapActionHeaders != null && soapActionHeaders.length > 0) {
            return soapActionHeaders[soapActionHeaders.length - 1];
        }
        return null;
    }

    public void reuse() {
        if (this.attachments != null) {
            this.attachments.clear();
        }
        if (this.soapPart != null) {
            this.soapPart.reuse();
        }
        this.headers.removeAllHeaders();
        this.committed = false;
        this.messageBytes = null;
        this.messageByteCount = 0;
        this.byteoutputstream.reset();
        if (this.soapPart != null) {
            this.soapPart.reuse();
        }
    }

    public void setSOAPAction(String soapAction) {
        this.headers.setHeader("SOAPAction", "\"" + soapAction + "\"");
    }

    public void addAttachmentPart(AttachmentPart attachmentpart) {
        if (this.attachments == null) {
            this.attachments = new Vector();
        }
        this.attachments.addElement(attachmentpart);
        this.needsSave();
    }

    public int countAttachments() {
        if (this.attachments != null) {
            return this.attachments.size();
        }
        return 0;
    }

    public AttachmentPart createAttachmentPart() {
        return new AttachmentPartImpl();
    }

    public Iterator getAttachments() {
        if (this.attachments == null) {
            return emptyIterator;
        }
        return ((AbstractList)this.attachments).iterator();
    }

    public Iterator getAttachments(MimeHeaders mimeheaders) {
        if (this.attachments == null) {
            return emptyIterator;
        }
        return new MimeMatchingIterator(mimeheaders, this.attachments);
    }

    public String getContentDescription() {
        String[] as = this.headers.getHeader("Content-Description");
        if (as.length > 0) {
            return as[0];
        }
        return null;
    }

    public MimeHeaders getMimeHeaders() {
        return this.headers;
    }

    public SOAPPart getSOAPPart() {
        if (this.soapPart == null) {
            this.soapPart = new SOAPPartImpl();
        }
        return this.soapPart;
    }

    public void removeAllAttachments() {
        if (this.attachments != null) {
            this.attachments.removeAllElements();
            this.needsSave();
        }
    }

    public void setHTTPHeader(String name, String value) {
        this.headers.addHeader(name, value);
    }

    public void setCookie(String value) {
        this.headers.addHeader("Cookie", value);
    }

    private final void needsSave() {
        this.committed = false;
    }

    public synchronized boolean saveRequired() {
        return !this.committed;
    }

    public synchronized void saveChanges() throws SOAPException {
        if (this.countAttachments() == 0) {
            this.byteoutputstream.reset();
            String[] contentEncoding = this.headers.getHeader("Content-Encoding");
            if (contentEncoding != null && contentEncoding.length >= 1 && "gzip".equals(contentEncoding[0])) {
                try {
                    GZIPOutputStream compressedOutput = new GZIPOutputStream(this.byteoutputstream);
                    ((SOAPPartImpl)this.getSOAPPart()).writeTo(compressedOutput);
                    compressedOutput.finish();
                }
                catch (IOException e) {
                    throw new SAPSoapException("Unable to open output stream.", e);
                }
            } else {
                ((SOAPPartImpl)this.getSOAPPart()).writeTo(this.byteoutputstream);
            }
            this.messageBytes = this.byteoutputstream.toByteArray();
            this.messageByteCount = this.byteoutputstream.size();
            this.headers.setHeader("Content-Type", "text/xml; charset=UTF-8");
            this.headers.setHeader("Content-Length", Integer.toString(this.messageByteCount));
        } else {
            this.byteoutputstream.reset();
            this.headers.setHeader("Content-Type", "multipart/related");
            try {
                this.getMimeMessage().writeTo((OutputStream)this.byteoutputstream);
            }
            catch (IOException e) {
                throw new NestedSOAPException("webservices_3709", e);
            }
            catch (MessagingException e) {
                throw new NestedSOAPException("webservices_3710", e);
            }
            catch (SOAPException e) {
                throw e;
            }
            this.messageBytes = this.byteoutputstream.toByteArray();
            this.messageByteCount = this.byteoutputstream.size();
            this.headers.setHeader("Content-Length", Integer.toString(this.messageByteCount));
        }
        this.committed = true;
    }

    public void setContentDescription(String s) {
        this.headers.setHeader("Content-Description", s);
        this.needsSave();
    }

    public int getContentLength() throws IOException {
        try {
            if (this.saveRequired()) {
                this.saveChanges();
            }
        }
        catch (SOAPException soapexception) {
            throw new IOException("SOAPException: " + soapexception.getMessage());
        }
        this.needsSave();
        return this.messageByteCount;
    }

    public void writeTo(OutputStream outputstream) throws IOException {
        try {
            if (this.saveRequired()) {
                this.saveChanges();
            }
        }
        catch (SOAPException soapexception) {
            throw new NestedIOException("Unable to output message.", (Throwable)soapexception);
        }
        outputstream.write(this.messageBytes, 0, this.messageByteCount);
        this.messageBytes = null;
        this.needsSave();
    }

    private int verify(ContentType contenttype) throws SOAPException {
        String s = contenttype.getPrimaryType();
        String s1 = contenttype.getSubType();
        if (s.equalsIgnoreCase("multipart") && s1.equalsIgnoreCase("related")) {
            return 3;
        }
        if (!s.equalsIgnoreCase("multipart") && s.equalsIgnoreCase("text") && s1.equalsIgnoreCase("xml")) {
            return 1;
        }
        throw new NestedSOAPException("webservices_3712", s + "/" + s1);
    }

    String getContentType() {
        String[] as = this.headers.getHeader("Content-Type");
        if (as != null && as.length == 1) {
            return as[0];
        }
        return null;
    }

    private MimeMultipart getMimeMessage() throws SOAPException {
        try {
            MimeMultipart mimemultipart = new MimeMultipart();
            if (this.soapPart != null) {
                mimemultipart.addBodyPart((BodyPart)this.soapPart.getMimePart());
            }
            Iterator iterator = this.getAttachments();
            while (iterator.hasNext()) {
                mimemultipart.addBodyPart((BodyPart)((AttachmentPartImpl)((Object)iterator.next())).getMimePart());
            }
            ContentType contenttype = new ContentType(mimemultipart.getContentType());
            ParameterList parameterlist = new ParameterList();
            parameterlist.set("type", "text/xml");
            parameterlist.set("boundary", contenttype.getParameter("boundary"));
            ContentType contenttype1 = new ContentType("multipart", "related", parameterlist);
            this.headers.setHeader("Content-Type", contenttype1.toString());
            return mimemultipart;
        }
        catch (SOAPException soapexception) {
            throw soapexception;
        }
        catch (Throwable throwable) {
            throw new NestedSOAPException("webservices_3713", throwable);
        }
    }

    public SOAPBody getSOAPBody() throws SOAPException {
        SOAPPart part = this.getSOAPPart();
        if (part == null) {
            return null;
        }
        SOAPEnvelope envelope = part.getEnvelope();
        if (envelope == null) {
            return null;
        }
        return envelope.getBody();
    }

    public SOAPHeader getSOAPHeader() throws SOAPException {
        SOAPPart part = this.getSOAPPart();
        if (part == null) {
            return null;
        }
        SOAPEnvelope envelope = part.getEnvelope();
        if (envelope == null) {
            return null;
        }
        return envelope.getHeader();
    }
}

