/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxm.soap;

import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;

public class SOAPFaultException
extends SOAPException {
    protected String fcode = null;
    protected String fstring = null;
    protected SOAPElement fdetail = null;
    protected String factor = null;
    protected Throwable fthrowable = null;

    public SOAPFaultException(String fcode, String fstring, String factor, SOAPElement fdetail, Throwable t) {
        super(fstring, t);
        this.fcode = fcode;
        this.fstring = fstring;
        this.fdetail = fdetail;
        this.factor = factor;
        this.fthrowable = t;
    }

    public SOAPFaultException(String fcode, String fstring, String factor, SOAPElement fdetail) {
        super(fstring);
        this.fcode = fcode;
        this.fstring = fstring;
        this.fdetail = fdetail;
        this.factor = factor;
    }

    public SOAPFaultException(String fcode, String fstring, String factor, Throwable t) {
        super(fstring, t);
        this.fcode = fcode;
        this.fstring = fstring;
        this.factor = factor;
        this.fdetail = null;
        this.fthrowable = t;
    }

    public SOAPFaultException(String fcode, String fstring, String factor) {
        super(fstring);
        this.fcode = fcode;
        this.fstring = fstring;
        this.factor = factor;
        this.fdetail = null;
    }

    public SOAPFaultException(String fstring, Throwable t) {
        this("SOAP-ENV:Server", fstring, fstring, t);
    }

    public SOAPFaultException(String fstring) {
        this("SOAP-ENV:Server", fstring, fstring);
    }

    public String getFaultActor() {
        return this.factor;
    }

    public String getFaultCode() {
        return this.fcode;
    }

    public String getFaultString() {
        return this.fstring;
    }

    public SOAPElement getFaultDetail() {
        return this.fdetail;
    }

    public Throwable getFaultException() {
        return this.fthrowable;
    }

    public SOAPMessage toSOAPFaultMessage(MessageFactory mfact) throws SOAPException {
        SOAPMessage message = mfact.createMessage();
        SOAPPart part = message.getSOAPPart();
        SOAPEnvelope envelope = part.getEnvelope();
        SOAPBody body = envelope.getBody();
        SOAPFault fault = body.addFault();
        fault.setFaultCode(this.fcode);
        fault.setFaultString(this.fstring);
        fault.setFaultActor(this.factor);
        if (this.fdetail != null) {
            fault.addDetail().addChildElement(this.fdetail);
        }
        return message;
    }
}

