/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxm.soap;

import com.sap.engine.lib.xml.dom.DocumentImpl;
import com.sap.engine.services.webservices.jaxm.soap.SOAPBodyImpl;
import com.sap.engine.services.webservices.jaxm.soap.SOAPElementImpl;
import com.sap.engine.services.webservices.jaxm.soap.SOAPEnvelopeImpl;
import com.sap.engine.services.webservices.jaxm.soap.SOAPFaultImpl;
import com.sap.engine.services.webservices.jaxm.soap.SOAPHeaderImpl;
import com.sap.engine.services.webservices.jaxm.soap.SOAPPool;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class SOAPDocumentImpl
extends DocumentImpl {
    private SOAPBodyImpl body = null;
    private SOAPEnvelopeImpl envelope = null;
    private SOAPHeaderImpl header = null;
    private SOAPFaultImpl fault = null;
    public SOAPPool pool = new SOAPPool();

    public final Element createElement(String tagName) {
        return this.pool.createElement((Document)((Object)this), tagName);
    }

    public final Element createElementNS(String namespaceURI, String qualifiedName) {
        SOAPElementImpl result = this.pool.createElementNS((Document)((Object)this), namespaceURI, qualifiedName);
        if (result instanceof SOAPBodyImpl) {
            if (this.body != null) {
                throw new RuntimeException("The SOAP message already has a SOAP Body.");
            }
            this.body = (SOAPBodyImpl)result;
        }
        if (result instanceof SOAPEnvelopeImpl) {
            if (this.envelope != null) {
                throw new RuntimeException("The SOAP message already has a SOAP Envelope.");
            }
            this.envelope = (SOAPEnvelopeImpl)result;
        }
        if (result instanceof SOAPHeaderImpl) {
            if (this.header != null) {
                throw new RuntimeException("The SOAP message already has a SOAP Header.");
            }
            this.header = (SOAPHeaderImpl)result;
        }
        if (result instanceof SOAPFaultImpl) {
            if (this.fault != null) {
                throw new RuntimeException("The SOAP message already has a SOAP Fault.");
            }
            this.fault = (SOAPFaultImpl)result;
        }
        return result;
    }

    public final CDATASection createCDATASection(String content) {
        return this.pool.createTextNode((Document)((Object)this), content, false);
    }

    public final Comment createComment(String content) {
        return this.pool.createTextNode((Document)((Object)this), content, true);
    }

    public final DocumentFragment createDocumentFragment() {
        throw new RuntimeException("Document fragment can not exist in SOAP message.");
    }

    public final EntityReference createEntityReference(String content) {
        throw new RuntimeException("Entity regerence node cannot appear in SOAP message.");
    }

    public final ProcessingInstruction createProcessingInstruction(String s1, String s2) {
        throw new RuntimeException("Processing Instruction can not appear inside SOAP message.");
    }

    public final Text createTextNode(String content) {
        return this.pool.createTextNode((Document)((Object)this), content, false);
    }

    public final SOAPDocumentImpl init(Element root) {
        super.init(root, null);
        this.body = null;
        this.envelope = null;
        this.header = null;
        this.fault = null;
        return this;
    }
}

