/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxm.soap;

import com.sap.engine.services.webservices.jaxm.soap.SOAPMessageImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;

public class MessageFactoryImpl
extends MessageFactory {
    public SOAPMessage createMessage() throws SOAPException {
        return new SOAPMessageImpl();
    }

    public SOAPMessage createMessage(InputStream inputstream) throws IOException, SOAPException {
        MimeHeaders mimeheaders = new MimeHeaders();
        mimeheaders.setHeader("Content-Type", "text/xml");
        SOAPMessage message = this.createMessage(mimeheaders, inputstream);
        return message;
    }

    public SOAPMessage createMessage(MimeHeaders mimeheaders, InputStream inputstream) throws IOException, SOAPException {
        return new SOAPMessageImpl(mimeheaders, inputstream);
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Chavdar Test");
        System.setProperty("javax.xml.soap.MessageFactory", "com.sap.engine.services.webservices.jaxm.soap.MessageFactoryImpl");
        MessageFactory mf = MessageFactory.newInstance();
        SOAPMessage message = mf.createMessage();
        SOAPPart part = message.getSOAPPart();
        SOAPEnvelope envelope = part.getEnvelope();
        SOAPBody body = envelope.getBody();
        SOAPElement elem1 = body.addChildElement("Element", "a", "AnyURI");
        SOAPElement elem2 = elem1.addChildElement("Element2", "a", "AnyURI");
        System.out.println("The SOAP Message");
        Iterator it = elem2.getNamespacePrefixes();
        System.out.println("List of namespaces for element " + elem2.getElementName().getQualifiedName());
        while (it.hasNext()) {
            String prefix = (String)it.next();
            String URI2 = elem2.getNamespaceURI(prefix);
            System.out.println("Prefix: " + prefix + ", URI: " + URI2);
        }
        System.out.println("Finished");
        message.writeTo((OutputStream)System.out);
    }
}

