/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.PatternSet;

public class ZipChecker
extends Task {
    private File m_zipFile = null;
    private Vector m_additionalPatterns = new Vector();

    public void setZipfile(File zipFile) {
        this.m_zipFile = zipFile;
    }

    public PatternSet createPatternSet() {
        PatternSet patterns = new PatternSet();
        this.m_additionalPatterns.addElement(patterns);
        return patterns;
    }

    public void execute() throws BuildException {
        if (!this.m_zipFile.exists()) {
            throw new BuildException("File doesn't exist: " + this.m_zipFile.getAbsolutePath());
        }
        Project p = this.getProject();
        p.log("Checking file '" + this.m_zipFile.getName() + "'", 2);
        PatternHelper ph = new PatternHelper();
        Enumeration patterns = this.m_additionalPatterns.elements();
        while (patterns.hasMoreElements()) {
            PatternSet ps = (PatternSet)patterns.nextElement();
            ph.addIncludes(ps.getIncludePatterns(p));
            ph.addExcludes(ps.getExcludePatterns(p));
        }
        ZipFile zf = null;
        try {
            zf = new ZipFile(this.m_zipFile);
        }
        catch (IOException e) {
            throw new BuildException("Couldn't open ZipFile", (Throwable)e);
        }
        Enumeration<? extends ZipEntry> entries = zf.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            String name = entry.getName();
            p.log("Checking ZipEntry '" + name + "'", 3);
            String pattern = ph.match(name);
            if (pattern == null) continue;
            throw new BuildException("File '" + name + "' in archive '" + this.m_zipFile + "' matched exclude pattern '" + pattern + "'");
        }
        String[] unsatisfieds = ph.getUnsatisfiedIncludes();
        if (unsatisfieds != null && unsatisfieds.length > 0) {
            StringBuffer sb = new StringBuffer("No file from archive " + this.m_zipFile + " matched these include patterns: ");
            int i = 0;
            while (i < unsatisfieds.length) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append('\"');
                sb.append(unsatisfieds[i]);
                sb.append('\"');
                ++i;
            }
            throw new BuildException(sb.toString());
        }
    }

    private class PatternHelper
    extends DirectoryScanner {
        private Vector m_includes = new Vector();
        private Vector m_excludes = new Vector();
        private boolean[] m_includesSatisfied;

        public void addIncludes(String[] patterns) {
            if (patterns != null) {
                int i = 0;
                while (i < patterns.length) {
                    this.m_includes.addElement(patterns[i]);
                    ++i;
                }
            }
        }

        public void addExcludes(String[] patterns) {
            if (patterns != null) {
                int i = 0;
                while (i < patterns.length) {
                    this.m_excludes.addElement(patterns[i]);
                    ++i;
                }
            }
        }

        public String match(String name) {
            if (this.m_includesSatisfied == null) {
                this.m_includesSatisfied = new boolean[this.m_includes.size()];
            }
            Project p = ZipChecker.this.getProject();
            int msgLevel = 3;
            int i = 0;
            while (i < this.m_includes.size()) {
                String pattern = (String)this.m_includes.elementAt(i);
                if (DirectoryScanner.matchPath((String)pattern, (String)name)) {
                    p.log("Name '" + name + "' matched include pattern '" + pattern + "'", msgLevel);
                    this.m_includesSatisfied[i] = true;
                    return null;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < this.m_excludes.size()) {
                String pattern = (String)this.m_excludes.elementAt(i2);
                if (DirectoryScanner.matchPath((String)pattern, (String)name)) {
                    p.log("Name '" + name + "' matched exclude pattern '" + pattern + "'", msgLevel);
                    return pattern;
                }
                ++i2;
            }
            p.log("Name '" + name + "' didn't match any include or exclude pattern.", msgLevel);
            return null;
        }

        public String[] getUnsatisfiedIncludes() {
            if (this.m_includesSatisfied == null) {
                return null;
            }
            int num = 0;
            int i = 0;
            while (i < this.m_includesSatisfied.length) {
                if (!this.m_includesSatisfied[i]) {
                    ++num;
                }
                ++i;
            }
            String[] result = new String[num];
            num = 0;
            int i2 = 0;
            while (i2 < this.m_includesSatisfied.length) {
                if (!this.m_includesSatisfied[i2]) {
                    result[num] = (String)this.m_includes.get(i2);
                    ++num;
                }
                ++i2;
            }
            return result;
        }
    }
}

