/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class EmptyJarErasor
extends Task {
    private File m_zipFile = null;

    public void setJarfile(File zipFile) {
        this.m_zipFile = zipFile;
    }

    public void execute() throws BuildException {
        if (!this.m_zipFile.exists()) {
            throw new BuildException("File doesn't exist: " + this.m_zipFile.getAbsolutePath());
        }
        ZipFile zf = null;
        try {
            zf = new ZipFile(this.m_zipFile);
        }
        catch (IOException e) {
            this.deleteFile("invalid");
            return;
        }
        if (this.isEmptyJar(zf)) {
            this.deleteFile("empty");
        }
    }

    private void deleteFile(String reason) {
        Project p = this.getProject();
        p.log("Deleting " + reason + " jar '" + this.m_zipFile.getName() + "'", 2);
        if (!this.m_zipFile.delete()) {
            p.log("Failed to delete empty jar file '" + this.m_zipFile.getAbsolutePath() + "'", 1);
        }
    }

    private boolean isEmptyJar(ZipFile zf) {
        Project p = this.getProject();
        Enumeration<? extends ZipEntry> entries = zf.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            if (name.startsWith("META-INF/")) continue;
            EmptyJarErasor.closeZipFile(zf);
            return false;
        }
        EmptyJarErasor.closeZipFile(zf);
        return true;
    }

    private static void closeZipFile(ZipFile zf) {
        if (zf != null) {
            try {
                zf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

