/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.buildplugin.util;

import com.sap.s2x.S2XDocument;
import com.sap.s2x.etc.TranslationUnit;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class XlfWrapper {
    private File xlfFile;
    private String originalLocale;
    private String sourceLocale;
    private Properties ivProperties;
    private boolean valid;
    private transient String ivBaseName;
    private transient String ivLocaleSuffix;

    public XlfWrapper(File xlfFile) throws Exception {
        this.xlfFile = xlfFile;
        this.readS2X();
        this.ivBaseName = xlfFile.getName();
        int len = this.ivBaseName.length();
        if (".xlf".equalsIgnoreCase(this.ivBaseName.substring(len - 4))) {
            this.ivBaseName = this.ivBaseName.substring(0, len - 4);
            len -= 4;
        }
        this.ivLocaleSuffix = "";
        if (this.sourceLocale != null) {
            if (this.ivBaseName.endsWith(this.sourceLocale)) {
                this.ivBaseName = this.ivBaseName.substring(0, len - this.sourceLocale.length() - 1);
            } else if (len > 3 && this.ivBaseName.charAt(len - 3) == '_') {
                if (len > 6 && this.ivBaseName.charAt(len - 6) == '_') {
                    this.ivLocaleSuffix = this.ivBaseName.substring(len - 5);
                    this.ivBaseName = this.ivBaseName.substring(0, len - 6);
                    len -= 6;
                } else {
                    this.ivLocaleSuffix = this.ivBaseName.substring(len - 2);
                    this.ivBaseName = this.ivBaseName.substring(0, len - 3);
                    len -= 3;
                }
            }
        }
    }

    public String getBaseName() {
        return this.ivBaseName;
    }

    public String getLocaleSuffix() {
        return this.ivLocaleSuffix;
    }

    private void readS2X() throws Exception {
        S2XDocument s2xDoc = new S2XDocument(this.xlfFile, 2, false);
        this.originalLocale = s2xDoc.getOriginalLocale();
        this.sourceLocale = s2xDoc.getSourceLanguage();
        this.valid = s2xDoc.isValid();
        this.ivProperties = new Properties();
        Vector texts = s2xDoc.getTexts();
        Enumeration enumeration = texts.elements();
        while (enumeration.hasMoreElements()) {
            TranslationUnit unit = (TranslationUnit)enumeration.nextElement();
            String key = unit.getResname();
            String value = unit.getSource();
            value = XlfWrapper.repairForMessageFormat(value, "'", "''");
            ((Hashtable)this.ivProperties).put(key, value);
        }
    }

    public Properties getProperties() {
        return this.ivProperties;
    }

    public String getOriginalLocale() {
        return this.originalLocale;
    }

    public String getSourceLocale() {
        return this.sourceLocale;
    }

    public boolean isValid() {
        return this.valid;
    }

    private static String repairForMessageFormat(String source, String orig_str, String change_str) {
        StringBuffer after_replacement = null;
        boolean has_specstr = false;
        int pos_start = 0;
        int pos_end = 0;
        int former_start = 0;
        int origLen = orig_str.length();
        while ((pos_start = source.indexOf(123, 0)) >= 0 && (pos_end = source.indexOf(125, pos_start)) > 0) {
            has_specstr = true;
            if (after_replacement == null) {
                after_replacement = new StringBuffer(source.length() + 10);
            }
            String former = source.substring(0, pos_start);
            String part_filter = source.substring(pos_start, pos_end + 1);
            source = source.substring(pos_end + 1);
            while ((former_start = former.indexOf(orig_str)) >= 0) {
                after_replacement.append(former.substring(0, former_start));
                after_replacement.append(change_str);
                former = former.substring(former_start + origLen);
            }
            after_replacement.append(former);
            after_replacement.append(part_filter);
        }
        if (has_specstr) {
            while ((former_start = source.indexOf(orig_str)) >= 0) {
                after_replacement.append(source.substring(0, former_start));
                after_replacement.append(change_str);
                source = source.substring(former_start + origLen);
            }
            after_replacement.append(source);
            source = new String(after_replacement);
        }
        return source;
    }
}

