/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.buildplugin.util;

import com.sap.tc.buildplugin.util.XlfWrapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;

public class XlfConverter
extends MatchingTask {
    private File dir;
    private File toDir;
    private String ivHeader;
    private String ivCopyMaster;
    private static final String PROP_SUFFIX = ".properties";
    private static final char SUFFIX_SEPARATOR = '.';

    public XlfConverter() {
        this.createInclude().setName("**/*.xlf");
    }

    public void setDir(File f) {
        this.dir = f;
    }

    public void setToDir(File f) {
        this.toDir = f;
    }

    public void setHeader(String header) {
        this.ivHeader = header;
    }

    public void setCopyMaster(String locale) {
        this.ivCopyMaster = locale;
    }

    public void execute() throws BuildException {
        if (this.toDir == null) {
            this.toDir = this.dir;
        }
        if (!this.toDir.exists()) {
            throw new BuildException("Directory does not exist: " + this.toDir.getAbsolutePath());
        }
        if (!this.toDir.isDirectory()) {
            throw new BuildException("Not a directory: " + this.toDir.getAbsolutePath());
        }
        DirectoryScanner directoryScanner = this.getDirectoryScanner(this.dir);
        directoryScanner.scan();
        Object[] includedFiles = directoryScanner.getIncludedFiles();
        Arrays.sort(includedFiles);
        String dirPath = this.dir.getAbsolutePath();
        int n = dirPath.indexOf("_comp");
        if (n >= 0) {
            dirPath = dirPath.substring(n + 6);
        }
        this.log("Found " + includedFiles.length + " XLF file(s) to convert in " + dirPath, 2);
        int i = 0;
        while (i < includedFiles.length) {
            Object includedFile = includedFiles[i];
            this.log("Converting " + (String)includedFile, 3);
            try {
                this.convert((String)includedFile);
            }
            catch (Throwable e) {
                throw new BuildException("Error converting file " + (String)includedFile, e);
            }
            ++i;
        }
    }

    private void convert(String file) throws Exception {
        File srcFile = new File(this.dir, file);
        File destFile = new File(this.toDir, file);
        File destParent = destFile.getParentFile();
        if (!destParent.exists() && !destParent.mkdirs()) {
            throw new IOException("Couldn't create destination directory " + destParent.getAbsolutePath());
        }
        XlfWrapper xlfWrapper = new XlfWrapper(srcFile);
        String sourceLocale = xlfWrapper.getSourceLocale();
        if (sourceLocale == null) {
            throw new IllegalStateException("No source locale set in file " + file);
        }
        String destName = XlfConverter.determinePropertyFileName(srcFile.getName());
        this.writePropertyFile(destParent, destName, xlfWrapper, true);
        if (this.ivCopyMaster != null && sourceLocale.equals(this.ivCopyMaster)) {
            destName = xlfWrapper.getBaseName() + PROP_SUFFIX;
            this.writePropertyFile(destParent, destName, xlfWrapper, true);
        }
    }

    private void writePropertyFile(File destParent, String destName, XlfWrapper xlfWrapper, boolean overwrite) throws IOException {
        File dest = new File(destParent, destName);
        if (dest.exists()) {
            if (overwrite) {
                if (!dest.delete()) {
                    this.log(" couldn't delete " + dest.getAbsolutePath(), 1);
                    return;
                }
            } else {
                this.log(" skipping " + dest.getAbsolutePath() + ", file exists.", 2);
                return;
            }
        }
        Properties p = xlfWrapper.getProperties();
        FileOutputStream fos = new FileOutputStream(dest);
        p.store(fos, this.ivHeader);
        fos.close();
        this.log(" wrote " + dest.getAbsolutePath(), 3);
    }

    private static String determinePropertyFileName(String name) {
        int pos = name.lastIndexOf(46);
        if (pos >= 0) {
            name = name.substring(0, pos);
        }
        return name.concat(PROP_SUFFIX);
    }
}

