/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.buildplugin.util;

import com.sap.tc.buildplugin.api.IBuildInfo;
import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.PPReference;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Utils {
    private static Location loc = Location.getLocation((Class)(class$com$sap$tc$buildplugin$util$Utils == null ? (class$com$sap$tc$buildplugin$util$Utils = Utils.class$("com.sap.tc.buildplugin.util.Utils")) : class$com$sap$tc$buildplugin$util$Utils));
    static /* synthetic */ Class class$com$sap$tc$buildplugin$util$Utils;

    private static String getNativeLibDirFragment() {
        return "OS_libs" + File.separator + "UC" + File.separator + "ntintel" + File.separator + "32" + File.separator;
    }

    public static String extendNativeLibraryPath(String dcVendor, String dcName, String ppName, IBuildInfo buildInfo) {
        String ret = System.getProperty("java.library.path");
        try {
            File osLibDir;
            PPReference ppRef = new PPReference(ppName, new DCReference(dcName, dcVendor));
            String genFolder = buildInfo.getDevelopmentComponentInfo().getUsedPublicPartGenFolder(ppRef);
            if (genFolder != null && genFolder.length() > 0 && (osLibDir = new File(genFolder + (genFolder.endsWith(File.separator) ? "" : File.separator) + "lib" + File.separator + Utils.getNativeLibDirFragment())).isDirectory()) {
                String canonicalPath = osLibDir.getCanonicalPath();
                String newPath = System.getProperty("java.library.path", "");
                if (newPath.indexOf(canonicalPath) < 0) {
                    newPath = newPath + (newPath.endsWith(File.pathSeparator) ? "" : File.pathSeparator) + canonicalPath;
                    System.setProperty("java.library.path", newPath);
                }
            }
        }
        catch (Exception e) {
            loc.traceThrowableT(500, "", (Throwable)e);
        }
        return ret;
    }

    public static boolean isSignedJar(String path) {
        ZipFile zf = null;
        try {
            zf = new ZipFile(path);
        }
        catch (IOException e) {
            return false;
        }
        Enumeration<? extends ZipEntry> entries = zf.entries();
        HashSet<String> metaInfEntries = new HashSet<String>();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.startsWith("META-INF/")) continue;
            metaInfEntries.add(name);
        }
        try {
            zf.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        Iterator iterator = metaInfEntries.iterator();
        while (iterator.hasNext()) {
            String s = (String)iterator.next();
            if (!s.endsWith(".SF")) continue;
            String prefix = s.substring(0, s.length() - 2);
            if (metaInfEntries.contains(prefix + "DSA")) {
                return true;
            }
            if (!metaInfEntries.contains(prefix + "RSA")) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

