/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.buildplugin.util;

import com.sap.tc.buildplugin.PluginBuildInfo;
import com.sap.tc.buildplugin.api.IBuildInfo;
import com.sap.tc.buildplugin.api.IDevelopmentComponentInfo;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.PropertyElement;
import com.sap.tc.logging.Location;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JavaTools {
    private static final Location loc = Location.getLocation((Class)(class$com$sap$tc$buildplugin$util$JavaTools == null ? (class$com$sap$tc$buildplugin$util$JavaTools = JavaTools.class$("com.sap.tc.buildplugin.util.JavaTools")) : class$com$sap$tc$buildplugin$util$JavaTools));
    private PluginBuildInfo pluginBuildInfo;
    static /* synthetic */ Class class$com$sap$tc$buildplugin$util$JavaTools;

    public JavaTools() {
    }

    public JavaTools(PluginBuildInfo pluginBuildInfo) {
        this.pluginBuildInfo = pluginBuildInfo;
    }

    protected PluginBuildInfo getPluginBuildInfo() {
        return this.pluginBuildInfo;
    }

    protected void storeFile(String file, String content) throws IOException {
        this.storeFile(file, content, "UTF8");
    }

    protected void storeFile(String file, String content, String encoding) throws IOException {
        File f = new File(file);
        File parent = f.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        loc.infoT("Creating " + file);
        FileOutputStream fos = new FileOutputStream(f);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, encoding);
        BufferedWriter bw = new BufferedWriter(osw, content.length());
        bw.write(content);
        bw.flush();
        bw.close();
    }

    public Map getPropertiesAsMap(List props, String element, String namespace) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (props != null) {
            int i = 0;
            while (i < props.size()) {
                PropertyElement property = (PropertyElement)props.get(i);
                if (namespace.equals(property.getNamespace()) && element.equals(property.getName())) {
                    Iterator children = property.getChildren();
                    while (children.hasNext()) {
                        PropertyElement child = (PropertyElement)children.next();
                        result.put(child.getName(), child.getValue());
                    }
                }
                ++i;
            }
        }
        return result;
    }

    public Map getFlatPropertiesAsMap(List props, String namespace) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (props != null) {
            int i = 0;
            while (i < props.size()) {
                PropertyElement property = (PropertyElement)props.get(i);
                if (namespace.equals(property.getNamespace())) {
                    result.put(property.getName(), property.getValue());
                }
                ++i;
            }
        }
        return result;
    }

    public boolean getBooleanProperty(Map data, String key) {
        Object o = data.get(key);
        String s = String.valueOf(o);
        return "true".equalsIgnoreCase(s) || "yes".equalsIgnoreCase(s) || "on".equalsIgnoreCase(s) || "1".equals(s);
    }

    public boolean isDefinedSourceOrPackageFolder(String folder) {
        if (this.isDefinedSourceFolder(folder)) {
            return true;
        }
        return this.isDefinedPackageFolder(folder);
    }

    public boolean isDefinedSourceFolder(String folder) {
        DevelopmentComponent dc = this.getCurrentDevelopmentComponent();
        if (dc != null) {
            List folders = dc.getSourceFolders();
            if (folders != null) {
                return folders.contains(folder);
            }
            return false;
        }
        return false;
    }

    public boolean isDefinedPackageFolder(String folder) {
        DevelopmentComponent dc = this.getCurrentDevelopmentComponent();
        if (dc != null) {
            List folders = dc.getPackageFolders();
            if (folders != null) {
                return folders.contains(folder);
            }
            return false;
        }
        return false;
    }

    protected DevelopmentComponent getCurrentDevelopmentComponent() {
        IDevelopmentComponentInfo dcInfo = this.getDevelopmentComponentInfo();
        if (dcInfo != null) {
            return dcInfo.getCurrentComponent();
        }
        return null;
    }

    protected IDevelopmentComponentInfo getDevelopmentComponentInfo() {
        IBuildInfo buildInfo;
        IDevelopmentComponentInfo dcInfo = null;
        if (this.pluginBuildInfo != null && (buildInfo = this.pluginBuildInfo.getBuildInfo()) != null) {
            dcInfo = buildInfo.getDevelopmentComponentInfo();
        }
        return dcInfo;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

