/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.buildplugin.techdev.ant.util;

import com.sap.tc.buildplugin.api.IBuildInfo;
import com.sap.tc.buildplugin.api.IDevelopmentComponentInfo;
import com.sap.tc.buildplugin.techdev.ant.util.BuildManifest;
import com.sap.tc.buildplugin.util.DirScanner;
import com.sap.tc.cbs.util.Util;
import com.sap.tc.complib.BuildVariant;
import com.sap.tc.complib.Dependency;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.PPReference;
import com.sap.tc.complib.Property;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class DirsAndFiles {
    String rootDir;
    String classesDir;
    String tempDir;
    String srcDir;
    String dcName;
    String dcVendor;
    String dcCaption;
    String dcType;
    String dcSubtype;
    String dcMasterLang;
    String dcDescription;
    List deps = new ArrayList();
    List dependDirs = new ArrayList();
    List assemblyDirs = new ArrayList();
    List infrastructurePublicDirs = new ArrayList();
    List cDirs = new ArrayList();
    List dcProperties = new ArrayList();
    List packageDirs = new ArrayList();
    List sourceDirs = new ArrayList();
    Map ppMap = new HashMap();
    Map ppGenDirs = new HashMap();
    HashMap addLibs = new HashMap();
    HashMap buildOptions = new HashMap();
    HashMap jdoMap = new HashMap();
    DirScanner dirScanner = new DirScanner();
    boolean sqljFound = false;
    String genDirDeploy;
    String genDirPublic;
    String deployFile;
    String dcFile;
    String genVariantDir;
    String buildFile;
    String logDir;
    String buildLogFile;
    String rootDirPlugin;
    String cbsLocation;
    String cbsCounter;
    Location loc = Location.getLocation((Class)(class$com$sap$tc$buildplugin$techdev$ant$util$DirsAndFiles == null ? (class$com$sap$tc$buildplugin$techdev$ant$util$DirsAndFiles = DirsAndFiles.class$("com.sap.tc.buildplugin.techdev.ant.util.DirsAndFiles")) : class$com$sap$tc$buildplugin$techdev$ant$util$DirsAndFiles));
    IDevelopmentComponentInfo m_devCompInfo = null;
    IBuildInfo m_buildInfo = null;
    boolean assDepAvailability = true;
    boolean compDepAvailability = true;
    String m_errMsgComp;
    String errMsgAss;
    static /* synthetic */ Class class$com$sap$tc$buildplugin$techdev$ant$util$DirsAndFiles;

    public DirsAndFiles(IBuildInfo buildInfo) {
        List infraDirs;
        List sDirs;
        Iterator<Object> it;
        File logDirFile;
        this.m_buildInfo = buildInfo;
        this.m_devCompInfo = buildInfo.getDevelopmentComponentInfo();
        this.cbsCounter = String.valueOf(this.m_devCompInfo.getLocalBuildProperties().getBuildCounter());
        this.cbsLocation = this.m_devCompInfo.getLocalBuildProperties().getBuildLocation();
        if (this.cbsLocation == null || this.cbsLocation.length() == 0) {
            this.cbsLocation = "LOCAL";
        }
        if (this.cbsCounter.equals("0")) {
            this.cbsCounter = this.calcCounter();
        }
        this.rootDir = this.m_devCompInfo.getComponentRootFolder();
        this.loc.infoT("Root dir: " + this.rootDir);
        this.tempDir = this.m_devCompInfo.getDCVariantTempGenFolder();
        this.loc.infoT("Temp dir: " + this.tempDir);
        this.logDir = this.m_devCompInfo.getVariantGenFolder() + "logs";
        this.loc.infoT("Log dir: " + this.logDir);
        this.buildFile = this.logDir + File.separator + "build.xml";
        this.loc.infoT("Build file: " + this.buildFile);
        this.classesDir = this.tempDir + File.separator + "classes";
        this.loc.infoT("Classes dir: " + this.classesDir);
        this.buildLogFile = this.logDir + File.separator + "build.log";
        File tempDirFile = new File(this.tempDir);
        if (!tempDirFile.exists()) {
            this.loc.infoT("Creating temp dir " + this.tempDir);
            tempDirFile.mkdirs();
        }
        if (!(logDirFile = new File(this.logDir)).exists()) {
            this.loc.infoT("Creating log dir " + this.logDir);
            logDirFile.mkdirs();
        }
        this.genVariantDir = this.m_devCompInfo.getVariantGenFolder();
        this.genDirDeploy = this.m_devCompInfo.getVariantGenFolder();
        this.genDirDeploy = this.genDirDeploy + "deploy";
        this.genDirPublic = this.m_devCompInfo.getVariantGenFolder();
        this.genDirPublic = this.genDirPublic + "public";
        this.dcName = this.m_devCompInfo.getCurrentComponent().getName();
        this.dcVendor = this.m_devCompInfo.getCurrentComponent().getVendor();
        this.dcCaption = this.m_devCompInfo.getCurrentComponent().getCaption();
        this.dcType = this.m_devCompInfo.getCurrentComponent().getComponentType().getType();
        this.dcDescription = this.m_devCompInfo.getCurrentComponent().getDescription();
        this.dcSubtype = this.m_devCompInfo.getCurrentComponent().getComponentType().getSubType() != null ? this.m_devCompInfo.getCurrentComponent().getComponentType().getSubType() : "";
        Property dcMasterLangProp = this.m_devCompInfo.getCurrentComponent().getProperty("language");
        if (dcMasterLangProp == null || dcMasterLangProp.getValue().equals("")) {
            this.dcMasterLang = "en";
            this.loc.infoT("no language set in dcdef, setting default language <en>");
        } else {
            this.dcMasterLang = dcMasterLangProp.getValue();
        }
        if (this.m_devCompInfo.getCurrentComponent().getProperties() != null) {
            this.dcProperties = this.m_devCompInfo.getCurrentComponent().getProperties();
        }
        this.deployFile = this.m_devCompInfo.getCurrentComponent().getName();
        this.deployFile = this.deployFile.replace('/', '_');
        this.deployFile = this.deployFile + ".jar";
        this.dcFile = this.m_devCompInfo.getCurrentComponent().getVendor() + "~" + this.m_devCompInfo.getCurrentComponent().getName();
        this.dcFile = this.dcFile.replace('/', '~');
        this.deployFile = Util.concatenatePath((String)this.genDirDeploy, (String)this.deployFile, (char)File.separator.charAt(0));
        this.loc.infoT("Deploy file: " + this.deployFile);
        this.srcDir = this.rootDir + "src";
        this.ppMap = this.m_devCompInfo.getCurrentComponent().getPublicParts();
        if (this.ppMap != null) {
            this.loc.infoT("Public Parts: " + this.classesDir);
            it = this.ppMap.keySet().iterator();
            while (it.hasNext()) {
                String ppName = (String)it.next();
                this.loc.infoT("  pp: " + ppName);
                this.ppGenDirs.put(ppName, this.m_devCompInfo.getPublicPartGenFolder(ppName) + IBuildInfo.PLUGIN_LIBS);
            }
        }
        it = this.m_devCompInfo.getCompilationPathList().iterator();
        while (it.hasNext()) {
            File dir = new File((String)it.next());
            this.m_errMsgComp = "";
            if (dir.exists() && dir.isDirectory() && dir.list().length > 0) {
                this.loc.infoT("  build-time dependency path found: " + dir);
                this.cDirs.add(dir.toString());
            } else {
                this.compDepAvailability = false;
                this.loc.infoT("error: build-time dependency path does not exist: " + dir);
                if (this.m_errMsgComp == null || this.m_errMsgComp.length() == 0) {
                    this.m_errMsgComp = "build-time dependency path does not exist: " + dir;
                }
            }
            File javaLibDir = new File(dir, IBuildInfo.PLUGIN_LIBS);
            if (!javaLibDir.exists() || !javaLibDir.isDirectory()) continue;
            this.dependDirs.add(javaLibDir.toString());
            this.loc.infoT("  build-time dependency path for Java found: " + javaLibDir);
        }
        it = this.m_devCompInfo.getAssemblyPathList().iterator();
        String str = "";
        while (it.hasNext()) {
            str = (String)it.next();
            this.errMsgAss = "";
            File depDir = new File(str);
            if (depDir.exists() && depDir.list().length > 0) {
                this.loc.infoT("  Assembly dependency: " + str);
                this.assemblyDirs.add(str);
                continue;
            }
            this.loc.infoT(" error: Assembly dependency: " + str + " does not exist");
            this.assDepAvailability = false;
            this.errMsgAss = "Assembly dependency: " + str + " does not exist";
            this.setAssErrorMsg(this.errMsgAss);
            break;
        }
        this.deps = this.m_devCompInfo.getCurrentComponent().getDependencies();
        List packDirs = this.m_devCompInfo.getCurrentComponent().getPackageFolders();
        if (packDirs != null) {
            this.loc.infoT("PackageDirs: ");
            it = packDirs.iterator();
            while (it.hasNext()) {
                String packStr = (String)it.next();
                File f = new File(this.rootDir + packStr);
                if (f.exists()) {
                    this.loc.infoT(" Dir: " + f.getPath());
                    this.packageDirs.add(packStr);
                    continue;
                }
                this.loc.infoT(" Dir: " + f.getPath() + " doesn't exist (not added)");
            }
        }
        if ((sDirs = this.m_devCompInfo.getCurrentComponent().getSourceFolders()) != null) {
            this.loc.infoT("SourceDirs: ");
            it = sDirs.iterator();
            while (it.hasNext()) {
                String sourceStr = (String)it.next();
                File f = new File(this.rootDir + sourceStr);
                if (f.exists()) {
                    this.loc.infoT(" Dir: " + sourceStr);
                    this.sourceDirs.add(sourceStr);
                    continue;
                }
                this.loc.infoT(" Dir: " + f.getPath() + " doesn't exist (not added)");
            }
        }
        if ((infraDirs = this.m_devCompInfo.getInfrastructurePathList()) != null) {
            this.loc.infoT("Infrastructure PublicDirs: ");
            it = infraDirs.iterator();
            while (it.hasNext()) {
                String dir = (String)it.next();
                this.loc.infoT(" dir: " + dir);
                this.infrastructurePublicDirs.add(dir);
            }
        }
        BuildVariant bv = this.m_devCompInfo.getCurrentBuildVariant();
        String bvName = bv.getName();
        if (bv.getBuildOptionNames() != null) {
            List optionNames = bv.getBuildOptionNames();
            int i = 0;
            while (i < optionNames.size()) {
                List optionValues = bv.getBuildOptionValues((String)optionNames.get(i));
                int j = 0;
                while (j < optionValues.size()) {
                    String opName = (String)optionNames.get(i);
                    String opValue = (String)optionValues.get(j);
                    this.buildOptions.put(opName, opValue);
                    ++j;
                }
                ++i;
            }
        }
        int i = 0;
        while (i < this.packageDirs.size()) {
            ArrayList<String> jdoFiles = new ArrayList<String>();
            String currDir = (String)this.packageDirs.get(i);
            this.dirScanner.setSourcepath(this.rootDir + (String)packDirs.get(i));
            String[] jdo = this.dirScanner.getFiles(".jdo");
            int j = 0;
            while (j < jdo.length) {
                String fileName = jdo[j].substring(0, jdo[j].indexOf(".jdo"));
                this.loc.infoT("found jdo File: " + fileName);
                jdoFiles.add(fileName);
                ++j;
            }
            if (jdoFiles.size() > 0) {
                this.jdoMap.put(currDir, jdoFiles);
            }
            ++i;
        }
        if (this.packageDirs != null) {
            it = this.packageDirs.iterator();
            while (it.hasNext()) {
                String fs = this.rootDir + File.separator + (String)it.next();
                File f = new File(fs);
                this.checkForSqlj(f);
            }
        }
        String mfName = this.getTempDir() + File.separator + "DC_Manifest.mf";
        this.WriteManifestFile(mfName);
    }

    public String getPluginVersion() {
        return this.readPluginVersion();
    }

    public String getSrcDir() {
        return this.srcDir;
    }

    public String getSrcDirPackage() {
        return this.srcDir + File.separator + "packages";
    }

    public String getGenDirDeploy() {
        return this.genDirDeploy;
    }

    public String getGenDirPublic() {
        return this.genDirPublic;
    }

    public Map getPPGenDirs() {
        return this.ppGenDirs;
    }

    public List getDependDirs() {
        return this.dependDirs;
    }

    public List getPackageDirs() {
        return this.packageDirs;
    }

    public List getSourceDirs() {
        return this.sourceDirs;
    }

    public List getInfrastructurePublicDirs() {
        return this.infrastructurePublicDirs;
    }

    public String getClassesDir() {
        return this.classesDir;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public String getLogDir() {
        return this.logDir;
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public String getDeployFile() {
        return this.deployFile;
    }

    public String getDcFile() {
        return this.dcFile;
    }

    public String getUsedPublicPartGenFolder(PPReference ppReference) {
        return this.m_devCompInfo.getUsedPublicPartGenFolder(ppReference);
    }

    public void setBuildFile(String bf) {
        this.buildFile = this.logDir + File.separator + bf;
    }

    public String getBuildFile() {
        return this.buildFile;
    }

    public String getLogFile() {
        return this.buildLogFile;
    }

    public String getDCName() {
        return this.dcName;
    }

    public String getDCVendor() {
        return this.dcVendor;
    }

    public String getDCCaption() {
        return this.dcCaption;
    }

    public String getDCType() {
        return this.dcType;
    }

    public String getDcSubtype() {
        return this.dcSubtype;
    }

    public String getDCLanguage() {
        return this.dcMasterLang;
    }

    public Map getPublicParts() {
        return this.ppMap;
    }

    public List getDependencies() {
        return this.deps;
    }

    public void setDependencies(List deps) {
        this.deps = deps;
    }

    public List getAssemblyDirs() {
        return this.assemblyDirs;
    }

    public void setAssemblyDirs(List assemblyDirs) {
        this.assemblyDirs = assemblyDirs;
    }

    public String getCBSLocation() {
        return this.cbsLocation;
    }

    public String getCBSCounter() {
        return this.cbsCounter;
    }

    public List getDCProperties() {
        return this.dcProperties;
    }

    public String getDCDescription() {
        return this.dcDescription;
    }

    public void setDcDescription(String dcDescription) {
        this.dcDescription = dcDescription;
    }

    public HashMap getBuildOptions() {
        return this.buildOptions;
    }

    public void setBuildOptions(HashMap buildOptions) {
        this.buildOptions = buildOptions;
    }

    public DevelopmentComponent getReferencedComponent(Dependency dep) {
        return this.m_devCompInfo.getReferencedComponent(dep);
    }

    private String calcCounter() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        String tmp = cal.get(2) + 1 + "";
        if (tmp.length() == 1) {
            tmp = "0" + tmp;
        }
        String counter = cal.get(1) + tmp;
        tmp = cal.get(5) + "";
        if (tmp.length() == 1) {
            tmp = "0" + tmp;
        }
        counter = counter + tmp;
        tmp = cal.get(11) + "";
        if (tmp.length() == 1) {
            tmp = "0" + tmp;
        }
        counter = counter + tmp;
        tmp = cal.get(12) + "";
        if (tmp.length() == 1) {
            tmp = "0" + tmp;
        }
        counter = counter + tmp;
        tmp = cal.get(13) + "";
        if (tmp.length() == 1) {
            tmp = "0" + tmp;
        }
        counter = counter + tmp;
        return counter;
    }

    public HashMap getJdoMap() {
        return this.jdoMap;
    }

    public void setJdoMap(HashMap map) {
        this.jdoMap = map;
    }

    public void checkForSqlj(File folder) {
        if (folder.isDirectory()) {
            File[] content = folder.listFiles();
            if (content != null) {
                int i = 0;
                while (i < content.length) {
                    this.checkForSqlj(content[i]);
                    ++i;
                }
            }
        } else {
            String name = folder.getName();
            if (name.endsWith(".sqlj")) {
                this.sqljFound = true;
            }
        }
    }

    public boolean hasSQLJ() {
        return this.sqljFound;
    }

    public void WriteManifestFile(String fileName) {
        BuildManifest bmf = new BuildManifest(fileName);
        bmf.add("Manifest-Version", "1.0");
        bmf.add("Created-By", "DC BuildTool");
        bmf.add("Implementation-Title", this.getDCName());
        bmf.add("Specification-Vendor", "SAP AG");
        bmf.add("Implementation-Vendor-Id", this.getDCVendor());
        bmf.add("Implementation-Version", this.getCBSCounter());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat timeFormat = new SimpleDateFormat("hh:mm:ss");
        Date curTime = new Date();
        bmf.add("Build-Date", dateFormat.format(curTime));
        bmf.add("Build-Time", timeFormat.format(curTime));
        bmf.add("Build-Location", this.getCBSLocation());
        bmf.add("Build-Counter", this.getCBSCounter());
        bmf.add("DC-Name", this.getDCName());
        bmf.add("DC-Vendor", this.getDCVendor());
        bmf.add("DC-Type", this.getDCType());
        bmf.write();
    }

    public List getCompilationDirs() {
        return this.cDirs;
    }

    public void setCompilationDirs(List list) {
        this.cDirs = list;
    }

    public boolean checkAssDependencies() {
        return this.assDepAvailability;
    }

    public boolean checkCompDependencies() {
        return this.compDepAvailability;
    }

    public String getErrorMsgCompile() {
        return this.m_errMsgComp;
    }

    public void setCompErrorMsg(String errMsgComp) {
        this.m_errMsgComp = errMsgComp;
    }

    public String getErrorMsgAss() {
        return this.errMsgAss;
    }

    public void setAssErrorMsg(String errMsgAss) {
        this.errMsgAss = errMsgAss;
    }

    public String getGenVariantDir() {
        return this.genVariantDir;
    }

    public void setGenVariantDir(String genVariantDir) {
        this.genVariantDir = genVariantDir;
    }

    private String readPluginVersion() {
        String readLine = "";
        String version = "";
        File pluginRoot = new File(this.m_buildInfo.getAbsolutePluginRoot().getAbsolutePath() + File.separator + IBuildInfo.PLUGIN_LIBS);
        File[] pluginDirElements = pluginRoot.listFiles();
        String jarName = "";
        if (pluginDirElements != null) {
            int i = 0;
            while (i < pluginDirElements.length) {
                if (!pluginDirElements[i].isDirectory() && pluginDirElements[i].getName().endsWith(".jar")) {
                    jarName = pluginDirElements[i].getName();
                }
                ++i;
            }
        }
        try {
            JarFile pluginJar = new JarFile(this.m_buildInfo.getAbsolutePluginRoot().getAbsolutePath() + File.separator + IBuildInfo.PLUGIN_LIBS + File.separator + jarName);
            try {
                JarEntry versionEntry = pluginJar.getJarEntry("version.properties");
                InputStream contentStream = pluginJar.getInputStream(versionEntry);
                byte[] readSymbols = new byte[1024];
                StringBuffer buffer = new StringBuffer();
                while (contentStream.read(readSymbols) != -1) {
                    buffer.append(new String(readSymbols));
                }
                readLine = buffer.toString();
                if (readLine.startsWith("buildplugin.version")) {
                    int beginPos = readLine.indexOf("buildplugin.version=") + "buildplugin.version=".length();
                    int endPos = readLine.indexOf("\n", beginPos);
                    version = "Build Plugin Version: " + readLine.substring(beginPos, endPos);
                    beginPos = readLine.indexOf("buildplugin.release") + "buildplugin.release=".length();
                    endPos = readLine.indexOf("\n", beginPos);
                    version = version + "(" + readLine.substring(beginPos, endPos - 1) + ")";
                    beginPos = readLine.indexOf("build.date") + "build.date=".length();
                    endPos = readLine.indexOf("\n", beginPos);
                    version = version + " from " + readLine.substring(beginPos, endPos);
                }
            }
            catch (Exception e) {
                version = version + "Build Plugin Version: not known. The plugin jar doesn't contain version.properties file.";
                String msg = "version.properties doesn't exist in buildplugin jar " + jarName;
                this.loc.traceThrowableT(100, msg, (Throwable)e);
            }
        }
        catch (IOException ioe) {
            String msg = "error occurred while reading the buildplugin version";
            this.loc.traceThrowableT(100, msg, (Throwable)ioe);
        }
        return version;
    }

    public void createManifestFile(String fileName) {
        BuildManifest bmf = new BuildManifest(fileName);
        bmf.add("Manifest-Version", "1.0");
        bmf.add("Created-By", "DC BuildTool");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
        Date curTime = new Date();
        TimeZone gmtZone = TimeZone.getTimeZone("Greenwich Mean Time");
        TimeZone currZone = TimeZone.getDefault();
        String gmtDiff = "";
        int diff = TimeZone.getDefault().getOffset(0, 1, 2, 5, 7, 14);
        if (diff != 0) {
            String sign = "+";
            if (diff < 0) {
                sign = "-";
                diff = -diff;
            }
            String timeDiff = DirsAndFiles.formatTime(diff);
            gmtDiff = "(" + gmtZone.getID() + sign + timeDiff + ") " + currZone.getDisplayName();
        } else {
            gmtDiff = currZone.getID();
        }
        bmf.add("Build-Date", dateFormat.format(curTime));
        bmf.add("Build-Time", timeFormat.format(curTime) + " " + gmtDiff);
        bmf.add("Build-Location", this.getCBSLocation());
        bmf.add("Build-Counter", this.getCBSCounter());
        bmf.add("DC-Name", this.getDCName());
        bmf.add("DC-Vendor", this.getDCVendor());
        bmf.add("DC-Type", this.getDCType());
        bmf.add("PP-Type", this.getDCType());
        bmf.add("Implementation-Title", this.getDCName());
        bmf.add("Implementation-Vendor", this.getDCVendor());
        bmf.add("Implementation-Version", this.getCBSLocation() + " " + this.getCBSCounter());
        bmf.write();
    }

    static String formatTime(long millis) {
        long minutes = millis / 1000L / 60L;
        long hours = minutes / 60L;
        String time = "";
        if (hours > 0L) {
            time = hours < 10L ? "0" + Long.toString(hours) + ":" + Long.toString(minutes % 60L) + (minutes % 60L == 0L ? "0" : "") : Long.toString(hours) + ":" + Long.toString(minutes % 60L) + (minutes % 60L == 0L ? "0" : "");
        } else if (minutes > 0L) {
            time = "00:" + Long.toString(minutes % 60L);
        }
        return time;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

