/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.buildplugin.techdev.ant.util;

import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class CopyAntTask
extends Task {
    private String mPropFile = "";
    private String mPackageRoot = "";
    private String mPpTempDir = "";
    private String mPackageDir = "";
    private String mEntityName = "";
    Location loc = Location.getLocation((Class)(class$com$sap$tc$buildplugin$techdev$ant$util$CopyAntTask == null ? (class$com$sap$tc$buildplugin$techdev$ant$util$CopyAntTask = CopyAntTask.class$("com.sap.tc.buildplugin.techdev.ant.util.CopyAntTask")) : class$com$sap$tc$buildplugin$techdev$ant$util$CopyAntTask));
    static /* synthetic */ Class class$com$sap$tc$buildplugin$techdev$ant$util$CopyAntTask;

    public void execute() throws BuildException {
        if (this.mPropFile.length() <= 0) {
            this.log("[Error] Required property 'propfile' is empty: Skip task!");
            throw new BuildException("[Error] Copy task failed!");
        }
        this.loc.infoT("property 'propfile'" + this.mPropFile);
        if (this.mPackageRoot.length() <= 0) {
            this.log("[Error] Required property 'packageroot' is empty: Skip task!");
            throw new BuildException("[Error] Copy task failed!");
        }
        this.loc.infoT("property 'packageroot'" + this.mPackageRoot);
        if (this.mPpTempDir.length() <= 0) {
            this.log("[Error] Required property 'pptempdir' is empty: Skip task!");
            throw new BuildException("[Error] Copy task failed!");
        }
        this.loc.infoT("property 'pptempdir'" + this.mPpTempDir);
        if (this.mPackageDir.length() <= 0) {
            this.log("[Error] Required property 'packagedir' is empty: Skip task!");
            throw new BuildException("[Error] Copy task failed!");
        }
        this.loc.infoT("property 'packagedir'" + this.mPackageDir);
        if (this.mEntityName.length() <= 0) {
            this.log("[Error] Required property 'entityname' is empty: Skip task!");
            throw new BuildException("[Error] Copy task failed!");
        }
        this.loc.infoT("property 'entityname'" + this.mEntityName);
        this.readPropAndCopy();
    }

    private void readPropAndCopy() {
        File propFile = new File(this.mPropFile);
        Properties ppProps = new Properties();
        try {
            FileInputStream in = new FileInputStream(propFile);
            ppProps.load(in);
            in.close();
            Enumeration<?> keys = ppProps.propertyNames();
            while (keys.hasMoreElements()) {
                String name = (String)keys.nextElement();
                String value = ppProps.getProperty(name);
                if (value != null) {
                    String packageWithDots = this.mPackageDir.replace(File.separatorChar, '.');
                    String compStr = (packageWithDots = packageWithDots.replace('/', '.')) + "." + this.mEntityName;
                    if (!name.startsWith(compStr)) continue;
                    this.loc.infoT("found Name " + name + "value: " + value);
                    value = value.replace('.', File.separatorChar);
                    this.copyFile(value + ".wdinterfaceview", this.mPackageRoot, this.mPpTempDir);
                    this.copyFile(value + ".wdcontroller", this.mPackageRoot, this.mPpTempDir);
                    File searchDir = new File(this.mPackageRoot + File.separatorChar + this.mPackageDir);
                    if (!searchDir.exists()) continue;
                    String[] allFiles = searchDir.list();
                    int i = 0;
                    while (i < allFiles.length) {
                        String currentFileName = allFiles[i];
                        String propString = value;
                        int lastSlash = propString.lastIndexOf(File.separatorChar);
                        String propNameOnly = value;
                        if (lastSlash != -1) {
                            propNameOnly = propString.substring(lastSlash + 1, propString.length());
                        }
                        String endString = ".xlf";
                        String checkName1 = propNameOnly + ".wdinterfaceview_";
                        String checkName2 = propNameOnly + ".wdcontroller_";
                        if (currentFileName.startsWith(checkName1) && currentFileName.endsWith(endString) || currentFileName.startsWith(checkName2) && currentFileName.endsWith(endString)) {
                            this.copyFile(currentFileName, this.mPackageRoot + File.separatorChar + this.mPackageDir, this.mPpTempDir + File.separatorChar + this.mPackageDir);
                        }
                        ++i;
                    }
                    continue;
                }
                this.loc.infoT("no value found for key: " + name);
            }
        }
        catch (FileNotFoundException fnf) {
            String msg = "WD PP file not found";
            this.loc.traceThrowableT(500, msg, (Throwable)fnf);
        }
        catch (IOException ioe) {
            String msg = "WD PP file IOException";
            this.loc.traceThrowableT(500, msg, (Throwable)ioe);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void copyFile(String fileName, String sourceDir, String targetDir) {
        this.log("Copy file " + fileName);
        int lastSlash = fileName.lastIndexOf(File.separatorChar);
        if (lastSlash != -1) {
            String dirOnly = fileName.substring(0, lastSlash);
            new File(targetDir + File.separatorChar + dirOnly).mkdirs();
        }
        try {
            int len;
            FileInputStream in = new FileInputStream(sourceDir + File.separator + fileName);
            FileOutputStream out = new FileOutputStream(targetDir + File.separator + fileName);
            byte[] buf = new byte[4096];
            while ((len = in.read(buf)) > 0) {
                void var8_10;
                out.write(buf, 0, (int)var8_10);
            }
            out.close();
            in.close();
        }
        catch (IOException e) {
            this.log("Cannot copy PP file " + fileName + " from " + sourceDir + " to " + targetDir);
            String msg = "cannot copy PP file";
            this.loc.traceThrowableT(500, msg, (Throwable)e);
        }
    }

    public String getPackageroot() {
        return this.mPackageRoot;
    }

    public String getPptempdir() {
        return this.mPpTempDir;
    }

    public String getPropfile() {
        return this.mPropFile;
    }

    public void setPackageroot(String packageRoot) {
        this.mPackageRoot = packageRoot;
    }

    public void setPptempdir(String ppTempDir) {
        this.mPpTempDir = ppTempDir;
    }

    public void setPropfile(String propFile) {
        this.mPropFile = propFile;
    }

    public void setPackagedir(String packageDir) {
        this.mPackageDir = packageDir;
    }

    public String getPackagedir() {
        return this.mPackageDir;
    }

    public void setEntityName(String entityName) {
        this.mEntityName = entityName;
    }

    public String getEntityName() {
        return this.mEntityName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

