/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.buildplugin.techdev.ant.util;

import com.sap.tc.buildplugin.techdev.ant.util.AntLogger;
import com.sap.tc.logging.Location;
import java.io.File;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;

public class AntRunner {
    private static final String PROP_LOGLEVEL = "ant.loglevel";
    private String buildFile;
    private String logFile;
    private String tDir;
    private String pluginVersion;
    protected Vector targets;
    private String buildTarget;
    protected List buildListeners;
    protected Map userProperties;
    protected int messageOutputLevel;
    private Properties definedProps = new Properties();
    Location loc = Location.getLocation((Class)(class$com$sap$tc$buildplugin$techdev$ant$util$AntRunner == null ? (class$com$sap$tc$buildplugin$techdev$ant$util$AntRunner = AntRunner.class$("com.sap.tc.buildplugin.techdev.ant.util.AntRunner")) : class$com$sap$tc$buildplugin$techdev$ant$util$AntRunner));
    static /* synthetic */ Class class$com$sap$tc$buildplugin$techdev$ant$util$AntRunner;

    public AntRunner() {
        String logLevel = System.getProperty(PROP_LOGLEVEL);
        if ("error".equalsIgnoreCase(logLevel)) {
            this.messageOutputLevel = 0;
        } else if ("warning".equalsIgnoreCase(logLevel)) {
            this.messageOutputLevel = 1;
        } else if ("info".equalsIgnoreCase(logLevel)) {
            this.messageOutputLevel = 2;
        } else if ("verbose".equalsIgnoreCase(logLevel)) {
            this.messageOutputLevel = 3;
        } else if ("debug".equalsIgnoreCase(logLevel)) {
            this.messageOutputLevel = 4;
        } else {
            this.messageOutputLevel = 2;
            if (logLevel != null) {
                this.loc.infoT("property \"ant.loglevel\" should be set to one of {error, warning, info, verbose, debug}. Using default value \"info\".");
            }
        }
    }

    public int run() {
        int rc;
        block8: {
            rc = 0;
            Project project = new Project();
            Throwable error = null;
            this.loc.infoT("\tBuild file " + this.buildFile);
            this.loc.infoT("\tBuild target: " + this.buildTarget);
            this.loc.infoT("\tLog file: " + this.logFile);
            AntLogger logger = null;
            try {
                block7: {
                    try {
                        logger = new AntLogger();
                        logger.setLog(this.logFile);
                        logger.setTDir(this.tDir);
                        logger.setMessageOutputLevel(this.messageOutputLevel);
                        logger.setPluginVersion(this.pluginVersion);
                        logger.init();
                        project.addBuildListener((BuildListener)logger);
                        project.init();
                        Enumeration e = ((Hashtable)this.definedProps).keys();
                        while (e.hasMoreElements()) {
                            String name = (String)e.nextElement();
                            String value = (String)((Hashtable)this.definedProps).get(name);
                            project.setProperty(name, value);
                        }
                        this.setProperties("ant.file", this.buildFile);
                        project.setUserProperty("build.sysclasspath", "ignore");
                        File bf = new File(this.buildFile);
                        ProjectHelper.configureProject((Project)project, (File)bf);
                        this.fireBuildStarted(project);
                        if (this.targets != null && !this.targets.isEmpty()) {
                            project.executeTargets(this.targets);
                            break block7;
                        }
                        project.executeTarget(project.getDefaultTarget());
                    }
                    catch (RuntimeException e) {
                        error = e;
                        rc = 1;
                        String msg = "build finished with RuntimeException: ";
                        this.loc.traceThrowableT(500, msg, (Throwable)e);
                        Object var9_13 = null;
                        this.fireBuildFinished(project, error);
                        logger.exit();
                        break block8;
                    }
                    catch (Error e) {
                        error = e;
                        rc = 1;
                        String msg = "build with errors ";
                        this.loc.traceThrowableT(500, msg, (Throwable)e);
                        Object var9_14 = null;
                        this.fireBuildFinished(project, error);
                        logger.exit();
                    }
                }
                Object var9_12 = null;
                this.fireBuildFinished(project, error);
                logger.exit();
            }
            catch (Throwable throwable) {
                Object var9_15 = null;
                this.fireBuildFinished(project, error);
                logger.exit();
                throw throwable;
            }
        }
        return rc;
    }

    public void setBuildFile(String name) {
        this.buildFile = name;
    }

    public void setTarget(String name) {
        this.buildTarget = name;
        this.targets = new Vector();
        this.targets.add(this.buildTarget);
    }

    public void setLogfile(String name) {
        this.logFile = name;
    }

    public void setTDir(String name) {
        this.tDir = name;
    }

    public void setPluginVersion(String pluginVersion) {
        this.pluginVersion = pluginVersion;
    }

    public void setProperties(String name, String value) {
        ((Hashtable)this.definedProps).put(name, value);
    }

    private void fireBuildStarted(Project project) {
        BuildEvent event = new BuildEvent(project);
        Iterator iterator = ((AbstractList)project.getBuildListeners()).iterator();
        while (iterator.hasNext()) {
            BuildListener listener = (BuildListener)iterator.next();
            listener.buildStarted(event);
        }
    }

    private void fireBuildFinished(Project project, Throwable error) {
        BuildEvent event = new BuildEvent(project);
        event.setException(error);
        Iterator iterator = ((AbstractList)project.getBuildListeners()).iterator();
        while (iterator.hasNext()) {
            BuildListener listener = (BuildListener)iterator.next();
            listener.buildFinished(event);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

